/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.block;

import cubex2.cs3.block.BlockCS;
import cubex2.cs3.block.attributes.TrapDoorAttributes;
import cubex2.cs3.common.WrappedBlock;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCSTrapDoor
extends BlockCS {
    private TrapDoorAttributes container;

    public BlockCSTrapDoor(WrappedBlock block) {
        super(block);
        this.container = (TrapDoorAttributes)block.container;
        this.func_149649_H();
        float f = 0.5f;
        float f1 = 1.0f;
        this.func_149676_a(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, f1, 0.5f + f);
    }

    @Override
    public boolean func_149662_c() {
        return false;
    }

    @Override
    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149655_b(IBlockAccess world, int x, int y, int z) {
        return !BlockCSTrapDoor.isTrapdoorOpen(world.func_72805_g(x, y, z));
    }

    public int func_149645_b() {
        return 0;
    }

    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return super.func_149633_g(world, x, y, z);
    }

    @Override
    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return super.func_149668_a(world, x, y, z);
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        this.setBlockBoundsForBlockRender(world.func_72805_g(x, y, z));
    }

    public void func_149683_g() {
        float var1 = 0.1875f;
        this.func_149676_a(0.0f, 0.5f - var1 / 2.0f, 0.0f, 1.0f, 0.5f + var1 / 2.0f, 1.0f);
    }

    public void setBlockBoundsForBlockRender(int md) {
        float var2 = 0.1875f;
        if ((md & 8) != 0) {
            this.func_149676_a(0.0f, 1.0f - var2, 0.0f, 1.0f, 1.0f, 1.0f);
        } else {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, var2, 1.0f);
        }
        if (BlockCSTrapDoor.isTrapdoorOpen(md)) {
            if ((md & 3) == 0) {
                this.func_149676_a(0.0f, 0.0f, 1.0f - var2, 1.0f, 1.0f, 1.0f);
            }
            if ((md & 3) == 1) {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, var2);
            }
            if ((md & 3) == 2) {
                this.func_149676_a(1.0f - var2, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            }
            if ((md & 3) == 3) {
                this.func_149676_a(0.0f, 0.0f, 0.0f, var2, 1.0f, 1.0f);
            }
        }
    }

    @Override
    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        super.func_149699_a(world, x, y, z, player);
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int facing, float hitX, float hitY, float hitZ) {
        super.func_149727_a(world, x, y, z, player, facing, hitX, hitY, hitZ);
        this.switchState(world, x, y, z, player);
        return true;
    }

    public void switchState(World world, int x, int y, int z, EntityPlayer player) {
        if (!this.container.redstoneOnly) {
            int meta = world.func_72805_g(x, y, z);
            world.func_72921_c(x, y, z, meta ^ 4, 2);
            world.func_72889_a(player, 1003, x, y, z, 0);
        }
    }

    public void onPoweredBlockChange(World world, int x, int y, int z, boolean indirectly) {
        boolean var7;
        int meta = world.func_72805_g(x, y, z);
        boolean bl = var7 = (meta & 4) > 0;
        if (var7 != indirectly) {
            world.func_72921_c(x, y, z, meta ^ 4, 2);
            world.func_72889_a((EntityPlayer)null, 1003, x, y, z, 0);
        }
    }

    @Override
    public void func_149695_a(World world, int x, int y, int z, Block neighborBlock) {
        if (!world.field_72995_K) {
            boolean var9;
            int meta = world.func_72805_g(x, y, z);
            int var7 = x;
            int var8 = z;
            if ((meta & 3) == 0) {
                var8 = z + 1;
            }
            if ((meta & 3) == 1) {
                --var8;
            }
            if ((meta & 3) == 2) {
                var7 = x + 1;
            }
            if ((meta & 3) == 3) {
                --var7;
            }
            if (!BlockCSTrapDoor.isValidSupportBlock(world.func_147439_a(var7, y, var8)) && !world.isSideSolid(var7, y, var8, ForgeDirection.getOrientation((int)((meta & 3) + 2)))) {
                world.func_147468_f(x, y, z);
                this.func_149697_b(world, x, y, z, meta, 0);
            }
            if ((var9 = world.func_72864_z(x, y, z)) || neighborBlock.func_149744_f()) {
                this.onPoweredBlockChange(world, x, y, z, var9);
            }
        }
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 par5Vec3D, Vec3 par6Vec3D) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return super.func_149731_a(world, x, y, z, par5Vec3D, par6Vec3D);
    }

    @Override
    public int func_149660_a(World world, int x, int y, int z, int facing, float hitX, float hitY, float hitZ, int metadata) {
        super.func_149660_a(world, x, y, z, facing, hitX, hitY, hitZ, metadata);
        int meta = 0;
        if (facing == 2) {
            meta = 0;
        }
        if (facing == 3) {
            meta = 1;
        }
        if (facing == 4) {
            meta = 2;
        }
        if (facing == 5) {
            meta = 3;
        }
        if (facing != 1 && facing != 0 && hitY > 0.5f) {
            meta |= 8;
        }
        return meta;
    }

    @Override
    public boolean func_149707_d(World world, int x, int y, int z, int side) {
        if (side == 0) {
            return false;
        }
        if (side == 1) {
            return false;
        }
        if (side == 2) {
            ++z;
        }
        if (side == 3) {
            --z;
        }
        if (side == 4) {
            ++x;
        }
        if (side == 5) {
            --x;
        }
        return BlockCSTrapDoor.isValidSupportBlock(world.func_147439_a(x, y, z)) || world.isSideSolid(x, y, z, ForgeDirection.UP);
    }

    public static boolean isTrapdoorOpen(int md) {
        return (md & 4) != 0;
    }

    private static boolean isValidSupportBlock(Block block) {
        if (block == Blocks.field_150350_a) {
            return false;
        }
        return block != null && block.func_149688_o().func_76218_k() && block.func_149686_d() || block == Blocks.field_150426_aN;
    }
}

