/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.block;

import cubex2.cs3.block.BlockCS;
import cubex2.cs3.block.BlockCSFence;
import cubex2.cs3.block.BlockCSStairs;
import cubex2.cs3.block.attributes.TorchAttributes;
import cubex2.cs3.common.WrappedBlock;
import cubex2.cs3.lib.RenderIds;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCSTorch
extends BlockCS {
    private TorchAttributes container;

    public BlockCSTorch(WrappedBlock block) {
        super(block);
        this.container = (TorchAttributes)block.container;
        this.func_149675_a(true);
    }

    @Override
    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    @Override
    public boolean func_149662_c() {
        return false;
    }

    @Override
    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return RenderIds.torchRenderId;
    }

    @Override
    public IIcon func_149691_a(int side, int meta) {
        return this.wrappedBlock.getIcon(0, 0);
    }

    private boolean canPlaceTorchOn(World world, int x, int y, int z) {
        if (!this.container.canPlaceOnFloor) {
            return false;
        }
        if (World.func_147466_a((IBlockAccess)world, (int)x, (int)y, (int)z)) {
            return true;
        }
        Block block = world.func_147439_a(x, y, z);
        if (block != Blocks.field_150422_aJ && block != Blocks.field_150386_bk && block != Blocks.field_150359_w && !(block instanceof BlockCSFence)) {
            int metadata;
            return block != null && (block instanceof BlockStairs || block instanceof BlockCSStairs) && (4 & (metadata = world.func_72805_g(x, y, z))) != 0;
        }
        return true;
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        boolean floor = this.canPlaceTorchOn(world, x, y - 1, z) && this.container.canPlaceOnFloor;
        boolean wall = (world.isSideSolid(x - 1, y, z, ForgeDirection.EAST) || world.isSideSolid(x + 1, y, z, ForgeDirection.WEST) || world.isSideSolid(x, y, z - 1, ForgeDirection.SOUTH) || world.isSideSolid(x, y, z + 1, ForgeDirection.NORTH)) && this.container.canPlaceOnWall;
        boolean ceiling = world.isSideSolid(x, y + 1, z, ForgeDirection.DOWN) && this.container.canPlaceOnCeiling;
        return floor || wall || ceiling;
    }

    @Override
    public boolean func_149707_d(World world, int x, int y, int z, int side) {
        return this.func_149742_c(world, x, y, z);
    }

    @Override
    public int func_149660_a(World world, int x, int y, int z, int facing, float hitX, float hitY, float hitZ, int metadata) {
        super.func_149660_a(world, x, y, z, facing, hitX, hitY, hitZ, metadata);
        int meta = metadata;
        if (this.container.canPlaceOnCeiling && facing == 0 && world.isSideSolid(x, y + 1, z, ForgeDirection.DOWN)) {
            meta = 6;
        }
        if (this.container.canPlaceOnFloor && facing == 1 && this.canPlaceTorchOn(world, x, y - 1, z)) {
            meta = 5;
        }
        if (this.container.canPlaceOnWall) {
            if (facing == 2 && world.isSideSolid(x, y, z + 1, ForgeDirection.NORTH)) {
                meta = 4;
            }
            if (facing == 3 && world.isSideSolid(x, y, z - 1, ForgeDirection.SOUTH)) {
                meta = 3;
            }
            if (facing == 4 && world.isSideSolid(x + 1, y, z, ForgeDirection.WEST)) {
                meta = 2;
            }
            if (facing == 5 && world.isSideSolid(x - 1, y, z, ForgeDirection.EAST)) {
                meta = 1;
            }
        }
        return meta;
    }

    @Override
    public void func_149674_a(World world, int x, int y, int z, Random random) {
        super.func_149674_a(world, x, y, z, random);
        if (world.func_72805_g(x, y, z) == 0) {
            this.setMetadata(world, x, y, z);
        }
    }

    @Override
    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        if (world.func_72805_g(x, y, z) == 0) {
            this.setMetadata(world, x, y, z);
        }
        this.dropTorchIfCantStay(world, x, y, z);
    }

    private void setMetadata(World world, int x, int y, int z) {
        if (this.container.canPlaceOnWall) {
            if (world.isSideSolid(x - 1, y, z, ForgeDirection.EAST)) {
                world.func_72921_c(x, y, z, 1, 2);
            } else if (world.isSideSolid(x + 1, y, z, ForgeDirection.WEST)) {
                world.func_72921_c(x, y, z, 2, 2);
            } else if (world.isSideSolid(x, y, z - 1, ForgeDirection.SOUTH)) {
                world.func_72921_c(x, y, z, 3, 2);
            } else if (world.isSideSolid(x, y, z + 1, ForgeDirection.NORTH)) {
                world.func_72921_c(x, y, z, 4, 2);
            }
        }
        if (this.container.canPlaceOnFloor && this.canPlaceTorchOn(world, x, y - 1, z)) {
            world.func_72921_c(x, y, z, 5, 2);
        }
        if (this.container.canPlaceOnCeiling && world.isSideSolid(x, y + 1, z, ForgeDirection.DOWN)) {
            world.func_72921_c(x, y, z, 6, 2);
        }
        this.dropTorchIfCantStay(world, x, y, z);
    }

    @Override
    public void func_149695_a(World world, int x, int y, int z, Block neighborBlock) {
        super.func_149695_a(world, x, y, z, neighborBlock);
        if (this.dropTorchIfCantStay(world, x, y, z)) {
            int metadata = world.func_72805_g(x, y, z);
            boolean removeTorch = false;
            if (!(world.isSideSolid(x - 1, y, z, ForgeDirection.EAST) && this.container.canPlaceOnWall || metadata != 1)) {
                removeTorch = true;
            }
            if (!(world.isSideSolid(x + 1, y, z, ForgeDirection.WEST) && this.container.canPlaceOnWall || metadata != 2)) {
                removeTorch = true;
            }
            if (!(world.isSideSolid(x, y, z - 1, ForgeDirection.SOUTH) && this.container.canPlaceOnWall || metadata != 3)) {
                removeTorch = true;
            }
            if (!(world.isSideSolid(x, y, z + 1, ForgeDirection.NORTH) && this.container.canPlaceOnWall || metadata != 4)) {
                removeTorch = true;
            }
            if (!(this.canPlaceTorchOn(world, x, y - 1, z) && this.container.canPlaceOnFloor || metadata != 5)) {
                removeTorch = true;
            }
            if (!(world.isSideSolid(x, y + 1, z, ForgeDirection.DOWN) && this.container.canPlaceOnCeiling || metadata != 6)) {
                removeTorch = true;
            }
            if (removeTorch) {
                this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
                world.func_147468_f(x, y, z);
            }
        }
    }

    private boolean dropTorchIfCantStay(World world, int x, int y, int z) {
        if (!this.func_149742_c(world, x, y, z)) {
            if (world.func_147439_a(x, y, z) == this) {
                this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
                world.func_147468_f(x, y, z);
            }
            return false;
        }
        return true;
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 vec1, Vec3 vec2) {
        int metadata = world.func_72805_g(x, y, z) & 7;
        float f = 0.15f;
        if (metadata == 1) {
            this.func_149676_a(0.0f, 0.2f, 0.5f - f, f * 2.0f, 0.8f, 0.5f + f);
        } else if (metadata == 2) {
            this.func_149676_a(1.0f - f * 2.0f, 0.2f, 0.5f - f, 1.0f, 0.8f, 0.5f + f);
        } else if (metadata == 3) {
            this.func_149676_a(0.5f - f, 0.2f, 0.0f, 0.5f + f, 0.8f, f * 2.0f);
        } else if (metadata == 4) {
            this.func_149676_a(0.5f - f, 0.2f, 1.0f - f * 2.0f, 0.5f + f, 0.8f, 1.0f);
        } else if (metadata == 5) {
            f = 0.1f;
            this.func_149676_a(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, 0.6f, 0.5f + f);
        } else {
            f = 0.1f;
            this.func_149676_a(0.5f - f, 0.4f, 0.5f - f, 0.5f + f, 1.0f, 0.5f + f);
        }
        return super.func_149731_a(world, x, y, z, vec1, vec2);
    }

    @Override
    public void func_149734_b(World world, int x, int y, int z, Random random) {
        if (this.container.particles) {
            int l = world.func_72805_g(x, y, z);
            double posX = (float)x + 0.5f;
            double posY = (float)y + 0.7f;
            double posY2 = (float)y + 0.4f;
            double posZ = (float)z + 0.5f;
            double d3 = 0.22f;
            double d4 = 0.27f;
            if (l == 1) {
                world.func_72869_a("smoke", posX - d4, posY + d3, posZ, 0.0, 0.0, 0.0);
                world.func_72869_a("flame", posX - d4, posY + d3, posZ, 0.0, 0.0, 0.0);
            } else if (l == 2) {
                world.func_72869_a("smoke", posX + d4, posY + d3, posZ, 0.0, 0.0, 0.0);
                world.func_72869_a("flame", posX + d4, posY + d3, posZ, 0.0, 0.0, 0.0);
            } else if (l == 3) {
                world.func_72869_a("smoke", posX, posY + d3, posZ - d4, 0.0, 0.0, 0.0);
                world.func_72869_a("flame", posX, posY + d3, posZ - d4, 0.0, 0.0, 0.0);
            } else if (l == 4) {
                world.func_72869_a("smoke", posX, posY + d3, posZ + d4, 0.0, 0.0, 0.0);
                world.func_72869_a("flame", posX, posY + d3, posZ + d4, 0.0, 0.0, 0.0);
            } else if (l == 5) {
                world.func_72869_a("smoke", posX, posY, posZ, 0.0, 0.0, 0.0);
                world.func_72869_a("flame", posX, posY, posZ, 0.0, 0.0, 0.0);
            } else {
                world.func_72869_a("smoke", posX, posY2, posZ, 0.0, 0.0, 0.0);
                world.func_72869_a("flame", posX, posY2, posZ, 0.0, 0.0, 0.0);
            }
        }
    }
}

