/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.block;

import cubex2.cs3.block.BlockCS;
import cubex2.cs3.block.attributes.GravityAttributes;
import cubex2.cs3.common.WrappedBlock;
import cubex2.cs3.entity.EntityCSGravityBlock;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCSGravity
extends BlockCS {
    private GravityAttributes container;

    public BlockCSGravity(WrappedBlock block) {
        super(block);
        this.container = (GravityAttributes)block.container;
    }

    @Override
    public boolean func_149686_d() {
        return true;
    }

    @Override
    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world));
    }

    @Override
    public void func_149695_a(World world, int x, int y, int z, Block neighborBlock) {
        super.func_149695_a(world, x, y, z, neighborBlock);
        world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world));
    }

    @Override
    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        super.func_149674_a(world, x, y, z, rand);
        if (!world.field_72995_K) {
            this.tryToApplyGravity(world, x, y, z);
        }
    }

    private void tryToApplyGravity(World world, int x, int y, int z) {
        int byte1;
        int md = world.func_72805_g(x, y, z);
        if (BlockCSGravity.canFallAt(world, x, y + (this.container.hasAntiGravity ? 1 : -1), z) && y >= 0 && y <= 255 && world.func_72904_c(x - (byte1 = 32), y - byte1, z - byte1, x + byte1, y + byte1, z + byte1) && !world.field_72995_K) {
            EntityCSGravityBlock gravityBlock = new EntityCSGravityBlock(world, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, this, md);
            world.func_72838_d((Entity)gravityBlock);
        }
    }

    public static boolean canFallAt(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block.isAir((IBlockAccess)world, x, y, z)) {
            return true;
        }
        if (block == Blocks.field_150480_ab) {
            return true;
        }
        Material material = block.func_149688_o();
        return material == Material.field_151586_h ? true : material == Material.field_151587_i;
    }
}

