/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cubex2.cs3.block.IBlockCS;
import cubex2.cs3.block.attributes.FluidAttributes;
import cubex2.cs3.common.BaseContentPack;
import cubex2.cs3.common.WrappedBlock;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class BlockCSFluid
extends BlockFluidClassic
implements IBlockCS {
    protected BaseContentPack pack;
    protected WrappedBlock wrappedBlock;
    protected FluidAttributes container;

    public BlockCSFluid(WrappedBlock block) {
        super(BlockCSFluid.createFluid((FluidAttributes)block.container), block.container.material);
        this.pack = block.getPack();
        this.wrappedBlock = block;
        this.container = (FluidAttributes)this.wrappedBlock.container;
    }

    private static Fluid createFluid(FluidAttributes container) {
        Fluid fluid = new Fluid(container.getPack().getName());
        fluid.setLuminosity(container.light);
        fluid.setDensity(container.density);
        fluid.setViscosity(container.viscosity);
        fluid.setGaseous(container.gaseous);
        FluidRegistry.registerFluid((Fluid)fluid);
        return fluid;
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        this.wrappedBlock.updateTick(world, x, y, z, rand);
        if (this.container.infiniteSource && !this.isSourceBlock((IBlockAccess)world, x, y, z)) {
            int adjacentSourceBlocks = 0;
            if (this.isSourceBlock((IBlockAccess)world, x + 1, y, z)) {
                ++adjacentSourceBlocks;
            }
            if (this.isSourceBlock((IBlockAccess)world, x - 1, y, z)) {
                ++adjacentSourceBlocks;
            }
            if (this.isSourceBlock((IBlockAccess)world, x, y, z + 1)) {
                ++adjacentSourceBlocks;
            }
            if (this.isSourceBlock((IBlockAccess)world, x, y, z - 1)) {
                ++adjacentSourceBlocks;
            }
            if (adjacentSourceBlocks >= 2) {
                world.func_72921_c(x, y, z, 0, 3);
            }
        }
        super.func_149674_a(world, x, y, z, rand);
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willDestroy) {
        boolean removed = world.func_147468_f(x, y, z);
        this.wrappedBlock.removedByPlayer(world, player, x, y, z);
        return removed;
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighborBlock) {
        this.wrappedBlock.onNeighborBlockChange(world, x, y, z, neighborBlock);
        super.func_149695_a(world, x, y, z, neighborBlock);
    }

    public void func_149726_b(World world, int x, int y, int z) {
        this.wrappedBlock.onBlockAdded(world, x, y, z);
        super.func_149726_b(world, x, y, z);
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        this.wrappedBlock.onBlockBreak(world, x, y, z, block, meta);
        super.func_149749_a(world, x, y, z, block, meta);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int facing, float hitX, float hitY, float hitZ) {
        return this.wrappedBlock.blockActivated(world, x, y, z, player, facing, hitX, hitY, hitZ);
    }

    public void func_149724_b(World world, int x, int y, int z, Entity entity) {
        this.wrappedBlock.onEntityWalking(world, x, y, z, entity);
        super.func_149724_b(world, x, y, z, entity);
    }

    public int func_149660_a(World world, int x, int y, int z, int facing, float hitX, float hitY, float hitZ, int metadata) {
        this.wrappedBlock.onBlockPlaced(world, x, y, z, facing, hitX, hitY, hitZ);
        return metadata;
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        this.wrappedBlock.onBlockClicked(world, x, y, z, player);
        super.func_149699_a(world, x, y, z, player);
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        this.wrappedBlock.onEntityCollidedWithBlock(world, x, y, z, entity);
        super.func_149670_a(world, x, y, z, entity);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase living, ItemStack stack) {
        this.wrappedBlock.onBlockPlacedBy(world, x, y, z, living);
        super.func_149689_a(world, x, y, z, living, stack);
    }

    public void func_149746_a(World world, int x, int y, int z, Entity entity, float fallDistance) {
        this.wrappedBlock.onFallenUpon(world, x, y, z, entity, fallDistance);
        super.func_149746_a(world, x, y, z, entity, fallDistance);
    }

    public void func_149734_b(World world, int x, int y, int z, Random random) {
        this.wrappedBlock.randomDisplayTick(world, x, y, z, random);
    }

    public IIcon func_149691_a(int side, int meta) {
        return side != 0 && side != 1 ? this.container.textureFlowing.icon : this.container.textureStill.icon;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.wrappedBlock.registerBlockIcons(iconRegister);
        this.stack.getFluid().setStillIcon(this.container.textureStill.icon);
        this.stack.getFluid().setFlowingIcon(this.container.textureFlowing.icon);
    }

    public float func_149712_f(World world, int x, int y, int z) {
        return this.wrappedBlock.getHardness(world.func_72805_g(x, y, z));
    }

    public float getExplosionResistance(Entity entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        return this.wrappedBlock.getExplosionResistance(entity, world, x, y, z, explosionX, explosionY, explosionZ);
    }

    public void func_149666_a(Item item, CreativeTabs tab, List list) {
    }

    public CreativeTabs func_149708_J() {
        return this.wrappedBlock.getCreativeTabToDisplayOn();
    }

    public boolean isFireSource(World world, int x, int y, int z, ForgeDirection side) {
        return this.wrappedBlock.isFireSource(world, x, y, z, side);
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return this.wrappedBlock.getFlammability(world, x, y, z, side);
    }

    public int getFireSpreadSpeed(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return this.wrappedBlock.getFireSpreadSpeed(world, x, y, z, side);
    }

    public boolean isBurning(IBlockAccess world, int x, int y, int z) {
        return this.wrappedBlock.isBurning(world, x, y, z);
    }

    public boolean func_149707_d(World world, int x, int y, int z, int side) {
        return this.wrappedBlock.canPlaceBlockOnSide(world, x, y, z, side);
    }

    @Override
    public WrappedBlock getWrappedBlock() {
        return this.wrappedBlock;
    }
}

