/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cubex2.cs3.block.BlockCSFacing;
import cubex2.cs3.common.WrappedBlock;
import cubex2.cs3.lib.RenderIds;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCSFlat
extends BlockCSFacing {
    protected double rotationDegree = 0.0;
    private RenderGlobal worldObj;

    public BlockCSFlat(WrappedBlock block) {
        super(block);
        this.func_149675_a(true);
    }

    @Override
    public int getMetaForFlowerGen(int itemMeta) {
        return 1;
    }

    @Override
    public IIcon func_149691_a(int side, int meta) {
        return this.wrappedBlock.getIcon(0, meta);
    }

    @Override
    public boolean func_149662_c() {
        return false;
    }

    @Override
    public boolean func_149686_d() {
        return false;
    }

    @Override
    public int func_149645_b() {
        return RenderIds.flatRenderId;
    }

    @Override
    public boolean func_149707_d(World world, int x, int y, int z, int side) {
        ForgeDirection direction = ForgeDirection.getOrientation((int)side);
        return super.func_149707_d(world, x, y, z, side) ? world.isSideSolid(x - direction.offsetX, y - direction.offsetY, z - direction.offsetZ, direction) : false;
    }

    @Override
    public void func_149695_a(World world, int x, int y, int z, Block neighborBlock) {
        super.func_149695_a(world, x, y, z, neighborBlock);
        this.checkFlowerChange(world, x, y, z);
    }

    @Override
    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        super.func_149674_a(world, x, y, z, rand);
        this.checkFlowerChange(world, x, y, z);
        if (this.rotationDegree > 0.0) {
            this.rotationDegree += 11.25;
            if (this.rotationDegree >= 360.0) {
                this.rotationDegree -= 360.0;
            }
        }
    }

    protected final void checkFlowerChange(World world, int x, int y, int z) {
        if (!this.func_149718_j(world, x, y, z)) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147468_f(x, y, z);
        }
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z) & 7;
        return this.canBlockStay(world, x, y, z, meta);
    }

    public boolean canBlockStay(World world, int x, int y, int z, int meta) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)meta).getOpposite();
        return world.isSideSolid(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, dir);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z) & 7;
        float minX = 0.0f;
        float minY = 0.0f;
        float minZ = 0.0f;
        float maxX = 1.0f;
        float maxY = 1.0f;
        float maxZ = 1.0f;
        if (meta == 0) {
            minY = maxY - 0.05f;
        } else if (meta == 1) {
            maxY = 0.05f;
        } else if (meta == 2) {
            minZ = maxZ - 0.05f;
        } else if (meta == 3) {
            maxZ = 0.05f;
        } else if (meta == 4) {
            minX = maxX - 0.05f;
        } else if (meta == 5) {
            maxX = 0.05f;
        }
        return AxisAlignedBB.func_72330_a((double)((float)x + minX), (double)((float)y + minY), (double)((float)z + minZ), (double)((float)x + maxX), (double)((float)y + maxY), (double)((float)z + maxZ));
    }

    @Override
    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 startVec, Vec3 endVec) {
        int meta = world.func_72805_g(x, y, z) & 7;
        float minX = 0.0f;
        float minY = 0.0f;
        float minZ = 0.0f;
        float maxX = 1.0f;
        float maxY = 1.0f;
        float maxZ = 1.0f;
        if (meta == 0) {
            minY = maxY;
        } else if (meta == 1) {
            maxY = 0.0f;
        } else if (meta == 2) {
            minZ = maxZ - 0.05f;
        } else if (meta == 3) {
            maxZ = 0.05f;
        } else if (meta == 4) {
            minX = maxX - 0.05f;
        } else if (meta == 5) {
            maxX = 0.05f;
        }
        startVec = startVec.func_72441_c((double)(-x), (double)(-y), (double)(-z));
        endVec = endVec.func_72441_c((double)(-x), (double)(-y), (double)(-z));
        Vec3 vec32 = startVec.func_72429_b(endVec, (double)minX);
        Vec3 vec33 = startVec.func_72429_b(endVec, (double)maxX);
        Vec3 vec34 = startVec.func_72435_c(endVec, (double)minY);
        Vec3 vec35 = startVec.func_72435_c(endVec, (double)maxY);
        Vec3 vec36 = startVec.func_72434_d(endVec, (double)minZ);
        Vec3 vec37 = startVec.func_72434_d(endVec, (double)maxZ);
        if (!this.isVecInsideYZBounds(vec32, minY, maxY, minZ, maxZ)) {
            vec32 = null;
        }
        if (!this.isVecInsideYZBounds(vec33, minY, maxY, minZ, maxZ)) {
            vec33 = null;
        }
        if (!this.isVecInsideXZBounds(vec34, minX, maxX, minZ, maxZ)) {
            vec34 = null;
        }
        if (!this.isVecInsideXZBounds(vec35, minX, maxX, minZ, maxZ)) {
            vec35 = null;
        }
        if (!this.isVecInsideXYBounds(vec36, minX, maxX, minY, maxY)) {
            vec36 = null;
        }
        if (!this.isVecInsideXYBounds(vec37, minX, maxX, minY, maxY)) {
            vec37 = null;
        }
        Vec3 vec38 = null;
        if (vec32 != null && (vec38 == null || startVec.func_72436_e(vec32) < startVec.func_72436_e(vec38))) {
            vec38 = vec32;
        }
        if (vec33 != null && (vec38 == null || startVec.func_72436_e(vec33) < startVec.func_72436_e(vec38))) {
            vec38 = vec33;
        }
        if (vec34 != null && (vec38 == null || startVec.func_72436_e(vec34) < startVec.func_72436_e(vec38))) {
            vec38 = vec34;
        }
        if (vec35 != null && (vec38 == null || startVec.func_72436_e(vec35) < startVec.func_72436_e(vec38))) {
            vec38 = vec35;
        }
        if (vec36 != null && (vec38 == null || startVec.func_72436_e(vec36) < startVec.func_72436_e(vec38))) {
            vec38 = vec36;
        }
        if (vec37 != null && (vec38 == null || startVec.func_72436_e(vec37) < startVec.func_72436_e(vec38))) {
            vec38 = vec37;
        }
        if (vec38 == null) {
            return null;
        }
        int b0 = -1;
        if (vec38 == vec32) {
            b0 = 4;
        }
        if (vec38 == vec33) {
            b0 = 5;
        }
        if (vec38 == vec34) {
            b0 = 0;
        }
        if (vec38 == vec35) {
            b0 = 1;
        }
        if (vec38 == vec36) {
            b0 = 2;
        }
        if (vec38 == vec37) {
            b0 = 3;
        }
        return new MovingObjectPosition(x, y, z, b0, vec38.func_72441_c((double)x, (double)y, (double)z));
    }

    private boolean isVecInsideYZBounds(Vec3 vec3, float minY, float maxY, float minZ, float maxZ) {
        return vec3 == null ? false : vec3.field_72448_b >= (double)minY && vec3.field_72448_b <= (double)maxY && vec3.field_72449_c >= (double)minZ && vec3.field_72449_c <= (double)maxZ;
    }

    private boolean isVecInsideXZBounds(Vec3 vec3, float minX, float maxX, float minZ, float maxZ) {
        return vec3 == null ? false : vec3.field_72450_a >= (double)minX && vec3.field_72450_a <= (double)maxX && vec3.field_72449_c >= (double)minZ && vec3.field_72449_c <= (double)maxZ;
    }

    private boolean isVecInsideXYBounds(Vec3 vec3, float minX, float maxX, float minY, float maxY) {
        return vec3 == null ? false : vec3.field_72450_a >= (double)minX && vec3.field_72450_a <= (double)maxX && vec3.field_72448_b >= (double)minY && vec3.field_72448_b <= (double)maxY;
    }
}

