/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.block;

import cubex2.cs3.block.BlockCS;
import cubex2.cs3.block.attributes.FenceGateAttributes;
import cubex2.cs3.common.WrappedBlock;
import cubex2.cs3.lib.RenderIds;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCSFenceGate
extends BlockCS {
    private FenceGateAttributes container;

    public BlockCSFenceGate(WrappedBlock block) {
        super(block);
        this.container = (FenceGateAttributes)block.container;
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return world.func_147439_a(x, y - 1, z).func_149688_o().func_76220_a() && super.func_149742_c(world, x, y, z);
    }

    @Override
    public void func_149695_a(World world, int x, int y, int z, Block neighborBlock) {
        super.func_149695_a(world, x, y, z, neighborBlock);
        if (!world.field_72995_K) {
            int metadata = world.func_72805_g(x, y, z);
            boolean powered = world.func_72864_z(x, y, z);
            if (powered || neighborBlock != Blocks.field_150350_a && neighborBlock.func_149744_f() || neighborBlock == Blocks.field_150350_a) {
                if (powered && !BlockCSFenceGate.isFenceGateOpen(metadata)) {
                    world.func_72921_c(x, y, z, metadata | 4, 2);
                    world.func_72889_a((EntityPlayer)null, 1003, x, y, z, 0);
                } else if (!powered && BlockCSFenceGate.isFenceGateOpen(metadata)) {
                    world.func_72921_c(x, y, z, metadata & 0xFFFFFFFB, 2);
                    world.func_72889_a((EntityPlayer)null, 1003, x, y, z, 0);
                }
            }
        }
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int facing, float hitX, float hitY, float hitZ) {
        super.func_149727_a(world, x, y, z, player, facing, hitX, hitY, hitZ);
        if (this.container.redstoneOnly) {
            return false;
        }
        int metadata = world.func_72805_g(x, y, z);
        if (BlockCSFenceGate.isFenceGateOpen(metadata)) {
            world.func_72921_c(x, y, z, metadata & 0xFFFFFFFB, 2);
        } else {
            int playerDirection = (MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3) % 4;
            int direction = BlockCSFenceGate.getDirection(metadata);
            if (direction == (playerDirection + 2) % 4) {
                metadata = playerDirection;
            }
            world.func_72921_c(x, y, z, metadata | 4, 2);
        }
        world.func_72889_a(player, 1003, x, y, z, 0);
        return true;
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase living, ItemStack stack) {
        super.func_149689_a(world, x, y, z, living, stack);
        int playerDirection = (MathHelper.func_76128_c((double)((double)(living.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3) % 4;
        world.func_72921_c(x, y, z, playerDirection, 2);
    }

    @Override
    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        if (!this.container.hasCollision) {
            return null;
        }
        int metadata = world.func_72805_g(x, y, z);
        return BlockCSFenceGate.isFenceGateOpen(metadata) ? null : (metadata != 2 && metadata != 0 ? AxisAlignedBB.func_72330_a((double)((float)x + 0.375f), (double)y, (double)z, (double)((float)x + 0.625f), (double)((float)y + 1.5f), (double)(z + 1)) : AxisAlignedBB.func_72330_a((double)x, (double)y, (double)((float)z + 0.375f), (double)(x + 1), (double)((float)y + 1.5f), (double)((float)z + 0.625f)));
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        int direction = BlockCSFenceGate.getDirection(world.func_72805_g(x, y, z));
        if (direction != 2 && direction != 0) {
            this.func_149676_a(0.375f, 0.0f, 0.0f, 0.625f, 1.0f, 1.0f);
        } else {
            this.func_149676_a(0.0f, 0.0f, 0.375f, 1.0f, 1.0f, 0.625f);
        }
    }

    @Override
    public boolean func_149662_c() {
        return false;
    }

    @Override
    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149655_b(IBlockAccess world, int x, int y, int z) {
        return BlockCSFenceGate.isFenceGateOpen(world.func_72805_g(x, y, z));
    }

    public int func_149645_b() {
        return RenderIds.fenceGateRenderId;
    }

    public static boolean isFenceGateOpen(int md) {
        return (md & 4) != 0;
    }

    public static int getDirection(int md) {
        return md & 3;
    }
}

