/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.block;

import cubex2.cs3.block.BlockCS;
import cubex2.cs3.block.attributes.FacingAttributes;
import cubex2.cs3.common.WrappedBlock;
import cubex2.cs3.lib.RenderIds;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCSFacing
extends BlockCS {
    protected FacingAttributes container;

    public BlockCSFacing(WrappedBlock block) {
        super(block);
        this.container = (FacingAttributes)block.container;
    }

    @Override
    public boolean func_149686_d() {
        return true;
    }

    public int func_149645_b() {
        return RenderIds.facingRenderId;
    }

    @Override
    public IIcon func_149691_a(int side, int meta) {
        if (side == (meta &= 7)) {
            return this.container.textureFront.icon;
        }
        if (side == ForgeDirection.OPPOSITES[meta]) {
            return this.container.textureBack.icon;
        }
        if (side == 0 && this.container.textureBottom.icon != null) {
            return this.container.textureBottom.icon;
        }
        if (side == 1 && this.container.textureTop.icon != null) {
            return this.container.textureTop.icon;
        }
        return this.container.textureSides.icon;
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase living, ItemStack stack) {
        super.func_149689_a(world, x, y, z, living, stack);
        if (!this.container.faceBySide) {
            int orientation = this.determineOrientation(world, x, y, z, (EntityPlayer)living);
            world.func_72921_c(x, y, z, orientation, 3);
        }
    }

    @Override
    public int func_149660_a(World world, int x, int y, int z, int facing, float hitX, float hitY, float hitZ, int metadata) {
        super.func_149660_a(world, x, y, z, facing, hitX, hitY, hitZ, metadata);
        if (this.container.faceBySide) {
            metadata |= facing;
        }
        return metadata;
    }

    public int determineOrientation(World world, int x, int y, int z, EntityPlayer player) {
        int lookDir;
        int meta = world.func_72805_g(x, y, z);
        if (MathHelper.func_76135_e((float)((float)player.field_70165_t - (float)x)) < 2.0f && MathHelper.func_76135_e((float)((float)player.field_70161_v - (float)z)) < 2.0f) {
            double var5 = player.field_70163_u + 1.82 - (double)player.field_70129_M;
            if (this.container.canFaceTop && var5 - (double)y > 2.0) {
                return 1 | meta;
            }
            if (this.container.canFaceBottom && (double)y - var5 > 0.0) {
                return 0 | meta;
            }
            if (!this.container.canFaceSides) {
                return 1 | meta;
            }
        }
        return ((lookDir = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3) == 0 ? 2 : (lookDir == 1 ? 5 : (lookDir == 2 ? 3 : (lookDir == 3 ? 4 : 0)))) | meta;
    }

    public boolean rotateSideTextures() {
        return this.container.rotateSideTextures;
    }
}

