/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.block;

import cubex2.cs3.block.BlockCS;
import cubex2.cs3.block.attributes.ButtonAttributes;
import cubex2.cs3.common.WrappedBlock;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCSButton
extends BlockCS {
    private ButtonAttributes container;

    public BlockCSButton(WrappedBlock block) {
        super(block);
        this.container = (ButtonAttributes)block.container;
        this.func_149675_a(true);
    }

    @Override
    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    @Override
    public boolean func_149662_c() {
        return false;
    }

    @Override
    public boolean func_149686_d() {
        return false;
    }

    @Override
    public boolean func_149707_d(World world, int x, int y, int z, int side) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        return dir == ForgeDirection.NORTH && world.isSideSolid(x, y, z + 1, ForgeDirection.NORTH) || dir == ForgeDirection.SOUTH && world.isSideSolid(x, y, z - 1, ForgeDirection.SOUTH) || dir == ForgeDirection.WEST && world.isSideSolid(x + 1, y, z, ForgeDirection.WEST) || dir == ForgeDirection.EAST && world.isSideSolid(x - 1, y, z, ForgeDirection.EAST);
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return world.isSideSolid(x - 1, y, z, ForgeDirection.EAST) || world.isSideSolid(x + 1, y, z, ForgeDirection.WEST) || world.isSideSolid(x, y, z - 1, ForgeDirection.SOUTH) || world.isSideSolid(x, y, z + 1, ForgeDirection.NORTH);
    }

    @Override
    public int func_149660_a(World world, int x, int y, int z, int facing, float hitX, float hitY, float hitZ, int metadata) {
        super.func_149660_a(world, x, y, z, facing, hitX, hitY, hitZ, metadata);
        int var10 = world.func_72805_g(x, y, z);
        int var11 = var10 & 8;
        var10 &= 7;
        ForgeDirection dir = ForgeDirection.getOrientation((int)facing);
        var10 = dir == ForgeDirection.NORTH && world.isSideSolid(x, y, z + 1, ForgeDirection.NORTH) ? 4 : (dir == ForgeDirection.SOUTH && world.isSideSolid(x, y, z - 1, ForgeDirection.SOUTH) ? 3 : (dir == ForgeDirection.WEST && world.isSideSolid(x + 1, y, z, ForgeDirection.WEST) ? 2 : (dir == ForgeDirection.EAST && world.isSideSolid(x - 1, y, z, ForgeDirection.EAST) ? 1 : this.getOrientation(world, x, y, z))));
        return var10 + var11;
    }

    private int getOrientation(World world, int x, int y, int z) {
        if (world.isSideSolid(x - 1, y, z, ForgeDirection.EAST)) {
            return 1;
        }
        if (world.isSideSolid(x + 1, y, z, ForgeDirection.WEST)) {
            return 2;
        }
        if (world.isSideSolid(x, y, z - 1, ForgeDirection.SOUTH)) {
            return 3;
        }
        if (world.isSideSolid(x, y, z + 1, ForgeDirection.NORTH)) {
            return 4;
        }
        return 1;
    }

    @Override
    public void func_149695_a(World world, int x, int y, int z, Block neighborBlock) {
        super.func_149695_a(world, x, y, z, neighborBlock);
        if (this.redundantCanPlaceBlockAt(world, x, y, z)) {
            int metadata = world.func_72805_g(x, y, z) & 7;
            boolean dropButton = false;
            if (!world.isSideSolid(x - 1, y, z, ForgeDirection.EAST) && metadata == 1) {
                dropButton = true;
            }
            if (!world.isSideSolid(x + 1, y, z, ForgeDirection.WEST) && metadata == 2) {
                dropButton = true;
            }
            if (!world.isSideSolid(x, y, z - 1, ForgeDirection.SOUTH) && metadata == 3) {
                dropButton = true;
            }
            if (!world.isSideSolid(x, y, z + 1, ForgeDirection.NORTH) && metadata == 4) {
                dropButton = true;
            }
            if (dropButton) {
                this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
                world.func_147468_f(x, y, z);
            }
        }
    }

    private boolean redundantCanPlaceBlockAt(World world, int x, int y, int z) {
        if (!this.func_149742_c(world, x, y, z)) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147468_f(x, y, z);
            return false;
        }
        return true;
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        int metadata = world.func_72805_g(x, y, z);
        this.func_82534_e(metadata);
    }

    private void func_82534_e(int metadata) {
        int btnDirection = metadata & 7;
        boolean var3 = (metadata & 8) > 0;
        float minY = 0.375f;
        float maxY = 0.625f;
        float var6 = 0.1875f;
        float var7 = 0.125f;
        if (var3) {
            var7 = 0.0625f;
        }
        if (btnDirection == 1) {
            this.func_149676_a(0.0f, minY, 0.5f - var6, var7, maxY, 0.5f + var6);
        } else if (btnDirection == 2) {
            this.func_149676_a(1.0f - var7, minY, 0.5f - var6, 1.0f, maxY, 0.5f + var6);
        } else if (btnDirection == 3) {
            this.func_149676_a(0.5f - var6, minY, 0.0f, 0.5f + var6, maxY, var7);
        } else if (btnDirection == 4) {
            this.func_149676_a(0.5f - var6, minY, 1.0f - var7, 0.5f + var6, maxY, 1.0f);
        }
    }

    @Override
    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        super.func_149699_a(world, x, y, z, player);
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int facing, float hitX, float hitY, float hitZ) {
        super.func_149727_a(world, x, y, z, player, facing, hitX, hitY, hitZ);
        int metadata = world.func_72805_g(x, y, z);
        int btnDirection = metadata & 7;
        int var12 = 8 - (metadata & 8);
        if (var12 == 0) {
            return true;
        }
        world.func_72921_c(x, y, z, btnDirection + var12, 3);
        world.func_147458_c(x, y, z, x, y, z);
        world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.click", 0.3f, 0.6f);
        this.notifyNeighbor(world, x, y, z, btnDirection);
        world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world));
        return true;
    }

    @Override
    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        if ((meta & 8) > 0) {
            int btnDirection = meta & 7;
            this.notifyNeighbor(world, x, y, z, btnDirection);
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    public int func_149709_b(IBlockAccess world, int x, int y, int z, int side) {
        return (world.func_72805_g(x, y, z) & 8) > 0 ? 15 : 0;
    }

    public int func_149748_c(IBlockAccess world, int x, int y, int z, int side) {
        int metadata = world.func_72805_g(x, y, z);
        if ((metadata & 8) == 0) {
            return 0;
        }
        int btnDirection = metadata & 7;
        return btnDirection == 5 && side == 1 ? 15 : (btnDirection == 4 && side == 2 ? 15 : (btnDirection == 3 && side == 3 ? 15 : (btnDirection == 2 && side == 4 ? 15 : (btnDirection == 1 && side == 5 ? 15 : 0))));
    }

    public boolean func_149744_f() {
        return true;
    }

    @Override
    public void func_149674_a(World world, int x, int y, int z, Random random) {
        int metadata;
        super.func_149674_a(world, x, y, z, random);
        if (!world.field_72995_K && ((metadata = world.func_72805_g(x, y, z)) & 8) != 0) {
            if (this.container.isSensible) {
                this.func_82535_o(world, x, y, z);
            } else {
                world.func_72921_c(x, y, z, metadata & 7, 3);
                int btnDirection = metadata & 7;
                this.notifyNeighbor(world, x, y, z, btnDirection);
                world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.click", 0.3f, 0.5f);
                world.func_147458_c(x, y, z, x, y, z);
            }
        }
    }

    @Override
    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        if (!world.field_72995_K && this.container.isSensible && (world.func_72805_g(x, y, z) & 8) == 0) {
            this.func_82535_o(world, x, y, z);
        }
    }

    public void func_149683_g() {
        float i = 0.1875f;
        float j = 0.125f;
        float k = 0.125f;
        this.func_149676_a(0.5f - i, 0.5f - j, 0.5f - k, 0.5f + i, 0.5f + j, 0.5f + k);
    }

    private void func_82535_o(World world, int x, int y, int z) {
        boolean arrowTriggersButton;
        int metadata = world.func_72805_g(x, y, z);
        int btnDirection = metadata & 7;
        boolean var7 = (metadata & 8) != 0;
        this.func_82534_e(metadata);
        List list = world.func_72872_a(EntityArrow.class, AxisAlignedBB.func_72330_a((double)((double)x + this.field_149759_B), (double)((double)y + this.field_149760_C), (double)((double)z + this.field_149754_D), (double)((double)x + this.field_149755_E), (double)((double)y + this.field_149756_F), (double)((double)z + this.field_149757_G)));
        boolean bl = arrowTriggersButton = !list.isEmpty();
        if (arrowTriggersButton && !var7) {
            world.func_72921_c(x, y, z, btnDirection | 8, 3);
            this.notifyNeighbor(world, x, y, z, btnDirection);
            world.func_147458_c(x, y, z, x, y, z);
            world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.click", 0.3f, 0.6f);
        }
        if (!arrowTriggersButton && var7) {
            world.func_72921_c(x, y, z, btnDirection, 3);
            this.notifyNeighbor(world, x, y, z, btnDirection);
            world.func_147458_c(x, y, z, x, y, z);
            world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.click", 0.3f, 0.5f);
        }
        if (arrowTriggersButton) {
            world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world));
        }
    }

    private void notifyNeighbor(World world, int x, int y, int z, int side) {
        world.func_147459_d(x, y, z, (Block)this);
        if (side == 1) {
            world.func_147459_d(x - 1, y, z, (Block)this);
        } else if (side == 2) {
            world.func_147459_d(x + 1, y, z, (Block)this);
        } else if (side == 3) {
            world.func_147459_d(x, y, z - 1, (Block)this);
        } else if (side == 4) {
            world.func_147459_d(x, y, z + 1, (Block)this);
        } else {
            world.func_147459_d(x, y - 1, z, (Block)this);
        }
    }
}

