/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.block;

import cubex2.cs3.block.IBlockCS;
import cubex2.cs3.block.attributes.BlockAttributes;
import cubex2.cs3.common.BaseContentPack;
import cubex2.cs3.common.WrappedBlock;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCS
extends Block
implements IBlockCS {
    protected BaseContentPack pack;
    protected WrappedBlock wrappedBlock;
    protected BlockAttributes container;

    public BlockCS(WrappedBlock block) {
        super(block.container.material);
        this.pack = block.getPack();
        this.wrappedBlock = block;
        this.container = this.wrappedBlock.container;
    }

    public int getMetaForFlowerGen(int itemMeta) {
        return itemMeta;
    }

    public boolean func_149662_c() {
        return this.wrappedBlock != null && this.wrappedBlock.isOpaqueCube();
    }

    public int func_149701_w() {
        return this.wrappedBlock.getRenderBlockPass();
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        return this.wrappedBlock.shouldSideBeRendered(world, x, y, z, side);
    }

    public boolean hasTileEntity(int metadata) {
        return this.wrappedBlock.hasTileEntity(metadata);
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return this.wrappedBlock.createTileEntity(world, metadata);
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        this.wrappedBlock.updateTick(world, x, y, z, rand);
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willDestroy) {
        boolean removed = world.func_147468_f(x, y, z);
        this.wrappedBlock.removedByPlayer(world, player, x, y, z);
        return removed;
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighborBlock) {
        this.wrappedBlock.onNeighborBlockChange(world, x, y, z, neighborBlock);
    }

    public void func_149726_b(World world, int x, int y, int z) {
        this.wrappedBlock.onBlockAdded(world, x, y, z);
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        this.wrappedBlock.onBlockBreak(world, x, y, z, block, meta);
    }

    public boolean func_149696_a(World world, int x, int y, int z, int id, int data) {
        super.func_149696_a(world, x, y, z, id, data);
        return this.wrappedBlock.onBlockEventReceived(world, x, y, z, id, data);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int facing, float hitX, float hitY, float hitZ) {
        return this.wrappedBlock.blockActivated(world, x, y, z, player, facing, hitX, hitY, hitZ);
    }

    public void func_149724_b(World world, int x, int y, int z, Entity entity) {
        this.wrappedBlock.onEntityWalking(world, x, y, z, entity);
    }

    public int func_149660_a(World world, int x, int y, int z, int facing, float hitX, float hitY, float hitZ, int metadata) {
        this.wrappedBlock.onBlockPlaced(world, x, y, z, facing, hitX, hitY, hitZ);
        return metadata;
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        this.wrappedBlock.onBlockClicked(world, x, y, z, player);
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        this.wrappedBlock.onEntityCollidedWithBlock(world, x, y, z, entity);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase living, ItemStack stack) {
        this.wrappedBlock.onBlockPlacedBy(world, x, y, z, living);
    }

    public void func_149746_a(World world, int x, int y, int z, Entity entity, float fallDistance) {
        this.wrappedBlock.onFallenUpon(world, x, y, z, entity, fallDistance);
    }

    public boolean onBonemeal(World world, int x, int y, int z, EntityPlayer player) {
        return this.wrappedBlock.onBonemeal(world, x, y, z, player);
    }

    public void func_149734_b(World world, int x, int y, int z, Random random) {
        this.wrappedBlock.randomDisplayTick(world, x, y, z, random);
    }

    public boolean isWood(IBlockAccess world, int x, int y, int z) {
        return this.wrappedBlock.isWood(world, x, y, z);
    }

    public boolean canSustainLeaves(IBlockAccess world, int x, int y, int z) {
        return this.wrappedBlock.canSustainLeaves(world, x, y, z);
    }

    public boolean canSilkHarvest(World world, EntityPlayer player, int x, int y, int z, int metadata) {
        return this.wrappedBlock.canSilkHarvest(world, player, x, y, z, metadata);
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return this.wrappedBlock.container.hasCollision ? super.func_149668_a(world, x, y, z) : null;
    }

    public int func_149738_a(World world) {
        return this.wrappedBlock.tickRate(world);
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        return this.wrappedBlock.getLightValue(world, x, y, z);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        return this.wrappedBlock.getDrops(world, x, y, z, metadata, fortune);
    }

    public int getExpDrop(IBlockAccess world, int metadata, int fortune) {
        return this.wrappedBlock.getExpDrop(world, metadata, fortune);
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return this.wrappedBlock.getFlammability(world, x, y, z, face);
    }

    public int getFireSpreadSpeed(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return this.wrappedBlock.getFireSpreadSpeed(world, x, y, z, face);
    }

    public boolean func_149707_d(World world, int x, int y, int z, int side) {
        return this.func_149742_c(world, x, y, z) && this.wrappedBlock.canPlaceBlockOnSide(world, x, y, z, side);
    }

    public float func_149712_f(World world, int x, int y, int z) {
        return this.wrappedBlock.getHardness(world.func_72805_g(x, y, z));
    }

    public float getExplosionResistance(Entity entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        return this.wrappedBlock.getExplosionResistance(entity, world, x, y, z, explosionX, explosionY, explosionZ);
    }

    public boolean isBurning(IBlockAccess world, int x, int y, int z) {
        return this.wrappedBlock.isBurning(world, x, y, z);
    }

    public boolean isBeaconBase(IBlockAccess worldObj, int x, int y, int z, int beaconX, int beaconY, int beaconZ) {
        return this.wrappedBlock.isBeaconBase(worldObj, x, y, z, beaconX, beaconY, beaconZ);
    }

    public boolean isFireSource(World world, int x, int y, int z, ForgeDirection side) {
        return this.wrappedBlock.isFireSource(world, x, y, z, side);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return this.wrappedBlock.getPickBlock(target, world, x, y, z);
    }

    public int func_149656_h() {
        int mobility = this.wrappedBlock.getMobilityFlag();
        return mobility >= 0 ? mobility : super.func_149656_h();
    }

    public CreativeTabs func_149708_J() {
        return this.wrappedBlock.getCreativeTabToDisplayOn();
    }

    public IIcon func_149691_a(int side, int meta) {
        return this.wrappedBlock.getIcon(side, meta);
    }

    public void func_149651_a(IIconRegister iconRegister) {
        this.wrappedBlock.registerBlockIcons(iconRegister);
    }

    @Override
    public WrappedBlock getWrappedBlock() {
        return this.wrappedBlock;
    }
}

