/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.asm;

import com.google.common.collect.Lists;
import cubex2.cs3.asm.GeneratedClass;
import cubex2.cs3.asm.ModGenData;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;

public class ModGenerator {
    private List<GeneratedClass> classes = Lists.newArrayList();
    private ModGenData data;
    private File baseDir;

    public ModGenerator(ModGenData data, File baseDir) {
        this.data = data;
        this.baseDir = baseDir;
        this.classes.add(this.genMainModClass());
        for (GeneratedClass clazz : this.classes) {
            if (!clazz.file.getParentFile().exists()) {
                clazz.file.getParentFile().mkdirs();
            }
            try {
                FileOutputStream fs = new FileOutputStream(clazz.file);
                fs.write(clazz.bytes);
                fs.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            FileWriter sw = new FileWriter(new File(baseDir, "_customstuff/data.dat"));
            sw.write(data.modId.toCharArray());
            sw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private GeneratedClass genMainModClass() {
        ClassWriter cw = new ClassWriter(0);
        cw.visit(51, 33, "_customstuff/" + this.data.modId.toLowerCase() + "/" + this.data.modClassName, null, "java/lang/Object", new String[]{"cubex2/cs3/asm/ICSMod"});
        cw.visitInnerClass("cpw/mods/fml/common/Mod$EventHandler", "cpw/mods/fml/common/Mod", "EventHandler", 9737);
        AnnotationVisitor av = cw.visitAnnotation("Lcpw/mods/fml/common/Mod;", true);
        av.visit("modid", (Object)this.data.modId);
        av.visit("name", (Object)this.data.modName);
        av.visit("version", (Object)this.data.modVersion);
        av.visit("dependencies", (Object)"required-after:CustomStuff3");
        av.visitEnd();
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "preInit", "(Lcpw/mods/fml/common/event/FMLPreInitializationEvent;)V", null, null);
        av = mv.visitAnnotation("Lcpw/mods/fml/common/Mod$EventHandler;", true);
        av.visitEnd();
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(184, "cubex2/cs3/CustomStuff3", "onPreInitPack", "(Lcubex2/cs3/asm/ICSMod;)V");
        mv.visitInsn(177);
        mv.visitMaxs(1, 2);
        mv.visitEnd();
        mv = cw.visitMethod(1, "init", "(Lcpw/mods/fml/common/event/FMLInitializationEvent;)V", null, null);
        av = mv.visitAnnotation("Lcpw/mods/fml/common/Mod$EventHandler;", true);
        av.visitEnd();
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(184, "cubex2/cs3/CustomStuff3", "onInitPack", "(Lcubex2/cs3/asm/ICSMod;)V");
        mv.visitInsn(177);
        mv.visitMaxs(1, 2);
        mv.visitEnd();
        mv = cw.visitMethod(1, "postInit", "(Lcpw/mods/fml/common/event/FMLPostInitializationEvent;)V", null, null);
        av = mv.visitAnnotation("Lcpw/mods/fml/common/Mod$EventHandler;", true);
        av.visitEnd();
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(184, "cubex2/cs3/CustomStuff3", "onPostInitPack", "(Lcubex2/cs3/asm/ICSMod;)V");
        mv.visitInsn(177);
        mv.visitMaxs(1, 2);
        mv.visitEnd();
        mv = cw.visitMethod(1, "getName", "()Ljava/lang/String;", null, null);
        mv.visitCode();
        mv.visitLdcInsn((Object)this.data.modName);
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "getId", "()Ljava/lang/String;", null, null);
        mv.visitCode();
        mv.visitLdcInsn((Object)this.data.modId);
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "getVersion", "()Ljava/lang/String;", null, null);
        mv.visitCode();
        mv.visitLdcInsn((Object)this.data.modVersion);
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "isIngamePack", "()Z", null, null);
        mv.visitCode();
        mv.visitInsn(this.data.isIngamePack ? 4 : 3);
        mv.visitInsn(172);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        cw.visitEnd();
        return new GeneratedClass(new File(this.baseDir, "_customstuff/" + this.data.modId.toLowerCase() + "/" + this.data.modClassName + ".class"), cw.toByteArray());
    }
}

