/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.server;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.relauncher.Side;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.MinecraftForge;
import xaero.map.WorldMap;
import xaero.map.message.LevelMapPropertiesConsumer;
import xaero.map.server.events.ServerEvents;
import xaero.map.server.level.LevelMapProperties;
import xaero.map.server.level.LevelMapPropertiesIO;

public class WorldMapServer {
    private Map<Path, LevelMapProperties> levelProperties = new HashMap<Path, LevelMapProperties>();
    private LevelMapPropertiesIO propertiesIO = new LevelMapPropertiesIO();
    private ServerEvents serverEvents;

    public void load(FMLInitializationEvent event) {
        System.out.println("Loading Xaero's World Map - Stage 1/2 (Server)");
        this.serverEvents = new ServerEvents(this);
        MinecraftForge.EVENT_BUS.register((Object)this.serverEvents);
        FMLCommonHandler.instance().bus().register((Object)this.serverEvents);
    }

    public void loadLater() {
        System.out.println("Loading Xaero's World Map - Stage 2/2 (Server)");
        WorldMap.network.registerMessage(LevelMapPropertiesConsumer.class, LevelMapProperties.class, 0, Side.CLIENT);
    }

    public LevelMapProperties getLevelProperties(Path path) {
        LevelMapProperties properties = this.levelProperties.get(path);
        if (properties == null) {
            properties = new LevelMapProperties();
            try {
                this.propertiesIO.load(path, properties);
            }
            catch (FileNotFoundException fnfe) {
                this.propertiesIO.save(path, properties);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.levelProperties.put(path, properties);
        }
        return properties;
    }

    public ServerEvents getServerEvents() {
        return this.serverEvents;
    }
}

