/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.region.texture;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import net.minecraft.client.gui.ScaledResolution;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.exception.OpenGLException;
import xaero.map.file.IOHelper;
import xaero.map.graphics.PixelBuffers;
import xaero.map.graphics.TextureUploader;
import xaero.map.misc.ConsistentBitArray;
import xaero.map.region.LeveledRegion;
import xaero.map.region.texture.BranchTextureRenderer;

public abstract class RegionTexture<T extends RegionTexture<T>> {
    public static final int PBO_UNPACK_LENGTH = 16384;
    public static final int PBO_PACK_LENGTH = 16384;
    protected int textureVersion;
    protected int glColorTexture = -1;
    protected boolean textureHasLight;
    protected ByteBuffer colorBuffer;
    protected boolean bufferHasLight;
    protected int colorBufferFormat = -1;
    protected boolean colorBufferCompressed;
    protected int bufferedTextureVersion;
    protected int packPbo;
    protected int[] unpackPbo = new int[2];
    protected boolean shouldDownloadFromPBO;
    protected int timer;
    private boolean cachePrepared;
    protected boolean toUpload;
    protected LeveledRegion<T> region;
    protected ConsistentBitArray heightValues;

    public RegionTexture(LeveledRegion<T> region) {
        this.region = region;
        this.textureVersion = -1;
        this.bufferedTextureVersion = -1;
        this.heightValues = new ConsistentBitArray(9, 4096);
    }

    private void setupTextureParameters() {
        GL11.glTexParameteri((int)3553, (int)33084, (int)0);
        GL11.glTexParameteri((int)3553, (int)33085, (int)0);
        GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)33083, (float)1.0f);
        GL11.glTexParameterf((int)3553, (int)34049, (float)0.0f);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
    }

    public void prepareBuffer() {
        if (this.colorBuffer != null) {
            this.colorBuffer.clear();
            BufferUtils.zeroBuffer((ByteBuffer)this.colorBuffer);
        } else {
            this.colorBuffer = this.createBuffer();
        }
    }

    public int bindColorTexture(boolean create, int magFilter) {
        boolean result = false;
        if (this.glColorTexture == -1) {
            if (create) {
                this.glColorTexture = GL11.glGenTextures();
                result = true;
            } else {
                return -1;
            }
        }
        GL11.glBindTexture((int)3553, (int)this.glColorTexture);
        if (result) {
            this.setupTextureParameters();
        }
        GL11.glTexParameteri((int)3553, (int)10240, (int)magFilter);
        return this.glColorTexture;
    }

    public long uploadBuffer(TextureUploader textureUploader, LeveledRegion<T> inRegion, BranchTextureRenderer branchTextureRenderer, int x, int y, ScaledResolution scaledRes) throws OpenGLException, IllegalArgumentException, IllegalAccessException {
        long result = this.uploadBufferHelper(textureUploader, inRegion, branchTextureRenderer, scaledRes);
        if (!this.shouldDownloadFromPBO()) {
            this.setToUpload(false);
            if (this.getColorBufferFormat() == -1) {
                this.deleteBuffers();
            } else {
                this.setCachePrepared(true);
            }
        }
        return result;
    }

    private long uploadBufferHelper(TextureUploader textureUploader, LeveledRegion<T> inRegion, BranchTextureRenderer branchTextureRenderer, ScaledResolution scaledRes) throws OpenGLException, IllegalArgumentException, IllegalAccessException {
        if (this.colorBufferFormat != -1) {
            int length = this.colorBuffer.remaining();
            this.writeToUnpackPBO(0, this.colorBuffer);
            this.updateTextureVersion(this.bufferedTextureVersion);
            boolean isCompressed = this.colorBufferCompressed;
            int internalFormat = this.colorBufferFormat;
            this.textureHasLight = this.bufferHasLight;
            this.colorBufferCompressed = false;
            this.colorBufferFormat = -1;
            this.bufferedTextureVersion = -1;
            this.bindColorTexture(true, 9728);
            OpenGLException.checkGLError();
            long totalEstimatedTime = 0L;
            totalEstimatedTime = isCompressed ? textureUploader.requestCompressed(this.glColorTexture, this.unpackPbo[0], 3553, 0, internalFormat, 64, 64, 0, 0L, length) : textureUploader.requestNormal(this.glColorTexture, this.unpackPbo[0], 3553, 0, internalFormat, 64, 64, 0, 0L, 32993, 32821);
            this.onCacheUpload();
            return totalEstimatedTime;
        }
        if (!this.shouldDownloadFromPBO) {
            return this.uploadNonCache(textureUploader, branchTextureRenderer, scaledRes);
        }
        int glTexture = this.glColorTexture;
        GL11.glBindTexture((int)3553, (int)glTexture);
        int isCompressed = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)34465);
        int length = isCompressed == 1 ? GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)34464) : 16384;
        OpenGLException.checkGLError();
        this.bindPackPBO();
        ByteBuffer mappedPBO = PixelBuffers.glMapBuffer(35051, 35000, length, null);
        OpenGLException.checkGLError();
        this.onDownloadedBuffer(mappedPBO, isCompressed);
        PixelBuffers.glUnmapBuffer(35051);
        OpenGLException.checkGLError();
        this.unbindPackPBO();
        OpenGLException.checkGLError();
        int format = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4099);
        OpenGLException.checkGLError();
        this.bufferHasLight = this.textureHasLight;
        this.colorBufferFormat = format;
        if (format == -1) {
            throw new RuntimeException("Invalid texture internal format returned by the driver.");
        }
        this.colorBufferCompressed = isCompressed == 1;
        this.shouldDownloadFromPBO = false;
        this.bufferedTextureVersion = this.textureVersion;
        return 0L;
    }

    protected abstract void onDownloadedBuffer(ByteBuffer var1, int var2);

    protected void bindPackPBO() {
        boolean created = false;
        if (this.packPbo == 0) {
            this.packPbo = PixelBuffers.glGenBuffers();
            created = true;
        }
        PixelBuffers.glBindBuffer(35051, this.packPbo);
        if (created) {
            PixelBuffers.glBufferData(35051, 16384L, 35041);
        }
    }

    private void bindUnpackPBO(int index) {
        boolean created = false;
        if (this.unpackPbo[index] == 0) {
            this.unpackPbo[index] = PixelBuffers.glGenBuffers();
            created = true;
        }
        PixelBuffers.glBindBuffer(35052, this.unpackPbo[index]);
        if (created) {
            PixelBuffers.glBufferData(35052, 16384L, 35040);
        }
    }

    protected void unbindPackPBO() {
        PixelBuffers.glBindBuffer(35051, 0);
    }

    private void unbindUnpackPBO() {
        PixelBuffers.glBindBuffer(35052, 0);
    }

    protected void writeToUnpackPBO(int pboIndex, ByteBuffer buffer) throws OpenGLException {
        this.bindUnpackPBO(pboIndex);
        ByteBuffer mappedPBO = PixelBuffers.glMapBuffer(35052, 35001, 16384L, null);
        OpenGLException.checkGLError();
        mappedPBO.put(buffer);
        PixelBuffers.glUnmapBuffer(35052);
        this.unbindUnpackPBO();
    }

    public void deleteBuffers() {
        WorldMap.bufferDeallocator.deallocate(this.colorBuffer, WorldMap.settings.debug);
        this.colorBuffer = null;
        this.colorBufferFormat = -1;
        this.bufferedTextureVersion = -1;
    }

    public void deletePBOs() {
        if (this.packPbo > 0) {
            WorldMap.glObjectDeleter.requestBufferToDelete(this.packPbo);
        }
        this.packPbo = 0;
        for (int i = 0; i < this.unpackPbo.length; ++i) {
            if (this.unpackPbo[i] <= 0) continue;
            WorldMap.glObjectDeleter.requestBufferToDelete(this.unpackPbo[i]);
            this.unpackPbo[i] = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCacheMapData(DataOutputStream output, byte[] usableBuffer, byte[] integerByteBuffer, LeveledRegion<T> inRegion) throws IOException {
        output.write(this.colorBufferCompressed ? 1 : 0);
        output.writeInt(this.colorBufferFormat);
        int length = this.colorBuffer.remaining();
        output.writeInt(length);
        this.colorBuffer.get(usableBuffer, 0, length);
        output.write(usableBuffer, 0, length);
        output.writeBoolean(this.bufferHasLight);
        this.deleteBuffers();
        LeveledRegion<T> leveledRegion = inRegion;
        synchronized (leveledRegion) {
            this.cachePrepared = false;
            inRegion.setAllCachePrepared(false);
        }
        long[] heightData = this.heightValues.getData();
        for (int i = 0; i < heightData.length; ++i) {
            output.writeLong(heightData[i]);
        }
    }

    public void readCacheData(int cacheSaveVersion, DataInputStream input, byte[] usableBuffer, byte[] integerByteBuffer, LeveledRegion<T> inRegion, MapProcessor mapProcessor, int x, int y) throws IOException {
        this.bufferedTextureVersion = cacheSaveVersion < 7 || cacheSaveVersion >= 9 && cacheSaveVersion <= 11 ? 1 : inRegion.getCachedTextureVersions(x, y);
        if (cacheSaveVersion == 6) {
            input.readInt();
        }
        int lightLevelsInCache = cacheSaveVersion < 3 ? 4 : 1;
        for (int i = 0; i < lightLevelsInCache; ++i) {
            if (i == 0) {
                this.colorBufferCompressed = true;
                if (cacheSaveVersion > 1) {
                    this.colorBufferCompressed = input.read() == 1;
                }
                this.colorBufferFormat = input.readInt();
            } else {
                if (cacheSaveVersion > 1) {
                    input.read();
                }
                input.readInt();
            }
            int length = input.readInt();
            IOHelper.readToBuffer(usableBuffer, length, input);
            if (i != 0) continue;
            if (this.colorBuffer == null) {
                this.colorBuffer = this.createBuffer();
            }
            if (inRegion.getLevel() == 0 && length == 16384 && this.colorBufferCompressed) {
                this.colorBufferCompressed = false;
                this.colorBufferFormat = 32856;
                inRegion.setShouldCache(true, "broken texture compression fix");
                this.colorBuffer.clear();
                this.colorBuffer.limit(16384);
                continue;
            }
            this.colorBuffer.put(usableBuffer, 0, length);
            this.colorBuffer.flip();
        }
        if (cacheSaveVersion >= 14) {
            this.bufferHasLight = input.readBoolean();
        } else if (cacheSaveVersion > 2) {
            int lightLength = input.readInt();
            if (lightLength > 0) {
                IOHelper.readToBuffer(usableBuffer, lightLength, input);
            }
            this.bufferHasLight = false;
        }
        if (cacheSaveVersion >= 13) {
            long[] heightData = new long[586];
            for (int i = 0; i < heightData.length; ++i) {
                heightData[i] = input.readLong();
            }
            this.heightValues.setData(heightData);
        }
        this.toUpload = true;
    }

    public ByteBuffer createBuffer() {
        return BufferUtils.createByteBuffer((int)16384);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTexturesAndBuffers() {
        int textureToDelete = this.getGlColorTexture();
        RegionTexture regionTexture = this;
        synchronized (regionTexture) {
            this.glColorTexture = -1;
        }
        if (textureToDelete != -1) {
            WorldMap.glObjectDeleter.requestTextureDeletion(textureToDelete);
        }
        this.onTextureDeletion();
        if (this.getColorBuffer() != null) {
            this.deleteBuffers();
        }
        this.deletePBOs();
    }

    public ByteBuffer getColorBuffer() {
        return this.colorBuffer;
    }

    public void setShouldDownloadFromPBO(boolean shouldDownloadFromPBO) {
        this.shouldDownloadFromPBO = shouldDownloadFromPBO;
    }

    public int getColorBufferFormat() {
        return this.colorBufferFormat;
    }

    public boolean isColorBufferCompressed() {
        return this.colorBufferCompressed;
    }

    public boolean shouldDownloadFromPBO() {
        return this.shouldDownloadFromPBO;
    }

    public int getTimer() {
        return this.timer;
    }

    public void decTimer() {
        --this.timer;
    }

    public void resetTimer() {
        this.timer = 0;
    }

    public final int getGlColorTexture() {
        return this.glColorTexture;
    }

    public void onTextureDeletion() {
        this.updateTextureVersion(0);
    }

    public boolean shouldUpload() {
        return this.toUpload;
    }

    public void setToUpload(boolean value) {
        this.toUpload = value;
    }

    public boolean isCachePrepared() {
        return this.cachePrepared;
    }

    public void setCachePrepared(boolean cachePrepared) {
        this.cachePrepared = cachePrepared;
    }

    public boolean canUpload() {
        return true;
    }

    public boolean isUploaded() {
        return !this.shouldUpload();
    }

    public int getTextureVersion() {
        return this.textureVersion;
    }

    public int getBufferedTextureVersion() {
        return this.bufferedTextureVersion;
    }

    public LeveledRegion<T> getRegion() {
        return this.region;
    }

    protected void updateTextureVersion(int newVersion) {
        this.textureVersion = newVersion;
    }

    public int getHeight(int x, int z) {
        int index = (z << 6) + x;
        int value = this.heightValues.get(index);
        if (value >> 8 == 0) {
            return -1;
        }
        return value & 0xFF;
    }

    public void putHeight(int x, int z, int height) {
        int index = (z << 6) + x;
        int value = 0x100 | height & 0xFF;
        this.heightValues.set(index, value);
    }

    public void removeHeight(int x, int z) {
        int index = (z << 6) + x;
        this.heightValues.set(index, 0);
    }

    public boolean getTextureHasLight() {
        return this.textureHasLight;
    }

    public void addDebugLines(List<String> debugLines) {
        debugLines.add("shouldUpload: " + this.shouldUpload() + " timer: " + this.getTimer());
        debugLines.add(String.format("buffer exists: %s", this.getColorBuffer() != null));
        debugLines.add("glColorTexture: " + this.getGlColorTexture() + " textureHasLight: " + this.textureHasLight);
        debugLines.add("cachePrepared: " + this.isCachePrepared());
        debugLines.add("textureVersion: " + this.textureVersion);
        debugLines.add("colorBufferFormat: " + this.colorBufferFormat);
    }

    protected void onCacheUpload() {
    }

    public boolean shouldBeUsedForBranchUpdate(int usedVersion) {
        return (this.shouldHaveContentForBranchUpdate() ? this.textureVersion : 0) != usedVersion;
    }

    public boolean shouldHaveContentForBranchUpdate() {
        return true;
    }

    public abstract boolean hasSourceData();

    public abstract void preUpload(MapProcessor var1, LeveledRegion<T> var2, boolean var3);

    public abstract void postUpload(MapProcessor var1, LeveledRegion<T> var2, boolean var3);

    protected abstract long uploadNonCache(TextureUploader var1, BranchTextureRenderer var2, ScaledResolution var3);
}

