/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.cache;

import java.util.Hashtable;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import xaero.map.BlockPos;
import xaero.map.WorldMap;

public class BlockStateColorTypeCache {
    private Hashtable<Integer, Integer> colorTypes = new Hashtable();
    private Hashtable<Integer, Integer> overlayColorTypes = new Hashtable();
    private int grassColor;
    private int foliageColor;

    public void getBlockBiomeColour(World world, Block b, int meta, int state, BlockPos pos, int[] dest, int biomeId) {
        dest[2] = 0;
        dest[0] = 0;
        dest[1] = -1;
        Integer cachedColorType = this.colorTypes.get(state);
        int colorType = cachedColorType != null ? cachedColorType : -1;
        int customColour = 0xFFFFFF;
        boolean isRenderThread = Minecraft.func_71410_x().func_152345_ab();
        boolean gotFullCC = false;
        if (colorType == -1 && isRenderThread) {
            Material material;
            boolean renderColorFailed = false;
            try {
                customColour = b.func_149741_i(meta);
                gotFullCC = true;
            }
            catch (Throwable t) {
                renderColorFailed = true;
            }
            if ((renderColorFailed || customColour != 0xFFFFFF && customColour != this.grassColor && customColour != this.foliageColor) && (material = b.func_149688_o()) != null && (material.func_151565_r() == MapColor.field_151661_c || material.func_151565_r() == MapColor.field_151669_i)) {
                try {
                    int cc2 = b.func_149635_D();
                    if (cc2 == customColour) {
                        if (material.func_151565_r() == MapColor.field_151661_c) {
                            customColour = this.grassColor;
                        } else if (material.func_151565_r() == MapColor.field_151669_i) {
                            customColour = this.foliageColor;
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            colorType = customColour == this.grassColor ? 1 : (customColour == this.foliageColor ? 2 : (customColour != 0xFFFFFF && customColour != -1 ? 3 : 0));
            this.colorTypes.put(state, colorType);
        } else if (colorType == 3 && !isRenderThread) {
            colorType = -1;
        }
        if ((colorType == 1 || colorType == 2) && biomeId == -1) {
            if (isRenderThread) {
                biomeId = world.func_72807_a((int)pos.getX(), (int)pos.getZ()).field_76756_M;
            } else {
                colorType = -1;
            }
        }
        dest[0] = colorType;
        if (colorType == -1) {
            dest[1] = biomeId;
        } else if (colorType == 1 || colorType == 2) {
            dest[1] = biomeId;
        } else if (colorType == 3) {
            if (!gotFullCC) {
                customColour = b.func_149741_i(meta);
            }
            dest[2] = customColour;
        }
    }

    public void getOverlayBiomeColour(World world, Block b, int meta, int state, BlockPos pos, int[] dest, int biomeId) {
        dest[2] = 0;
        dest[0] = 0;
        dest[1] = -1;
        Integer cachedColorType = this.overlayColorTypes.get(state);
        int colorType = cachedColorType != null ? cachedColorType : -1;
        int customColour = -1;
        boolean gotFullCC = false;
        boolean isRenderThread = Minecraft.func_71410_x().func_152345_ab();
        if (colorType == -1 && isRenderThread) {
            if (b == Blocks.field_150355_j || b == Blocks.field_150358_i) {
                colorType = 1;
            } else {
                customColour = b.func_149720_d((IBlockAccess)world, pos.getX(), pos.getY(), pos.getZ());
                gotFullCC = true;
                colorType = 0;
                if (customColour != -1) {
                    Material material = b.func_149688_o();
                    if (material != null && material.func_151565_r() == MapColor.field_151662_n && customColour == Blocks.field_150355_j.func_149720_d((IBlockAccess)world, pos.getX(), pos.getY(), pos.getZ())) {
                        colorType = 1;
                    } else if (customColour != 0xFFFFFF) {
                        colorType = 2;
                    }
                }
            }
            this.overlayColorTypes.put(state, colorType);
        } else if (colorType == 2 && !isRenderThread) {
            colorType = -1;
        }
        dest[0] = colorType;
        if (colorType == 1) {
            if (biomeId == -1) {
                if (!gotFullCC) {
                    customColour = b.func_149720_d((IBlockAccess)world, pos.getX(), pos.getY(), pos.getZ());
                }
                if (customColour == 0xFFFFFF) {
                    dest[0] = 0;
                } else {
                    dest[1] = biomeId = world.func_72807_a((int)pos.getX(), (int)pos.getZ()).field_76756_M;
                }
            }
            dest[1] = biomeId;
        } else if (colorType == 2) {
            if (!gotFullCC) {
                customColour = b.func_149720_d((IBlockAccess)world, pos.getX(), pos.getY(), pos.getZ());
            }
            dest[2] = customColour;
        }
    }

    public void updateGrassColor() {
        this.grassColor = Blocks.field_150349_c.func_149741_i(0);
        this.foliageColor = Blocks.field_150362_t.func_149741_i(0);
        if (WorldMap.settings.debug) {
            System.out.println("Default grass colour: " + this.grassColor);
        }
    }

    public void reset() {
        this.colorTypes.clear();
        this.overlayColorTypes.clear();
    }
}

