/*
 * Decompiled with CFR 0.152.
 */
package me.exz.omniocular.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import me.exz.omniocular.util.NBTSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class NBTHelper {
    public static LoadingCache<Integer, NBTTagCompound> NBTCache = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<Integer, NBTTagCompound>(){

        public NBTTagCompound load(Integer key) {
            return new NBTTagCompound();
        }
    });
    static Gson gson1 = new GsonBuilder().registerTypeHierarchyAdapter(NBTBase.class, (Object)new NBTSerializer()).create();
    private static final Gson gson2 = new GsonBuilder().setPrettyPrinting().registerTypeHierarchyAdapter(NBTBase.class, (Object)new NBTSerializer()).create();

    public static String NBT2json(NBTBase n) {
        try {
            return gson1.toJson((Object)n);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "__ERROR__";
        }
    }

    public static String NBT2jsonPrettyPrinting(NBTBase n) {
        try {
            return gson2.toJson((Object)n);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "__ERROR__";
        }
    }

    public static String MD5(String string) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(string.getBytes());
            byte[] digest = md.digest();
            StringBuilder sb = new StringBuilder();
            for (byte b : digest) {
                sb.append(String.format("%02x", b & 0xFF));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }
}

