/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.asm;

import codechicken.lib.asm.ClassConstantPoolParser;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import org.apache.commons.io.FileUtils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.util.ASMifier;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceClassVisitor;

public class RedirectorTransformer
implements IClassTransformer {
    private static final boolean DUMP_CLASSES = Boolean.parseBoolean(System.getProperty("ccl.dumpClass", "false"));
    private static final String RenderStateClass = "codechicken/lib/render/CCRenderState";
    private static final Set<String> redirectedFields = new HashSet<String>();
    private static final Set<String> redirectedSimpleMethods = new HashSet<String>();
    private static final Set<String> redirectedMethods = new HashSet<String>();
    private static final ClassConstantPoolParser cstPoolParser;
    private File outputDir = null;

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (!cstPoolParser.find(basicClass)) {
            return basicClass;
        }
        ClassReader cr = new ClassReader(basicClass);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        boolean changed = false;
        for (MethodNode mn : cn.methods) {
            for (AbstractInsnNode node : mn.instructions.toArray()) {
                if (node instanceof FieldInsnNode) {
                    FieldInsnNode fNode = (FieldInsnNode)node;
                    if (node.getOpcode() == 178 && redirectedFields.contains(fNode.name) && fNode.owner.equals(RenderStateClass)) {
                        mn.instructions.insertBefore((AbstractInsnNode)fNode, (AbstractInsnNode)new MethodInsnNode(184, fNode.owner, "instance", "()Lcodechicken/lib/render/CCRenderState;"));
                        fNode.setOpcode(180);
                        changed = true;
                        continue;
                    }
                    if (node.getOpcode() != 179 || !redirectedFields.contains(fNode.name) || !fNode.owner.equals(RenderStateClass)) continue;
                    InsnList beforePut = new InsnList();
                    beforePut.add((AbstractInsnNode)new MethodInsnNode(184, fNode.owner, "instance", "()Lcodechicken/lib/render/CCRenderState;"));
                    beforePut.add((AbstractInsnNode)new InsnNode(95));
                    mn.instructions.insertBefore((AbstractInsnNode)fNode, beforePut);
                    fNode.setOpcode(181);
                    changed = true;
                    continue;
                }
                if (!(node instanceof MethodInsnNode)) continue;
                MethodInsnNode mNode = (MethodInsnNode)node;
                if (node.getOpcode() == 184 && redirectedSimpleMethods.contains(mNode.name) && mNode.owner.equals(RenderStateClass)) {
                    mn.instructions.insertBefore((AbstractInsnNode)mNode, (AbstractInsnNode)new MethodInsnNode(184, mNode.owner, "instance", "()Lcodechicken/lib/render/CCRenderState;"));
                    mNode.setOpcode(182);
                    mNode.name = mNode.name + "Instance";
                    changed = true;
                    continue;
                }
                if (node.getOpcode() != 182 || !mNode.owner.equals(RenderStateClass) || !redirectedSimpleMethods.contains(mNode.name) && !redirectedMethods.contains(mNode.name)) continue;
                mNode.name = mNode.name + "Instance";
                changed = true;
            }
        }
        if (changed) {
            ClassWriter cw = new ClassWriter(1);
            cn.accept((ClassVisitor)cw);
            byte[] bytes = cw.toByteArray();
            if (DUMP_CLASSES) {
                this.saveTransformedClass(bytes, transformedName);
                this.saveTransformedClass(basicClass, transformedName + "_original");
            }
            return bytes;
        }
        return basicClass;
    }

    private void saveTransformedClass(byte[] data, String transformedName) {
        ClassReader classReader;
        OutputStream output;
        if (!DUMP_CLASSES) {
            return;
        }
        if (this.outputDir == null) {
            this.outputDir = new File(Launch.minecraftHome, "ASM_REDIRECTOR");
            try {
                FileUtils.deleteDirectory((File)this.outputDir);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!this.outputDir.exists()) {
                this.outputDir.mkdirs();
            }
        }
        String fileName = transformedName.replace('.', File.separatorChar);
        File classFile = new File(this.outputDir, fileName + ".class");
        File bytecodeFile = new File(this.outputDir, fileName + "_BYTE.txt");
        File asmifiedFile = new File(this.outputDir, fileName + "_ASM.txt");
        File outDir = classFile.getParentFile();
        if (!outDir.exists()) {
            outDir.mkdirs();
        }
        if (classFile.exists()) {
            classFile.delete();
        }
        try {
            output = Files.newOutputStream(classFile.toPath(), new OpenOption[0]);
            try {
                output.write(data);
            }
            finally {
                if (output != null) {
                    output.close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (bytecodeFile.exists()) {
            bytecodeFile.delete();
        }
        try {
            output = Files.newOutputStream(bytecodeFile.toPath(), new OpenOption[0]);
            try {
                classReader = new ClassReader(data);
                classReader.accept((ClassVisitor)new TraceClassVisitor(null, (Printer)new Textifier(), new PrintWriter(output)), 0);
            }
            finally {
                if (output != null) {
                    output.close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (asmifiedFile.exists()) {
            asmifiedFile.delete();
        }
        try {
            output = Files.newOutputStream(asmifiedFile.toPath(), new OpenOption[0]);
            try {
                classReader = new ClassReader(data);
                classReader.accept((ClassVisitor)new TraceClassVisitor(null, (Printer)new ASMifier(), new PrintWriter(output)), 0);
            }
            finally {
                if (output != null) {
                    output.close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        Collections.addAll(redirectedFields, "pipeline", "model", "firstVertexIndex", "lastVertexIndex", "vertexIndex", "baseColour", "alphaOverride", "useNormals", "computeLighting", "useColour", "lightMatrix", "vert", "hasNormal", "normal", "hasColour", "colour", "hasBrightness", "brightness", "side", "lc");
        Collections.addAll(redirectedSimpleMethods, "reset", "pullLightmap", "pushLightmap", "setDynamic", "draw");
        Collections.addAll(redirectedMethods, "setPipeline", "bindModel", "setModel", "setVertexRange", "render", "runPipeline", "writeVert", "setNormal", "setColour", "setBrightness", "startDrawing");
        cstPoolParser = new ClassConstantPoolParser(RenderStateClass);
    }
}

