// priority: 1000
// 老早写的代码废案，看不懂了，叫ai帮我改的不一定准，注释也是ai写的
//ai写的感觉有点复杂，后面出了问题再改改，写代码写的头疼，不想看了

// 当前营养值
// 定义一个常量 YingYangCount，用于作为存储玩家当前营养值的持久数据键
const YingYangCount = 'YingYangCount';
// 定义一个常量 YingYangCountMax，用于作为存储玩家最大营养值的持久数据键
const YingYangCountMax = 'YingYangCountMax';
// 定义一个常量 defaultYingYangCountMax，设置玩家默认的最大营养值为 100
const defaultYingYangCountMax = 100;

/**
 * 初始化营养值显示
 * 该函数会检查玩家持久数据中的营养值信息，若不存在则进行初始化
 * 同时根据玩家饰品判断是否显示营养值界面
 * @param {Internal.ServerPlayer} player 玩家对象
 */
function YingYanginitAllBar(player) {
    // 检查玩家的持久数据中是否包含当前营养值的键
    // 若不包含，则将当前营养值初始化为 0 并存储到玩家的持久数据中
    if (!player.persistentData.contains(YingYangCount)) {
        player.persistentData.putInt(YingYangCount, 0);
    }
    // 检查玩家的持久数据中是否包含最大营养值的键
    // 若不包含，则将最大营养值初始化为默认值 100 并存储到玩家的持久数据中
    if (!player.persistentData.contains(YingYangCountMax)) {
        player.persistentData.putInt(YingYangCountMax, defaultYingYangCountMax);
    }
    // 从玩家的持久数据中获取当前营养值
    let YingYangCountNum = player.persistentData.getInt(YingYangCount);
    // 计算当前营养值占最大营养值的百分比
    let YingYangCountPercent = YingYangCountNum / player.persistentData.getInt(YingYangCountMax);

    let check_name = 'primordial_cradle'
    let visible = effect_check(player, check_name)

    // 使用 player.paint 方法绘制营养值显示界面
    player.paint({
        barBackGround: {
            // 形状：设置显示元素的形状为矩形
            type: 'rectangle',
            // 设置矩形在屏幕上的 x 坐标，位于屏幕左侧边缘
            x: 7,
            // 设置矩形在屏幕上的 y 坐标，计算方式为屏幕高度的一半减去 49 个像素，从屏幕底部向上偏移
            y: '-$screenH/2+49',
            // 设置矩形的宽度
            w: 9,
            // 设置矩形的高度为 101 个像素
            h: 101,
            // 设置矩形在 x 轴上的对齐方式为左对齐
            alignX: 'left',
            // 设置矩形在 y 轴上的对齐方式为底部对齐
            alignY: 'bottom',
            // 设置矩形的纹理为指定的图片，用于显示营养值条的背景
            texture: 'kubejs:textures/item/ying_yang_bar.png',
            // 根据可见性变量决定该元素是否可见
            visible: visible
        },
        YingYangCountBarOverlay: {
            // 设置显示元素的形状为矩形
            type: 'rectangle',
            // 设置矩形在屏幕上的 x 坐标，位于屏幕左侧边缘
            x: 7,
            // 设置矩形在屏幕上的 y 坐标，计算方式为屏幕高度的一半减去 49 个像素，从屏幕底部向上偏移
            y: '-$screenH/2+49',
            // 设置纹理的 v 坐标起始值，根据当前营养值百分比计算，用于显示营养值条的进度
            v0: 1 - YingYangCountPercent,
            // 设置纹理的 v 坐标结束值为 1
            v1: 1,
            // 设置矩形的宽度
            w: 9,
            // 设置矩形的高度根据当前营养值百分比计算，用于显示营养值条的进度
            h: 101 * YingYangCountPercent,
            // 设置矩形在 x 轴上的对齐方式为左对齐
            alignX: 'left',
            // 设置矩形在 y 轴上的对齐方式为底部对齐
            alignY: 'bottom',
            // 设置矩形的纹理为指定的图片，用于显示营养值条的进度颜色
            texture: 'kubejs:textures/item/ying_yang_bar_overlay.png',
            // 根据可见性变量决定该元素是否可见
            visible: visible
        },
        barCountText: {
            // 设置显示元素的类型为文本
            type: 'text',
            // 设置文本在屏幕上的 x 坐标，距离屏幕左侧边缘 2 个像素
            x: 7,
            // 设置文本在屏幕上的 y 坐标，计算方式为屏幕高度的一半减去 59 个像素，从屏幕底部向上偏移
            y: '-$screenH/2+59',
            // 设置要显示的文本内容，将当前营养值用黄色显示
            text: `§6${YingYangCountNum}§f`,
            // 设置文本在 x 轴上的对齐方式为左对齐
            alignX: 'left',
            // 设置文本在 y 轴上的对齐方式为底部对齐
            alignY: 'bottom',
            // 根据可见性变量决定该元素是否可见
            visible: visible
        }
    });
}

/**
 * 更新营养值
 * 该函数会根据传入的 count 值更新玩家的当前营养值
 * 确保更新后的营养值在 0 到最大营养值之间
 * @param {Internal.ServerPlayer} player 玩家对象
 * @param {Number} count 要更新的营养值数量
 */
function updateYingYangCount(player, count) {
   let maxCount =  player.persistentData.getInt(YingYangCountMax) ?? YingYangCountMax
    if (count > maxCount) {
        count = maxCount
    }
    if (count < 0) {
        count = 0
    }
    player.persistentData.putInt(YingYangCount, count)

}

/**
 * 更新营养值上限
 * 该函数会根据传入的 maxCount 值更新玩家的最大营养值
 * 若当前营养值超过新的最大营养值，会将当前营养值调整为新的最大营养值
 * @param {Internal.ServerPlayer} player 玩家对象
 * @param {Number} maxCount 新的最大营养值
 */
function updateYingYangMaxCount(player, maxCount) {
    // 从玩家的持久数据中获取当前营养值，如果不存在则使用默认值 0
    let currentYingYangCount = player.persistentData.getInt(YingYangCount) ?? 0
    // 若当前营养值超过新的最大营养值，将当前营养值调整为新的最大营养值
    currentYingYangCount = Math.min(currentYingYangCount, maxCount);
    // 将更新后的当前营养值存储到玩家的持久数据中
    player.persistentData.putInt(YingYangCount, currentYingYangCount);
    // 将新的最大营养值存储到玩家的持久数据中
    player.persistentData.putInt(YingYangCountMax, Math.max(maxCount,defaultYingYangCountMax))
}

/**
 * 更新营养值显示
 * 该函数会根据传入的可见性参数更新玩家营养值显示界面
 * 确保显示的营养值不超过最大营养值
 * @param {Internal.ServerPlayer} player 玩家对象
 * @param {Boolean} visible 是否显示营养值界面
 */
function YingYangupdateSideBar(player, visible) {
    // 从玩家的持久数据中获取当前营养值
    let curYingYangCount = player.persistentData.getInt(YingYangCount);
    // 从玩家的持久数据中获取最大营养值
    let YingYangCountMax = player.persistentData.getInt(YingYangCountMax);
    // 若当前营养值超过最大营养值，将当前营养值设置为最大营养值并更新存储
    if (curYingYangCount > YingYangCountMax) {
        player.persistentData.putInt(YingYangCount, YingYangCountMax);
        curYingYangCount = YingYangCountMax;
    }
    // 计算当前营养值占最大营养值的百分比
    let percentYingYangCount = curYingYangCount / YingYangCountMax;
    // 使用 player.paint 方法更新营养值显示界面的背景和进度条元素的可见性和显示参数
    player.paint({ 
        barBackGround: { visible: visible }, 
        YingYangCountBarOverlay: { 
            v0: 1 - percentYingYangCount, 
            h: 101 * percentYingYangCount, 
            visible: visible 
        } 
    });
}

// 玩家每 tick 触发的事件
PlayerEvents.tick(event => {
    let player = event.player;
    if (player.age % 20 != 0 || !player) return
    // 调用初始化营养值显示的函数
    YingYanginitAllBar(player);
});