// priority: 1000
//有很多重复的功能，但是懒得改之前写的了
//后面再改

// 检测 Schematic 是否包含 moduleKey
function hasModuleKey(schematic) {
    if (schematic instanceof $ConfigSchematic) {
        // 获取 SchematicDefinition
        let definition = schematic.definition

        // 遍历 outcomes 检查 moduleKey
        for (let outcome of definition.outcomes) {
            if (outcome.moduleKey != null) {
                return true
            }
        }
    }
    return false;
}
/**
 * 减少物品耐久度，兼容耐久附魔和不可破坏NBT
 * @param {ItemStack} item 要减少耐久的物品
 * @param {number} amount 要减少的耐久值
 */
function reduce_durability(item, amount) {
    if (!item || amount <= 0) return;

    // 检查不可破坏属性
    if (item.nbt?.Unbreakable) return;

    // 计算耐久减免概率
    let enchant_level = item.getEnchantmentLevel('minecraft:unbreaking') || 0;
    let math = (60 + 40 / (enchant_level + 1)) / 100

    // 随机判断是否减免
    if (Math.random() < math) {
        item.damageValue = item.damageValue + amount
    }
}
/**
 * 检测模块前后变化的工具函数
 * @param {ItemStack} targetStack - 升级前的物品堆栈
 * @param {ItemStack} upgradedStack - 升级后的物品堆栈
 * @returns {Object} - 返回变化前后的模块信息
 */
function detectModuleChanges(targetStack, upgradedStack) {
    // 防御性检查
    if (!targetStack || !upgradedStack) {
        console.error("检测到空物品堆栈");
        return { added: [], removed: [], unchanged: [] };
    }

    let oldModules = targetStack.getItem().getMajorModules(targetStack) || [];
    let newModules = upgradedStack.getItem().getMajorModules(upgradedStack) || [];

    // 过滤掉可能为null的模块
    oldModules = oldModules.filter(module => module && module.key);
    newModules = newModules.filter(module => module && module.key);

    let oldModuleKeys = oldModules.map(module => module.key);
    let newModuleKeys = newModules.map(module => module.key);

    let addedModules = newModuleKeys.filter(key => !oldModuleKeys.includes(key));
    let removedModules = oldModuleKeys.filter(key => !newModuleKeys.includes(key));
    let unchangedModules = oldModuleKeys.filter(key => newModuleKeys.includes(key));

    return {
        added: addedModules,
        removed: removedModules,
        unchanged: unchangedModules
    };
}

/**
 * 检测玩家是否含有某个effect
 */
function all_effect_check(player, effect) {
    let effects = get_all_effect(player);

    for (let effectName in effects) {
        if (effectName === effect) {
            return true;
        }
    }

    return false;
}

/**
 * 检测某物品是否含有某improvement
 */
function has_improvement(item, improvement) {
    let modularItem = item.getItem();
    let boolean = false
    // 获取所有主要模块
    let modules = modularItem.getMajorModules(item);

    for (let module of modules) {
        if (module && module.getImprovement(item, improvement) != null) {
            boolean = true;
            break;
        }
    }
    return boolean
}
/**
* 去除或降低物品的improvement等级
* @param {ItemStack} item - 要修改的物品
* @param {string} improvement - 改进的key
* @param {boolean} removeCompletely - true表示完全移除，false表示降低一级
*/
function remove_improvement(item, improvement, removeCompletely) {
    let modularItem = item.getItem()

    // 获取所有主要模块
    let modules = modularItem.getMajorModules(item)

    for (let module of modules) {
        if (module && module.getImprovement(item, improvement) != null) {
            if (removeCompletely) {
                // 完全移除改进
                module.removeImprovement(item, improvement);
            } else {
                // 降低改进等级
                let level = module.getImprovementLevel(item, improvement)
                if (level > 1) {
                    module.addImprovement(item, improvement, level - 1)
                } else {
                    // 等级为1时完全移除
                    module.removeImprovement(item, improvement);
                }
            }
            break;
        }
    }
}
/**
* 通过对比前后nbt，来判断加工台事件，是否为自己需要的改进
*/
function forgeevent_check_improvement(nbt, targetStack, upgradedStack) {
    if (!nbt) return false
    let a = upgradedStack.nbt.getInt(nbt) || 0
    let b = targetStack.nbt.getInt(nbt) || 0
    if (a == b || a == 0) return false
    else return true
}

/**
* 获取玩家所有的tetra饰品
* @param {Internal.Player} player - 玩家实体
* @returns {Array} 返回tetra饰品物品数组
*/
function getTetraCurios(player) {
    let tetraItems = [];

    // 使用API获取玩家的所有饰品
    const api = new $CuriosApi();
    let optionalCurios = api.getCuriosHelper().getEquippedCurios(player);
    let curios = optionalCurios.resolve().get();

    // 遍历所有饰品槽位
    for (let slot = 0; slot < curios.getSlots(); slot++) {
        let item = curios.getStackInSlot(slot);

        // 只添加模块化物品
        if (item.item instanceof $ModularItem) {
            tetraItems.push(item);
        }
    }

    return tetraItems;
}


/**
* 获取某个半径内的生物
* @param {Internal.Level} level
* @param {Vec3} pos
* @param {Number} radius
* @returns {Array<Internal.LivingEntity>}
*/
function getLivingWithinRadius(level, pos, radius) {
    if (!level || !pos || !radius) return [];

    try {
        let area = new AABB.of(
            pos.x() - radius, pos.y() - radius, pos.z() - radius,
            pos.x() + radius, pos.y() + radius, pos.z() + radius
        );
        if (!area) return [];

        let entityAABBList = level.getEntitiesWithin(area);
        if (!entityAABBList) return [];

        let entityList = [];
        entityAABBList.forEach(entity => {
            if (entity && entity.position && entity.isLiving &&
                entity.position().distanceTo(pos) <= radius) {
                entityList.push(entity);
            }
        });
        return entityList;
    } catch (e) {
        console.error("getLivingWithinRadius error:", e);
        return [];
    }
}

//来自屋喵大佬的代码（拼好码）
function getPlayerLightLevel(player) {
    let level = player.level;
    let pos = player.blockPosition();
    let skyLight = level.getRawBrightness(pos, 15);
    let blockLight = level.getRawBrightness(pos, 0);
    let lightLevel;
    if (level.isDay() && !level.isRaining() && !level.isThundering()) {
        lightLevel = level.getRawBrightness(pos, 0);
    } else {
        lightLevel = Math.min(skyLight, blockLight);
    }
    return lightLevel;
}

function normalizeVector(vector) {
    const length = Math.sqrt(vector.x() * vector.x() + vector.y() * vector.y() + vector.z() * vector.z());
    if (length === 0) {
        return { x: 0, y: 0, z: 0 };
    }
    return {
        x: vector.x() / length,
        y: vector.y() / length,
        z: vector.z() / length
    };
}


/**
* 获取伤害类型的ResourceKey
* @param {Special.DamageType} damageTypeName 
*/
function damageTypeKey(damageTypeName) { return $ResourceKey.create($Registries.DAMAGE_TYPE, damageTypeName) }
/**
* 对实体造成伤害
* @param {boolean} invulnerableTime - 是否忽略无敌时间
* @param {$LivingEntity_} source - 伤害来源实体
* @param {$LivingEntity_} target - 目标实体
* @param {Special.DamageType} damagetype - 伤害类型
* @param {number} amount - 伤害值
*/
function simpleAttackEntity(invulnerableTime, source, target, damagetype, amount) {
    let defTime = target.invulnerableTime
    if (invulnerableTime) {
        if (target.invulnerableTime) {
            target.invulnerableTime = 0
            target.attack(target.damageSources().source(damageTypeKey(damagetype), source, source), amount)
            target.invulnerableTime = defTime
        } else {
            target.attack(target.damageSources().source(damageTypeKey(damagetype), source, source), amount)
        }
    } else {
        target.attack(target.damageSources().source(damageTypeKey(damagetype), source, source), amount)
    }
}

/**
* @param available_modular 允许进行此操作的物品类型,如果填all表示所有的都行
* @param effect_name       效果的名称
* @param enchantment       附魔名称
* @param item              要操作的物品
*/
function forgeing_enchantment(available_modular, effect_name, enchantment, item) {
    // 检查物品是否为允许的类型，若不是则直接返回
    if (item == available_modular || available_modular == 'all') {
        // 检查物品是否拥有该效果
        if (hasItemEffect(item, effect_name)) {
            // 获取物品当前的效果等级
            let effectValue = simpleGetTetraEffectLevel(item, effect_name);
            // 获取物品当前的附魔等级，若未附魔则返回0
            let enchant_level = item.getEnchantmentLevel(enchantment) || 0;

            // 如果附魔等级已经大于或等于效果等级，则无需调整
            if (enchant_level >= effectValue) return;

            // 如果物品已经有该附魔但等级低于效果等级，则移除原有附魔
            if (enchant_level) {
                // 获取物品的NBT数据
                let nbt = item.getNbt();
                // 获取附魔列表（TagList类型）
                let enchantments = nbt.getList("Enchantments", 10);

                // 过滤掉指定的附魔，保留其他附魔
                let newEnchantments = enchantments.filter(enchant => {
                    return enchant.getString("id") !== enchantment;
                });

                // 更新NBT数据中的附魔列表
                nbt.put("Enchantments", newEnchantments);
                item.setNbt(nbt);
            }

            // 将物品的附魔等级设置为与效果等级一致
            item.enchantStack(enchantment, effectValue);
        }
    }
}

function Armor_Conversion_ratio_increase(player, level) {
    let armor = player.getAttributeTotalValue('minecraft:generic.armor')
    let armor_toughness = player.getAttributeTotalValue('minecraft:generic.armor_toughness')
    let BaseWeight = 0.038 //基础权重
    let growthWeight = 1.53 //成长权重

    //非线性盔甲和韧性权重比转化
    let armorValue = Math.pow(armor, 0.7) * 1.1
    let toughnessValue = Math.pow(armor_toughness, 0.8) * 1.2
    //转化增伤比例
    let ratio = BaseWeight * Math.pow(growthWeight, level) * (armorValue + toughnessValue)
    //确保最低增伤
    return Math.max(1 + ratio, 1)
}