// priority: 1000
/**
 * 获取玩家饰品中某个effect的值和效率值
 * @param {Internal.Player} player - 玩家实体
 * @param {string} effectName - 要查询的effect名称
 * @returns {Object} 返回包含总等级和总效率值的对象 {level: number, efficiency: number}
 */
function getPlayerCuriosEffectData(player, effectName) {
    let totalLevel = 0;
    let totalEfficiency = 0;
    let tetraItems = getTetraCurios(player);

    for (const item of tetraItems) {
        let effectLevel = simpleGetTetraEffectLevel(item, effectName);
        if (effectLevel) {
            totalLevel += effectLevel;
            totalEfficiency += item.item.getEffectEfficiency(item, effectName) || 0;
        }
    }

    return {
        level: totalLevel,
        efficiency: totalEfficiency
    };
}
/**
 * 获取玩家全部effect
 */
function get_all_effect(player) {
    const totalEffectLevels = {};

    let itemList = [
        player.getHeadArmorItem(),
        player.getChestArmorItem(),
        player.getLegsArmorItem(),
        player.getFeetArmorItem(),
        player.getMainHandItem()
    ];

    itemList.forEach(item => {
        if (item.item instanceof $ModularItem) {
            let mainHandEffects = getAllEffects(item);
            mainHandEffects.forEach(effect => {
                let effectName = effect.key;
                let level = simpleGetTetraEffectLevel(item, effectName);
                totalEffectLevels[effectName] = (totalEffectLevels[effectName] || 0) + level;
            });
        }
    });

    let tetraCurios = getTetraCurios(player);
    if (tetraCurios && tetraCurios.length > 0) {
        tetraCurios.forEach(curio => {
            let curioEffects = getAllEffects(curio);
            curioEffects.forEach(effect => {
                let effectName = effect.key;
                let level = simpleGetTetraEffectLevel(curio, effectName);
                totalEffectLevels[effectName] = (totalEffectLevels[effectName] || 0) + level;
            });
        });
    }

    return totalEffectLevels;
}
/**
* 获取物品上的所有效果
* @param {ItemStack} item - 物品栈对象
* @returns {string[]} 效果名称数组
*/
function getAllEffects(item) {
    if (!item || !item.item || !item.item.getEffects) return [];

    let effects = [];
    item.item.getEffects(item).forEach(effect => {
        effects.push(effect)
    });
    effects.sort((a, b) => a.getKey().hashCode() - b.getKey().hashCode())
    return effects
};
/**
* 获取盔甲某个effect总值
*/
function arrmor_total_effect_level(player, effect) {
    let itemList = [
        player.getHeadArmorItem(),
        player.getChestArmorItem(),
        player.getLegsArmorItem(),
        player.getFeetArmorItem()
    ]
    let total_effect_level = 0
    itemList.forEach(armor => {
        if (armor.id.toString().startsWith('tetra')) {
            let amount = simpleGetTetraEffectLevel(armor, effect)
            total_effect_level += amount
        }
    })
    return total_effect_level
}
//是否含有某effect
function hasItemEffect(item, effect) {
    let level = simpleGetTetraEffectLevel(item, effect)
    if (level > 0) return true;
    else return false;
}
/**
* 简单获取tetra的Effect等级
* @param {$ItemStack_} itemstack 
* @param {string} effectname 
* @returns {number}
*/
function simpleGetTetraEffectLevel(itemstack, effectname) {
    if (itemstack.item instanceof $ModularItem) {
        return itemstack.item.getEffectLevel(itemstack, $ItemEffect.get(effectname))
    }
}
/**
* 检测玩家饰品是否含有某effect
* @param {Internal.Player} player - 玩家实体
* @param {String} check_name - 检测的效果名称
* @returns {Boolean} 是否含有该效果
*/
function effect_check(player, check_name) {

    const api = new $CuriosApi();
    let optionalCurios = api.getCuriosHelper().getEquippedCurios(player);
    let curios = optionalCurios.resolve().get();

    for (let slot = 0; slot < curios.getSlots(); slot++) {
        let item = curios.getStackInSlot(slot);
        // 检测来源
        if (!item.item instanceof $ModularItem) continue;
        if (hasItemEffect(item, check_name)) {
            return true;
        }
    }
    return false;
}