//凋零强化
//每十五秒召唤一只千血20甲的凋零骷髅
//数值方面由于incontral模组增幅，所有有些不一样
NativeEvents.onEvent($LivingTickEvent, event => {
    let entity = event.entity
    if (!entity) return
    if (entity.age % 600 != 0) return
    if (entity.type == 'minecraft:wither') {
        let level = entity.level
        let spawn_entity = level.createEntity('minecraft:wither_skeleton');
        spawn_entity.setPosition(entity.x, entity.y, entity.z);
        //属性修改
        spawn_entity.modifyAttribute('minecraft:generic.armor', 'wither_skeleton_boost', 20, 'addition');
        spawn_entity.modifyAttribute('minecraft:generic.max_health', 'wither_skeleton_boost', 800, 'addition');
        //给发光buff防止找不到
        spawn_entity.potionEffects.add('minecraft:glowing', 20 * 10000, 1)
        spawn_entity.spawn();
        //阻止召唤的凋零骷髅攻击凋零
        spawn_entity.persistentData.putBoolean('owner_wither', true)
        //回血
        spawn_entity.setHealth(spawn_entity.maxHealth)
        if (spawn_entity.getMainHandItem()) {
            //给武器
            spawn_entity.setMainHandItem(Item.of('tetra:modular_sword', '{Damage:0,HideFlags:1,honing_progress:305,id:"571c00d0-3160-43e8-b2de-5e1b04fab0cd","sword/basic_hilt_material":"basic_hilt/stick","sword/blade":"sword/katana_blade","sword/blade:arrested":0,"sword/blade:sword/murasama_imprv":0,"sword/hilt":"sword/basic_hilt","sword/katana_blade_material":"katana_blade/diamond"}'))
        }
    }
})
//凋零半血召唤凋零骷髅
function wither_hurt_1(event) {
    let entity = event.entity
    if (entity.type == 'minecraft:wither') {
        let health = entity.getHealth()
        if (health < entity.maxHealth / 2 && !entity.persistentData.contains('wither_hurt')) {
            //只召唤一次
            entity.persistentData.putBoolean('wither_hurt', true)
            let level = entity.level
            let spawn_entity = level.createEntity('minecraft:wither_skeleton');
            spawn_entity.setPosition(entity.x, entity.y, entity.z);
            //属性修改
            spawn_entity.modifyAttribute('minecraft:generic.armor', 'wither_skeleton_boost', 40, 'addition');
            spawn_entity.modifyAttribute('minecraft:generic.max_health', 'wither_skeleton_boost', 1800, 'addition');
            //给发光buff防止找不到
            spawn_entity.potionEffects.add('minecraft:glowing', 20 * 10000, 1)
            spawn_entity.spawn();
            //阻止召唤的凋零骷髅攻击凋零
            spawn_entity.persistentData.putBoolean('owner_wither', true)
            //回血
            spawn_entity.setHealth(spawn_entity.maxHealth)
            if (spawn_entity.getMainHandItem()) {
                //给武器
                spawn_entity.setMainHandItem(Item.of('tetra:modular_sword', '{Damage:0,HideFlags:1,honing_progress:239,id:"b0fb785b-e859-4566-be9a-d6a2a0ca3b07","sword/basic_hilt_material":"basic_hilt/stick","sword/blade":"sword/crucible_blade","sword/blade:arrested":0,"sword/crucible_blade_material":"crucible_blade/diamond","sword/hilt":"sword/basic_hilt","sword/hilt/settle_progress":278}'))
            }
        }
    }
}
//凋零召唤凋零骷髅，阻止凋零骷髅攻击凋零
function owner_wither(event) {
    let entity = event.entity
    let target = event.getNewTarget()
    if (entity.persistentData.contains('owner_wither') && target && target.type == 'minecraft:wither') {
        event.setNewTarget(null)
    }
}
//凋零16格范围内有凋零骷髅，受到的伤害减少
function wither_hurt_2(event) {
    let entity1 = event.entity
    let type = entity1.type
    let source = event.source.actual
    let count = 0
    if (type != 'minecraft:wither') return
    // 获取周围实体
    let entityList = getLivingWithinRadius(entity1.getLevel(), entity1.position(), 16)
    // 遍历实体列表
    entityList.forEach(entity => {
        if (entity.persistentData.contains('owner_wither')) {
            count++
        }
    })
    event.amount = event.amount * Math.max((1 - count * 0.5), 0)
    if (event.amount == 0 && source.isPlayer()) {
        source.tell('凋零免伤已达到百分之百，请尽快击杀周围凋零骷髅')
    }
}