//玩家登录事件,初始化玩家阶段
PlayerEvents.loggedIn(event => {
    let player = event.player
    if (!player.persistentData.contains('stages')) {
        player.persistentData.putInt('stages', 1)
    }
})

//二阶段之前禁止玩家使用锻造遗迹
BlockEvents.rightClicked(
    [
        'tetra:forged_crate',
        'tetra:forged_container',
        'tetra:hammer_base'
    ],
    event => {
        let player = event.player
        //不检测创造模式
        if (player.isCreative()) return
        let value = player.persistentData.getInt('stages') ?? 0
        if (value < 2) {
            player.tell('阶段二才能使用/打开该方块')
            event.cancel()
        }
    })
BlockEvents.broken(event => {
        let player = event.player
        //不检测创造模式
        if (player.isCreative()) return
        let value = player.persistentData.getInt('stages') ?? 0
        if (value < 2 && event.block == 'tetra:forged_crate' ) {
            player.tell('阶段二才能破坏该方块')
            event.cancel()
        }
})

//阶段二才允许玩家进入地狱和染梦世界
function PlayerChangedDimensionEvent_2(event) {
    let player = event.entity
    let x = player.x
    let y = player.y
    let z = player.z
    if (player.isPlayer()) {
        let value = player.persistentData.getInt('stages') ?? 0
        //不检测创造模式
        if (player.isCreative() || value >= 2) return
        if (event.dimension == 'minecraft:the_nether' || event.dimension == "pasterdream:dyedream_world") {
            player.tell('阶段二才能进入该维度，任务书ctrl+f搜索‘阶段’即可找到对应章节')
            player.getServer().scheduleInTicks(2, () => {
                player.teleportTo('minecraft:overworld', x, y, z, 0, 0)
            })
        }
    }
}

//阶段三才允许玩家进入末地和二轮世界
function PlayerChangedDimensionEvent_3(event) {
    let player = event.entity
    let x = player.x
    let y = player.y
    let z = player.z
    if (player.type == 'minecraft:player') {
        let value = player.persistentData.getInt('stages') ?? 0
        //不检测创造模式
        if (player.isCreative() || value >= 3) return
        if (event.dimension == "minecraft:the_end" || event.dimension == "jerotesvillage:second_round_world") {
            player.tell('阶段三才能进入该维度，任务书ctrl+f搜索‘阶段’即可找到对应章节')
            player.getServer().scheduleInTicks(2, () => {
                player.teleportTo('minecraft:overworld', x + 5, y, z + 5, 0, 0)
            })
        }
    }
}
//食用带有特定nbt的食物进入下一阶段
ItemEvents.foodEaten(event => {
    let player = event.player
    let item = event.item
    if (!player || !item)return
    if (player.isPlayer() && item.nbt?.stages) {
        let value = item.nbt.stages ?? 0
        player.persistentData.putInt('stages', value)
        player.tell('当前阶段为' + value)
    }
})

const entity_spawn_limit = [
    { entity: 'minecraft:wither', limit_dimension: 'minecraft:the_nether', messages: '凋零只允许在地狱生成' },
    { entity: 'faded_conquest_2:terrible_ten', limit_dimension: 'minecraft:the_end', messages: '恐怖十杰只允许在末地生成' },
    { entity: 'faded_conquest_2:vessel_of_calamity', limit_dimension: 'minecraft:the_end', messages: '灾厄容器/灾厄之剑只允许在末地生成' },
    { entity: 'faded_conquest_2:radiance_guardian', limit_dimension: 'minecraft:the_end', messages: '光辉守护者只允许在末地生成' },
    { entity: 'faded_conquest_2:faded_king', limit_dimension: 'minecraft:the_nether', messages: '只能在下界召唤' }
]
//限定特定维度生成实体
EntityEvents.spawned(event => {
    let entityType = event.entity.type
    let dimension = event.entity.level.getDimension()

    
    // 检查实体是否在限制列表中
    let limitConfig = entity_spawn_limit.find(config => config.entity === entityType)

    if (limitConfig) {
        // 检查维度是否符合限制
        if (dimension !== limitConfig.limit_dimension) {
            event.entity.server.tell(limitConfig.messages)
            event.cancel()
        }
    }
})
