//仆从攻击生物，如果生物没有目标，且该生物不是仆从,将目标设置为仆从
function target_change(event){
    let target = event.getNewTarget()
    let entity = event.entity
    if (target && target.isPlayer() && entity.persistentData.contains('owner')){
        event.setNewTarget(null)
    }
    if (target &&  target.persistentData.contains('owner') && entity.persistentData.contains('owner')){
        event.setNewTarget(null)
    }
}
1
//玩家受伤，使周围仆从更改攻击目标
function pu_cong_target_change_hurt(event){ 
    let player = event.entity
    let entity_source = event.source.actual
    if (!entity_source || !entity_source.isLiving() || entity_source.type == 'minecraft:player')return
    // 获取周围实体
    let entityList = getLivingWithinRadius(player.getLevel(), player.position(), 16)
    entityList.forEach(entity => {
        //如果该实体属于仆从并且该仆从没有攻击目标
        if (entity.persistentData.contains('owner') && !entity.target){
            //获取该仆从的主人
            let player_uuid = entity.level.getPlayerByUUID(entity.persistentData.getString('owner')).getUuid()
            //如果玩家和该仆从的主人的uuid一样
            if (player_uuid == player.getUuid()){
                //设置仆从的攻击目标为伤害来源
                entity.setLastHurtByMob(entity_source)
            }
        }
    })
}

//玩家攻击，使周围仆从更改攻击目标
function pu_cong_target_change_attack(event){
    let player = event.source.player
    let entity_hurt = event.entity
    if (!entity_hurt || entity_hurt.type == 'minecraft:player')return
    // 获取周围实体
    let entityList = getLivingWithinRadius(player.getLevel(), player.position(), 16)
    entityList.forEach(entity => {
        //如果该实体属于仆从并且该仆从没有攻击目标
        if (entity.persistentData.contains('owner') && !entity.target){
            //获取该仆从的主人
            let player_uuid = entity.level.getPlayerByUUID(entity.persistentData.getString('owner')).getUuid()
            //如果玩家和该仆从的主人的uuid一样
            if (player_uuid == player.getUuid()){
                //设置仆从的攻击目标为玩家攻击的目标
                entity.setLastHurtByMob(entity_hurt)
            }
        }
    })
}

//没有攻击目标，召唤物向玩家方向移动
NativeEvents.onEvent($LivingTickEvent, event => {
    let entity = event.entity
    if (!entity) return
    if (entity.age % 10 != 0) return
    let xing_wei = entity.persistentData.getInt('xing_wei')??0
    //如果该生物是仆从
    if (entity != null && entity.persistentData.contains('owner')) {
        let player = entity.level.getPlayerByUUID(entity.persistentData.getString('owner'))
        //如果玩家存在并且仆从没有攻击目标
        if (player && !entity.target ) {
            if (xing_wei == 0){
                // 计算距离
                let dx = player.x - entity.x
                let dy = player.y - entity.y
                let dz = player.z - entity.z
                let distance = Math.sqrt(dx * dx + dy * dy + dz * dz)
                //跟随状态时 距离大于16格快速移动到玩家
                if (distance > 16) {
                    entity.move('self', (new Vec3d(dx, dy, dz)).scale(1))
                //跟随状态时 距离大于8格缓慢移动向玩家
                }else if (distance > 8){
                    entity.getNavigation().moveTo(player.block.x, player.y, player.z, 1)
                }
            }else{
                //站立状态时停止在原地
                entity.getNavigation().moveTo(player.block.x, player.y, player.z, 0)
            }
        }
    }
})
//空手右键仆从使之站立/跟随玩家
ItemEvents.entityInteracted(event => {
    let player = event.player
    let entity = event.target
    let item = player.getMainHandItem()
    if (event.hand == 'off_hand' || item != 'minecraft:air' || entity == null || !entity.persistentData.contains('owner'))return

    let xing_wei = entity.persistentData.getInt('xing_wei')??0
    if (xing_wei == 0){
       entity.persistentData.putInt('xing_wei', 1);
       entity.server.tell('仆从已站立')
    }else{
        entity.persistentData.putInt('xing_wei', 0);
        entity.server.tell('仆从已跟随')
    }

})

//玩家和仆从受到仆从的伤害为0
function pu_cong_gong_ji(event){
    let entity_1 = event.source.actual
    let entity_2 = event.entity
    if (entity_1.persistentData.contains('owner')){
        if (entity_2.isPlayer() || entity_2.persistentData.contains('owner')){
            event.setCanceled(true)
        }
    }
}
//仆从受到的伤害增加
function pu_cong_yi_shang(event){
    let entity = event.entity
    if (entity && entity.persistentData.contains('yi_shang')){
        let amount = entity.persistentData.getInt('yi_shang')
        event.amount = event.amount * (1 + amount)
    }

}
//玩家攻击仆从，造成的伤害为0  
function otherplayerattack_3(event){
    let entity = event.entity
    if (entity && entity.persistentData.contains('owner')){
        event.amount = 0
    }
}
//persistentData含有damage_source_change的生物，取消伤害，并且将伤害来源转化为玩家
//还未经过测试，可能有bug
function damage_source_change(event){
    let damage_source = event.source.actual
    let entity = event.entity
    let type = event.getSource().getType().toString()
    let amount = event.amount
    if (damage_source && damage_source.persistentData.contains('damage_source_change')){
        let player = entity.level.getPlayerByUUID(entity.persistentData.getString('owner'))
        if (player){
            event.amount = 0
            simpleAttackEntity(false,player, entity,type,amount)

        }
    }
}
//测试
ItemEvents.rightClicked(event => {
    let player = event.player
    let uuid = player.getUuid()
    let spawn_entity = player.level.createEntity( "legendary_monsters:fire_pillar")
    // spawn_entity.setOwner(player)
    //spawn_entity.setOwnerUUID(uuid)
    //spawn_entity.setPosition(player.x, player.y + 1, player.z)
   // spawn_entity.persistentData.putString('owner', uuid)
    //spawn_entity.spawn()
})