// priority: 9
//泪宝石锁定攻速
PlayerEvents.tick(event => {
    let player = event.entity
    if (!player) return
    if (player.age % 10 != 0) return
    let item = player.getMainHandItem()
    if (!item) return
    let level = simpleGetTetraEffectLevel(item, 'lacrima')

    // 先清除之前的加成
    player.modifyAttribute('minecraft:generic.attack_speed', 'lacrima', 0, 'addition')

    // 如果有lacrima效果，直接设置攻击速度为1.2
    if (level > 0) {
        let current_speed = player.getAttributeTotalValue('minecraft:generic.attack_speed')
        if (current_speed < 1.2) {
            player.modifyAttribute('minecraft:generic.attack_speed', 'lacrima', 1.2 - current_speed, 'addition')
        }
    }
});
//连携效果实现
ItemEvents.firstLeftClicked(event => {
    let player = event.entity
    let entity = player.rayTrace().entity

    let itemstack = player.getMainHandItem()
    let offitem = player.getOffHandItem()

    //获取连携效果等级
    let main_effect = simpleGetTetraEffectLevel(itemstack, 'connected')
    let off_effect = simpleGetTetraEffectLevel(offitem, 'connected')
    //检查主副手是否同时含有连携buff
    if (main_effect == 0 || off_effect == 0) return


    // 获取存储蓄力程度
    let attackStrength = player.persistentData.getInt('attackStrength')
    //移除存储的蓄力时间
    player.persistentData.putInt('attackStrength', 0)
    // 检查物品是否蓄力足够
    if (attackStrength < 0.9) return

    //获取副手真实横扫的等级
    let truesweep = simpleGetTetraEffectLevel(offitem, 'truesweep')
    //获取副手猛刺效果
    let jab = simpleGetTetraEffectLevel(offitem, 'jab')

    //副手有真实横扫的情况
    if (truesweep > 0) {
        player.getServer().scheduleInTicks(5, () => {
            let time = 0
            if (entity) {
                time = entity.invulnerableTime
                entity.invulnerableTime = 0
            }
            //副手挥舞效果
            player.swing("off_hand", true)
            // 触发真实横扫效果
            $SweepingEffect.truesweep(offitem, player, true)
            if (entity && time != 0) {
                entity.invulnerableTime = time
            }
        })
    } else if (jab > 0) {
        if (entity) {
            player.getServer().scheduleInTicks(5, () => {
                let time = entity.invulnerableTime
                entity.invulnerableTime = 0
                offitem.getItem().jabEntity(offitem, jab, player, entity)
                player.swing("off_hand", true)
                entity.invulnerableTime = time
            })
        }
    }

})
//玩家刻事件获取存储的蓄力程度
PlayerEvents.tick(event => {
    let player = event.entity
    if (!player) return
    // 检查攻击蓄力程度
    let attackStrength = player.getAttackStrengthScale(0.5)
    //存储蓄力程度
    player.persistentData.putInt('attackStrength', attackStrength)
})



// 苦寒
function bitterColdShardBounce(player, currentTarget, bounceTargets, baseDamage, remainingBounces, currentBounce, damageSource) {
    if (remainingBounces <= 0 || !currentTarget || !currentTarget.isAlive()) return;

    simpleAttackEntity(true, player, currentTarget, 'minecraft:magic', baseDamage);

    let targetX = currentTarget.x;
    let targetY = currentTarget.y + 1;
    let targetZ = currentTarget.z;
    player.level.spawnParticles('minecraft:item_snowball',
        true, targetX, targetY, targetZ,
        0.3, 0.3, 0.3, 0.1, 8);

    player.level.spawnParticles(
        'minecraft:enchanted_hit', true, targetX, targetY, targetZ,
        0.3, 0.3, 0.3, 0.1, 8);

    player.level.spawnParticles('minecraft:crit', true,
        targetX, targetY, targetZ,
        0.5, 0.5, 0.5, 0.1, 5)

    player.server.runCommandSilent(`playsound minecraft:block.glass.hit player @a ${targetX.toFixed(1)} ${targetY.toFixed(1)} ${targetZ.toFixed(1)} 0.8 ${1.0 + Math.random() * 0.4}`);

    // 计算下一个弹跳目标
    let nextTarget = getNextBounceTarget(currentTarget, bounceTargets, player);

    // 延迟执行下一次弹跳
    Utils.server.scheduleInTicks(3, () => {
        bitterColdShardBounce(player, nextTarget, bounceTargets, baseDamage, remainingBounces - 1, currentBounce + 1, damageSource);
    });
}

// 获取下一个弹跳目标
function getNextBounceTarget(currentTarget, bounceTargets, player) {
    // 过滤死亡目标
    let aliveBounceTargets = bounceTargets.filter(target => target.isAlive() && target != player);

    if (aliveBounceTargets.length <= 1) {
        // 如果只有当前只有目标或没有目标，就继续弹跳到当前目标
        return currentTarget.isAlive() ? currentTarget : null;
    }

    // 选择除当前目标外的随机目标
    let otherTargets = aliveBounceTargets.filter(target => target != currentTarget);
    if (otherTargets.length > 0) {
        let randomIndex = Math.floor(Math.random() * otherTargets.length);
        return otherTargets[randomIndex];
    }

    // 如果没有其他目标，回到当前目标
    return currentTarget.isAlive() ? currentTarget : null;
}
//下界砖
BlockEvents.broken(event => {
    let player = event.player
    if (!player) return

    let item = player.getMainHandItem()
    let netherBrickLevel = simpleGetTetraEffectLevel(item, 'nether_brick')
    if (netherBrickLevel > 0 && event.block.id === 'minecraft:netherrack') {
        let dropChance = 0.1 + (netherBrickLevel - 1) * 0.1

        if (Math.random() < dropChance) {
            // 掉落1-3个金粒
            let goldCount = Math.floor(Math.random() * 3) + 1
            let blockPos = event.block.pos

            // 在方块位置掉落金粒
            for (let i = 0; i < goldCount; i++) {
                event.block.popItem('minecraft:gold_nugget')
            }
        }
    }
})
//雷灵自主御敌
function lei_ling(event) {
    let entity = event.entity
    let player = event.getNewTarget()
    if (player && player.isPlayer() && !entity.persistentData.contains('owner') && !entity.persistentData.contains('biao_ji')) {

        let item = player.getMainHandItem()
        let damageValue = player.getAttributeTotalValue('minecraft:generic.attack_damage');
        if (!hasItemEffect(item, 'lei_ling')) return

        // 创建实体
        let spawn_entity = entity.level.createEntity("minecraft:lightning_bolt");
        spawn_entity.setPosition(entity.x, entity.y, entity.z);
        spawn_entity.setVisualOnly(true)
        spawn_entity.spawn();
        simpleAttackEntity(true, player, entity, 'minecraft:lightning_bolt', damageValue * 5);
        entity.persistentData.put('biao_ji', 1)
    }
}

//连锁effect
BlockEvents.broken(event => {
    let player = event.player
    if (!player) return

    let time = player.persistentData.getInt('chain_destruction') ?? 0
    let CD = Math.abs(player.age - time)
    if (CD < 2) return
    player.persistentData.putInt('chain_destruction', player.age)

    let item = player.getMainHandItem()
    let level = simpleGetTetraEffectLevel(item, 'chain_destruction')


    if (!player.persistentData.getBoolean('chain_destruction_switch') && level > 0) {

        chain_destruction(event, level)

    }
})
//活体剑刃造成伤害
function otherplayerattack_2(event) {
    let player = event.source.player;
    let type = event.getSource().getType().toString();
    let item = player.getMainHandItem();

    // 检测来源
    if (!(item.item instanceof $ModularItem)) return;

    let itemNbt = item.nbt;
    let maxhealth = player.maxHealth;

    // 如果不是近战伤害类型返回
    if (type !== 'player') return;

    // 是否为活体剑刃
    if (itemNbt && itemNbt.contains('sword/huo_ti_jian_ren_material')) {
        // 活化增伤
        let livingEffect = player.hasEffect('kubejs:living')
            ? player.getEffect('kubejs:living')
            : null;
        let level_1 = livingEffect ? livingEffect.getAmplifier() : 0;

        // 噬咬增伤
        let effectData = getPlayerCuriosEffectData(player, 'devouring_bites');
        let effect_level = effectData ? effectData.efficiency : 0;
        let curYingYangCount = player.persistentData.getInt(YingYangCount);

        let level_2 = Math.min(curYingYangCount * effect_level / 100, curYingYangCount);
        if (level_2 < 0) level_2 = 0;

        updateYingYangCount(player, curYingYangCount - level_2);

        // 计算最终伤害
        event.amount = event.amount * 0.1 + maxhealth * (1 + level_1 * 0.05) + level_2
    }
}
//副手，主手同时存在tetra物品时造成的伤害减少
function otherplayerattack_1(event) {
    let player = event.source.player
    let offitem = player.getOffHandItem()
    let mainitem = player.getMainHandItem()
    //检测来源
    if (offitem.item instanceof $ModularItem && mainitem.item instanceof $ModularItem) {
        if (offitem.id != 'tetra:modular_shield') {
            event.amount *= 0.6
        }
    }
}
//时之沙效果
function EquipmentChange(event) {
    let player = event.entity
    let item = player.getMainHandItem()
    if (item.nbt && item.nbt.kubejs_damage) {
        player.modifyAttribute('minecraft:generic.attack_damage', 'kubejs_damage', item.nbt.kubejs_damage, 'addition');
    } else {
        player.removeAttribute('minecraft:generic.attack_damage', 'kubejs_damage');
    }
}
//铁块防御buff
PlayerEvents.tick(event => {
    let player = event.player
    if (player.age % 20 != 0 || !player) return;

    let item = player.getMainHandItem()
    let effect_level = simpleGetTetraEffectLevel(item, 'iron_blocks_defense')


    if (player.hasEffect('kubejs:iron_blocks_defense') && effect_level > 0) {
        let effect = player.getEffect('kubejs:iron_blocks_defense')
        let level = effect.getAmplifier() + 1
        // 更新护甲值
        player.modifyAttribute('minecraft:generic.armor', 'iron_blocks_defense', level * effect_level, 'addition')
        player.modifyAttribute('minecraft:generic.armor_toughness', 'iron_blocks_defense', (level * effect_level) / 2, 'addition')
    } else {
        // 如果buff消失，移除护甲加成
        player.removeAttribute('minecraft:generic.armor', 'iron_blocks_defense')
        player.removeAttribute('minecraft:generic.armor_toughness', 'iron_blocks_defense')
    }
})
//碎晶
function crystal_burst(event, target, player, shardDamage, Level) {
    // 简化位置获取，直接使用玩家和目标的位置
    let targetX = target.x ?? target.getX() ?? 0
    let targetY = target.y ?? target.getY() ?? 0
    let targetZ = target.z ?? target.getZ() ?? 0

    // 如果还是获取不到，使用玩家位置
    if (targetX === 0 && targetY === 0 && targetZ === 0) {
        targetX = player.x
        targetY = player.y
        targetZ = player.z
    }

    // 生成3个碎晶效果
    for (let i = 0; i < (2 + Level); i++) {
        //随机数生成
        let randomValue = Math.random()
        // 预定义的角度，避免Math.PI问题
        let angles = [0, 2.094, 4.188] // 0度, 120度, 240度 (弧度)
        let angle = angles[i]
        let radius = 1.0 + randomValue // 1-2格半径

        // 手动计算cos和sin值，Math函数问题会出现问题
        let cosValue, sinValue
        if (i === 0) { // 0度
            cosValue = 1.0
            sinValue = 0.0
        } else if (i === 1) { // 120度
            cosValue = -0.5
            sinValue = 0.866
        } else { // 240度
            cosValue = -0.5
            sinValue = -0.866
        }

        // 计算碎晶落点
        let shardX = parseFloat(targetX) + cosValue * radius
        let shardY = parseFloat(targetY) + 1.0
        let shardZ = parseFloat(targetZ) + sinValue * radius

        //粒子效果，直接用坐标
        player.server.runCommandSilent(`particle minecraft:crit ${shardX.toFixed(1)} ${shardY.toFixed(1)} ${shardZ.toFixed(1)} 1.0 1.0 1.0 0.1 30`)
        player.server.runCommandSilent(`particle minecraft:explosion ${shardX.toFixed(1)} ${shardY.toFixed(1)} ${shardZ.toFixed(1)} 0 0 0 0 1`)

        // 对范围内的实体造成伤害

        // 获取碎晶位置周围的实体
        let minX = shardX - 1.0
        let minY = shardY - 1.0
        let minZ = shardZ - 1.0
        let maxX = shardX + 1.0
        let maxY = shardY + 1.0
        let maxZ = shardZ + 1.0

        let entityList = target.level.getEntitiesWithin(AABB.of(minX, minY, minZ, maxX, maxY, maxZ))

        entityList.forEach(entity => {
            if (entity.isLiving() && entity != player) {
                let time = entity.invulnerableTime
                // 设置无敌帧为0
                entity.invulnerableTime = 0
                entity.attack(event.source, shardDamage)
                entity.invulnerableTime = time
            }
        })

        // 如果范围内没有找到实体，直接对原目标造成伤害
        if (entityList.length === 0 || !entityList.some(e => e.isLiving() && e != player)) {
            target.invulnerableTime = 0
            target.attack(event.source, shardDamage)
        }
    }
    player.server.runCommandSilent(`playsound minecraft:block.glass.break player @a ${targetX.toFixed(1)} ${targetY.toFixed(1)} ${targetZ.toFixed(1)} 1 1`)
}
//斩击
function drawSlashParticleLine(entity, count, step, particleId) {
    const level = entity.level;
    if (count === undefined) count = 30
    if (step === undefined) step = 0.1

    count = Math.max(2, count || 10);
    step = Math.max(0.1, step || 0.5); // 每个粒子的偏移量
    particleId = particleId || "minecraft:end_rod";


    // 获取实体位置
    const ex = entity.x
    const ey = entity.y + entity.getBbHeight() / 2
    const ez = entity.z
    //player.tell("[调试] 融梦极光斩击实体位置: " + ex + ", " + ey + ", " + ez);
    let x = ex, ax = ex
    let y = ey, ay = ey
    let z = ez, az = ez

    // 正向粒子线
    for (let j = 0; j <= count / 2; j++) {
        level.runCommandSilent(`particle minecraft:end_rod ${x} ${y} ${z} 0 0 0 0 1 force`)
        x += step
        y += step
        z += step
    }

    // 反向粒子线
    for (let j = count / 2; j < count; j++) {
        level.runCommandSilent(`particle minecraft:end_rod ${ax} ${ay} ${az} 0 0 0 0 1 force`)
        ax -= step
        ay -= step
        az -= step
    }

    x = ex, ax = ex
    y = ey, ay = ey
    z = ez, az = ez


    // 正向粒子线
    for (let j = 0; j <= count / 2; j++) {
        level.runCommandSilent(`particle minecraft:end_rod ${x} ${y} ${z} 0 0 0 0 1 force`)
        x += step
        y += step
        z -= step
    }

    // 反向粒子线
    for (let j = count / 2; j < count; j++) {
        level.runCommandSilent(`particle minecraft:end_rod ${ax} ${ay} ${az} 0 0 0 0 1 force`)
        ax -= step
        ay -= step
        az += step
    }
}
//融梦受伤粒子环效果
function dream_aurorian_hurt_particle_ring(event, player) {
    let level = player.level;

    let playerX = Number(player.x);
    let playerY = Number(player.y + 1.0); // 玩家碰撞箱中心高度
    let playerZ = Number(player.z);

    // 获取攻击者位置
    let attacker = event.source.actual || event.source.immediate;
    let attackDirectionX = 0; // 从攻击者到玩家的方向
    let attackDirectionZ = 1; // 默认朝北
    let hasAttacker = false;

    if (attacker && attacker.x !== undefined && attacker.z !== undefined) {
        // 计算从攻击者指向玩家的方向向量（攻击方向）
        attackDirectionX = playerX - attacker.x;
        attackDirectionZ = playerZ - attacker.z;
        hasAttacker = true;
    } else {
        // 如果没有攻击者，使用玩家朝向的反方向（默认攻击来自前方）
        let yaw = player.yaw * (3.1415926 / 180); // 转换为弧度
        attackDirectionX = Math.sin(yaw); // 玩家朝向的反方向
        attackDirectionZ = -Math.cos(yaw);
    }

    // 标准化攻击方向向量(防止攻击方向向量过大,导致粒子环效果不明显)
    let length = Math.sqrt(attackDirectionX * attackDirectionX + attackDirectionZ * attackDirectionZ);
    if (length > 0) {
        attackDirectionX /= length;
        attackDirectionZ /= length;
    }


    // 计算圆环中心位置（在攻击方向和玩家之间，距离玩家0.5格）
    let ringDistance = 0.5; // 距离玩家0.5格，太近看不到效果
    let ringCenterX = playerX - attackDirectionX * ringDistance; // 向攻击来源方向偏移
    let ringCenterY = playerY;
    let ringCenterZ = playerZ - attackDirectionZ * ringDistance;

    // 环的参数
    let radius = 1.2; // 环的半径
    let particleCount = 32; // 粒子数量

    // 计算垂直于攻击方向的两个向量（用于创建垂直圆环）
    // 向量1：垂直向上
    let upX = 0;
    let upY = 1;
    let upZ = 0;

    // 向量2：水平垂直于攻击方向
    let rightX = -attackDirectionZ; // 垂直于攻击方向向量的水平向量
    let rightY = 0;
    let rightZ = attackDirectionX;

    let outerParticleCount = 0;

    // 创建垂直圆环
    for (let i = 0; i < particleCount; i++) {
        let angle = (i / particleCount) * 2 * 3.1415926;

        // 使用上向量和右向量创建圆环坐标
        let cosAngle = Math.cos(angle);
        let sinAngle = Math.sin(angle);

        let particleX = ringCenterX + radius * (rightX * cosAngle + upX * sinAngle);
        let particleY = ringCenterY + radius * (rightY * cosAngle + upY * sinAngle);
        let particleZ = ringCenterZ + radius * (rightZ * cosAngle + upZ * sinAngle);

        if (!isNaN(particleX) && !isNaN(particleY) && !isNaN(particleZ)) {
            // 生成静态附魔粒子（圆环本体）
            level.spawnParticles("minecraft:enchant", true,
                particleX, particleY, particleZ,
                0.0, 1, 0.0, 0.1, 0.02
            );

            // 添加朝攻击来源方向反弹的粒子效果
            level.spawnParticles("minecraft:enchant", true,
                particleX, particleY, particleZ,
                -attackDirectionX * 0.15, 1, -attackDirectionZ * 0.15, // 朝攻击来源反方向
                0.2, 0.08
            );

            // 添加少量向上散开的粒子（能量扩散效果）
            level.spawnParticles("minecraft:enchant", true,
                particleX, particleY, particleZ,
                (Math.random() - 0.5) * 0.1, 1, (Math.random() - 0.5) * 0.1,
                0.15, 0.12
            );
            outerParticleCount++;

        }
    }

    // 添加内层环
    let innerRadius = 0.6;
    let innerParticleCount = 0;
    for (let i = 0; i < 16; i++) {
        let angle = (i / 16) * 2 * 3.1415926;
        let cosAngle = Math.cos(angle);
        let sinAngle = Math.sin(angle);

        let particleX = ringCenterX + innerRadius * (rightX * cosAngle + upX * sinAngle);
        let particleY = ringCenterY + innerRadius * (rightY * cosAngle + upY * sinAngle);
        let particleZ = ringCenterZ + innerRadius * (rightZ * cosAngle + upZ * sinAngle);

        if (!isNaN(particleX) && !isNaN(particleY) && !isNaN(particleZ)) {
            level.spawnParticles("minecraft:enchant", true,
                particleX, particleY, particleZ,
                0.0, 1, 0.0, 0.15, 0.03
            );
            innerParticleCount++;
        }
    }
    player.server.runCommandSilent(`execute at ${player.name.string} run playsound minecraft:block.enchantment_table.use player @a ~ ~ ~ 0.5 1.2`);
}

// 融梦极光攻击特效
function dreamAurorianAttackParticles(entity) {
    entity.level.spawnParticles('minecraft:crit', true,
        entity.x, entity.y + 1, entity.z,
        0.5, 0.5, 0.5, 0.1, 5)

    entity.level.spawnParticles('minecraft:enchant', true,
        entity.x, entity.y + 0.5, entity.z,
        0.3, 0.3, 0.3, 0.05, 3)
}

// 融梦极光环绕特效
function dreamAurorianAuraParticles(player) {
    // 获取范围内的敌人
    let entityList = getLivingWithinRadius(player.getLevel(), player.position(), 10)
    let enemies = entityList.filter(entity => entity.isLiving() && entity != player)

    // 生成环绕光环（减少到32个粒子）
    for (let j = 0; j < 32; j++) {
        let angle = (3.1415926 * 2 * j) / 32
        let radius = 8 + Math.random() * 4
        let particleX = player.x + Math.cos(angle) * radius
        let particleY = player.y + Math.random() * 3
        let particleZ = player.z + Math.sin(angle) * radius

        // 生成光环粒子
        player.level.spawnParticles('minecraft:enchant', true,
            particleX, particleY, particleZ,
            0.2, 0.2, 0.2, 0.05, 2)
    }

    // 只从部分光环位置连接敌人（每4个粒子连接一次）
    if (enemies.length > 0) {
        for (let j = 0; j < 32; j += 4) {
            let angle = (3.1415926 * 2 * j) / 32
            let radius = 8
            let particleX = player.x + Math.cos(angle) * radius
            let particleY = player.y + 1
            let particleZ = player.z + Math.sin(angle) * radius

            // 连接最近的敌人
            let nearestEnemy = enemies[0]
            if (nearestEnemy) {
                dreamAurorianConnectionParticles(player, particleX, particleY, particleZ, nearestEnemy)
            }
        }
    }
}

// 融梦极光连线特效
function dreamAurorianConnectionParticles(player, startX, startY, startZ, target) {
    let targetX = target.x
    let targetY = target.y + 1
    let targetZ = target.z

    // 计算连线的步数（大幅减少粒子密度）
    let distance = Math.sqrt((targetX - startX) ** 2 + (targetY - startY) ** 2 + (targetZ - startZ) ** 2)
    let steps = Math.min(Math.ceil(distance * 0.25), 10) // 每2格一个粒子，最多6个

    for (let i = 0; i <= steps; i++) {
        let progress = i / steps
        let particleX = startX + (targetX - startX) * progress
        let particleY = startY + (targetY - startY) * progress
        let particleZ = startZ + (targetZ - startZ) * progress

        // 生成连线粒子 - 使用附魔粒子
        player.level.spawnParticles('minecraft:enchant', true,
            particleX, particleY, particleZ,
            0.1, 0.1, 0.1, 0.02, 1)
    }
}
// 觉醒极光斩击粒子线 - 三段式随机斩击
function drawAwakenedSlashParticleLine(entity, player) {
    //加上角度范围，不然老是并在一起

    // 0-120度
    drawSingleRandomSlashLineWithOffset(entity, 'minecraft:electric_spark', 0, player)

    // 120-240度
    drawSingleRandomSlashLineWithOffset(entity, 'minecraft:electric_spark', 120, player)

    // 240-360度
    drawSingleRandomSlashLineWithOffset(entity, 'minecraft:electric_spark', 240, player)

    // 真化裂痕效果
    for (let i = 0; i < 6; i++) {
        let angle = (3.1415926 * 2 * i) / 6
        let radius = 1.5
        let particleX = entity.x + Math.cos(angle) * radius
        let particleY = entity.y + 0.1
        let particleZ = entity.z + Math.sin(angle) * radius

        entity.level.spawnParticles('minecraft:witch', true,
            particleX, particleY, particleZ,
            0.1, 0.1, 0.1, 0.02, 1)
    }
}

// 随机偏移的斩击线
function drawSingleRandomSlashLineWithOffset(entity, particleType, angleOffset, player) {

    // 检查实体坐标是否有效
    if (!entity || !entity.x || !entity.y || !entity.z) {
        return
    }

    let randomAngle = Math.random() * 2.094 // 120度的弧度值
    let angle = (angleOffset * 3.1415926 / 180) + randomAngle // 转换为弧度并加上偏移


    // 检查角度计算是否有效
    if (isNaN(angle)) {
        return
    }

    let distance = 4 + Math.random() * 2 // 4-6格距离
    let startX = entity.x + Math.cos(angle) * distance
    let startZ = entity.z + Math.sin(angle) * distance

    // 增加斩击的倾斜度 - 确保Y坐标有效
    let heightVariation = 2 + Math.random() * 2 // 2-4格的高度变化
    let startY, endY

    //从上往下或是从下往上
    if (Math.random() < 0.5) {
        startY = entity.y + heightVariation
        endY = entity.y - 0.5
    } else {
        startY = entity.y - 0.5
        endY = entity.y + heightVariation
    }

    // 检查Y坐标是否有效
    if (isNaN(startY) || isNaN(endY)) {
        return
    }

    // 终点在敌人的对面，形成倾斜的斩击线
    let endX = entity.x - Math.cos(angle) * distance
    let endZ = entity.z - Math.sin(angle) * distance

    // 检查所有坐标是否有效
    if (isNaN(startX) || isNaN(startZ) || isNaN(endX) || isNaN(endZ)) {
        return
    }

    // 计算斩击线的步数
    let dx = endX - startX
    let dy = endY - startY
    let dz = endZ - startZ
    let totalDistance = Math.sqrt(dx * dx + dy * dy + dz * dz)

    // 检查距离计算是否有效
    if (isNaN(totalDistance) || totalDistance <= 0) {
        return
    }

    let steps = Math.min(Math.floor(totalDistance * 1.2), 18)

    if (steps < 5) {
        steps = 16 // 最少粒子数为8
    }

    // 绘制倾斜的斩击线
    for (let i = 0; i <= steps; i++) {
        let progress = i / steps
        let particleX = startX + dx * progress
        let particleY = startY + dy * progress
        let particleZ = startZ + dz * progress

        // 检查粒子坐标是否有效
        if (isNaN(particleX) || isNaN(particleY) || isNaN(particleZ)) {
            continue
        }

        // 随机偏移
        let randomOffset = 0.1
        let offsetX = (Math.random() - 0.5) * randomOffset
        let offsetY = (Math.random() - 0.5) * randomOffset * 0.5 // Y轴偏移减少，保持斩击线的方向性
        let offsetZ = (Math.random() - 0.5) * randomOffset

        entity.level.spawnParticles(particleType, true,
            particleX + offsetX, particleY + offsetY, particleZ + offsetZ,
            0.1, 0.1, 0.1, 0, 4) // 每个位置粒子数为4
    }
}



// 觉醒极光
// 初始启动特效
function createAwakenedStartupEffects(player) {
    let px = player.x, py = player.y + 1, pz = player.z

    // 启动光环
    for (let i = 0; i < 60; i++) {
        let angle = (i / 60) * 2 * 3.1415926
        let radius = 10 + Math.random() * 2
        let x = px + Math.cos(angle) * radius
        let z = pz + Math.sin(angle) * radius
        let y = py + (Math.random() - 0.5) * 4
        player.level.spawnParticles('minecraft:cherry_leaves', true, x, y, z, 0.3, 0.3, 0.3, 0.1, 2)
    }

    // 中心能量聚集
    for (let i = 0; i < 20; i++) {
        let angle = Math.random() * 2 * 3.1415926
        let radius = Math.random() * 3.0
        let x = px + Math.cos(angle) * radius
        let z = pz + Math.sin(angle) * radius
        player.level.spawnParticles('minecraft:cherry_leaves', true, x, py + 2, z, 0, -0.2, 0, 0.1, 1)
    }
}

// 缝隙斩击效果
function drawTimeFissureSlash(entity, player, intensity) {
    let ex = entity.x, ey = entity.y + 1, ez = entity.z

    // 计算从玩家到目标的方向向量
    let dx = ex - player.x
    let dz = ez - player.z
    let distance = Math.sqrt(dx * dx + dz * dz)

    // 标准化方向向量
    if (distance > 0) {
        dx = dx / distance
        dz = dz / distance
    }

    // 计算垂直向量（用于宽度）
    let perpX = -dz
    let perpZ = dx

    // 缝隙长度
    let fissureLength = 6.0
    let maxWidth = 2.0 * intensity // 最大宽度随强度变化

    // 绘制时间缝隙
    for (let i = 0; i <= 20; i++) {
        let progress = i / 20 // 0到1
        let centerProgress = progress - 0.5 // -0.5到0.5

        // 计算当前位置沿着缝隙方向
        let currentX = ex + dx * fissureLength * centerProgress
        let currentZ = ez + dz * fissureLength * centerProgress

        // 计算当前位置的宽度（中间宽，两端窄）
        let widthFactor = 1.0 - Math.abs(centerProgress * 2) // 中间1.0，两端0.0
        widthFactor = Math.pow(widthFactor, 0.5) // 平滑过渡
        let currentWidth = maxWidth * widthFactor

        // 绘制缝隙的两侧
        if (currentWidth > 0.1) {
            // 左侧
            let leftX = currentX - perpX * currentWidth
            let leftZ = currentZ - perpZ * currentWidth
            entity.level.spawnParticles('minecraft:reverse_portal', true,
                leftX, ey, leftZ, 0.1, 0.1, 0.1, 0.02, 2)

            // 右侧
            let rightX = currentX + perpX * currentWidth
            let rightZ = currentZ + perpZ * currentWidth
            entity.level.spawnParticles('minecraft:reverse_portal', true,
                rightX, ey, rightZ, 0.1, 0.1, 0.1, 0.02, 2)

            // 中心缝隙线
            entity.level.spawnParticles('minecraft:witch', true,
                currentX, ey, currentZ, 0.05, 0.05, 0.05, 0.01, 1)

            // 填充中间区域（更密集的粒子）
            let steps = Math.floor(currentWidth * 3)
            for (let j = 1; j < steps; j++) {
                let fillProgress = j / steps
                let fillX = currentX + perpX * currentWidth * (fillProgress - 0.5) * 2
                let fillZ = currentZ + perpZ * currentWidth * (fillProgress - 0.5) * 2
                entity.level.spawnParticles('minecraft:portal', true,
                    fillX, ey, fillZ, 0.05, 0.05, 0.05, 0.01, 1)
            }
        }
    }

    //扭曲效果
    for (let i = 0; i < 8; i++) {
        let angle = (i / 8) * 2 * 3.1415926
        let spiralRadius = maxWidth * 0.8
        let spiralX = ex + Math.cos(angle) * spiralRadius
        let spiralZ = ez + Math.sin(angle) * spiralRadius
        entity.level.spawnParticles('minecraft:end_rod', true,
            spiralX, ey + 0.5, spiralZ, 0, 0, 0, 0.02, 1)
    }
}

// 固定朝向的竖直菱形眼睛
function drawDiamondEye(player, centerX, centerY, centerZ, size, particleType, particleCount, rotationAngle, fixedRightX, fixedRightZ) {
    // 默认参数
    if (particleCount === undefined) particleCount = 1
    if (rotationAngle === undefined) rotationAngle = 0

    // 固定的朝向向量，而不是实时计算,不然效果很奇怪
    let rightX = fixedRightX
    let rightZ = fixedRightZ

    // 扁平眼睛形状的四个角点（上、右、下、左）- 在垂直于玩家朝向的平面上
    let points = [
        { x: 0, y: size * 0.4, z: 0 },                          // 上（扁到0.4倍）
        { x: rightX * size * 1.5, y: 0, z: rightZ * size * 1.5 }, // 右（1.5倍宽度）
        { x: 0, y: -size * 0.4, z: 0 },                         // 下（扁到0.4倍）
        { x: -rightX * size * 1.5, y: 0, z: -rightZ * size * 1.5 } // 左（1.5倍宽度）
    ]

    // 如果有旋转角度，围绕Y轴旋转这些点
    if (rotationAngle !== 0) {
        points = points.map(point => {
            let newX = point.x * Math.cos(rotationAngle) - point.z * Math.sin(rotationAngle)
            let newZ = point.x * Math.sin(rotationAngle) + point.z * Math.cos(rotationAngle)
            return { x: newX, y: point.y, z: newZ }
        })
    }

    // 绘制菱形的四条边
    for (let side = 0; side < 4; side++) {
        let startPoint = points[side]
        let endPoint = points[(side + 1) % 4]

        // 每条边绘制8个点
        for (let i = 0; i <= 8; i++) {
            let progress = i / 8
            let x = centerX + startPoint.x + (endPoint.x - startPoint.x) * progress
            let y = centerY + startPoint.y + (endPoint.y - startPoint.y) * progress
            let z = centerZ + startPoint.z + (endPoint.z - startPoint.z) * progress

            player.level.spawnParticles(particleType, true,
                x, y, z, 0, 0, 0, 0.02, particleCount)
        }
    }
}

// 极光觉醒眼睛效果
function createJudgmentEye(player, finalWeaponDamage) {
    let px = player.x, py = player.y, pz = player.z

    // 计算玩家身后的位置和朝向（固定，不再变化）
    let playerYaw = player.yaw * 3.1415926 / 180 // 转换为弧度
    // 背后方向是玩家朝向的相反方向
    let behindX = px + Math.sin(playerYaw) * 3  // 玩家背后3格
    let behindZ = pz - Math.cos(playerYaw) * 3
    let behindY = py + 3 // 高度3格

    // 计算眼睛朝向玩家的方向向量
    let eyeToPlayerX = px - behindX
    let eyeToPlayerZ = pz - behindZ
    let eyeToPlayerDistance = Math.sqrt(eyeToPlayerX * eyeToPlayerX + eyeToPlayerZ * eyeToPlayerZ)

    // 标准化朝向向量
    if (eyeToPlayerDistance > 0) {
        eyeToPlayerX = eyeToPlayerX / eyeToPlayerDistance
        eyeToPlayerZ = eyeToPlayerZ / eyeToPlayerDistance
    }

    // 计算眼睛的右侧向量（垂直于朝向向量）
    let fixedRightX = -eyeToPlayerZ  // 朝向向量的垂直向量
    let fixedRightZ = eyeToPlayerX

    // 菱形眼睛显现 (1秒)
    for (let t = 0; t < 20; t++) {
        Utils.server.scheduleInTicks(t, () => {
            let progress = t / 20
            let currentSize = 3.0 * progress // 菱形大小

            // 绘制菱形眼睛轮廓
            drawDiamondEye(player, behindX, behindY, behindZ, currentSize, 'minecraft:dragon_breath', 1, 0, fixedRightX, fixedRightZ)

            // 眼睛中心瞳孔 - 后半段才出现
            if (progress > 0.5) {
                let pupilSize = (progress - 0.5) * 2 * 0.8 // 瞳孔大小
                drawDiamondEye(player, behindX, behindY, behindZ, pupilSize, 'minecraft:witch', 2, 0, fixedRightX, fixedRightZ)
            }
        })
    }

    //凝视 (1-3秒)
    for (let t = 20; t < 60; t++) {
        Utils.server.scheduleInTicks(t, () => {
            let progress = (t - 20) / 40
            let intensity = 1.0 + progress * 2.0

            // 菱形外框,逐渐变亮，带旋转
            let rotationAngle = t * 0.05
            drawDiamondEye(player, behindX, behindY, behindZ, 3.5, 'minecraft:soul_fire_flame', Math.floor(intensity), rotationAngle, fixedRightX, fixedRightZ)

            // 菱形瞳孔,越来越亮
            let pupilIntensity = Math.floor(intensity * 2)
            for (let i = 0; i < pupilIntensity; i++) {
                drawDiamondEye(player, behindX, behindY, behindZ, 0.6 + Math.random() * 0.4, 'minecraft:witch', 1, 0, fixedRightX, fixedRightZ)
            }

            // 中心核心,最亮的点
            if (intensity > 2.0) {
                player.level.spawnParticles('minecraft:end_rod', true,
                    behindX, behindY, behindZ, 0.1, 0.1, 0.1, 0.02, 1)
            }

            // 能量聚集音效
            if (t % 10 === 0) {
                player.level.playSound(null, behindX, behindY, behindZ,
                    'minecraft:block.beacon.power_select', 'players', 0.5, 1.0 + progress)
            }
        })
    }

    // 音效
    player.level.playSound(null, behindX, behindY, behindZ,
        'minecraft:entity.ender_dragon.ambient', 'players', 1.0, 0.5)

}

function drawWaterColumn(entity, player) {
    let entityX = entity.x
    let entityY = entity.y
    let entityZ = entity.z

    // 强化水柱粒子效果 - 瞬间爆发
    for (let i = 0; i < 40; i++) {
        let height = Math.random() * 4 // 0-4格高度
        let offsetX = (Math.random() - 0.5) * 1.5
        let offsetZ = (Math.random() - 0.5) * 1.5
        player.level.spawnParticles('minecraft:splash', true,
            entityX + offsetX, entityY + height, entityZ + offsetZ,
            0.3, 0.8, 0.3, 0.15, 2)
    }

    // 持续水柱效果 - 每0.2秒生成一次，持续3秒
    for (let t = 0; t < 8; t++) {
        entity.getServer().scheduleInTicks(t * 4, () => {
            for (let i = 0; i < 8; i++) {
                let height = Math.random() * 3
                let offsetX = (Math.random() - 0.5) * 1.2
                let offsetZ = (Math.random() - 0.5) * 1.2
                player.level.spawnParticles('minecraft:falling_water', true,
                    entityX + offsetX, entityY + 2 + height, entityZ + offsetZ,
                    0.1, -0.3, 0.1, 0.1, 1)
            }
        })
    }
}

function drawWindColumn(entity, player) {
    let entityX = entity.x
    let entityY = entity.y
    let entityZ = entity.z

    // 底部旋转风力
    for (let i = 0; i < 8; i++) {
        let angle = (i / 8) * 2 * Math.PI
        let radius = 1.5
        let x = entityX + Math.cos(angle) * radius
        let z = entityZ + Math.sin(angle) * radius
        player.level.spawnParticles('minecraft:cloud', true,
            x, entityY + 0.1, z, 0.1, 0.1, 0.1, 0.05, 3)
    }

    // 向上风流
    for (let i = 0; i < 30; i++) {
        let height = Math.random() * 4 // 0-4格高度
        let offsetX = (Math.random() - 0.5) * 1.0
        let offsetZ = (Math.random() - 0.5) * 1.0
        player.level.spawnParticles('minecraft:white_ash', true,
            entityX + offsetX, entityY + height, entityZ + offsetZ,
            0.1, 0.5, 0.1, 0.08, 2)
    }

    // 顶部扩散
    for (let i = 0; i < 12; i++) {
        let angle = (i / 12) * 2 * Math.PI
        let radius = 1.0 + Math.random() * 0.5
        let x = entityX + Math.cos(angle) * radius
        let z = entityZ + Math.sin(angle) * radius
        player.level.spawnParticles('minecraft:gust', true,
            x, entityY + 4, z, 0.2, 0.1, 0.2, 0.03, 1)
    }

    // 持续风力效果,0.2/s,2s
    for (let t = 0; t < 7; t++) {
        entity.getServer().scheduleInTicks(t * 6, () => {
            // 螺旋上升的风
            for (let i = 0; i < 6; i++) {
                let angle = (t * 0.5 + i / 6) * 2 * Math.PI
                let radius = 0.8 + Math.sin(t * 0.5) * 0.3
                let height = i * 0.6
                let x = entityX + Math.cos(angle) * radius
                let z = entityZ + Math.sin(angle) * radius
                player.level.spawnParticles('minecraft:puff', true,
                    x, entityY + height, z, 0.05, 0.3, 0.05, 0.04, 1)
            }

            // 中心上升气流
            for (let i = 0; i < 4; i++) {
                let height = Math.random() * 3
                let offsetX = (Math.random() - 0.5) * 0.5
                let offsetZ = (Math.random() - 0.5) * 0.5
                player.level.spawnParticles('minecraft:campfire_cosy_smoke', true,
                    entityX + offsetX, entityY + 1 + height, entityZ + offsetZ,
                    0.05, 0.4, 0.05, 0.06, 1)
            }
        })
    }
}

function drawPortalColumn(entity, player) {
    let entityX = entity.x
    let entityY = entity.y
    let entityZ = entity.z

    for (let i = 0; i < 40; i++) {
        let height = Math.random() * 4 // 0-4格高度
        let offsetX = (Math.random() - 0.5) * 1.5
        let offsetZ = (Math.random() - 0.5) * 1.5
        player.level.spawnParticles('minecraft:witch', true,
            entityX + offsetX, entityY + height, entityZ + offsetZ,
            0.3, 0.8, 0.3, 0.15, 2)
    }

    for (let t = 0; t < 8; t++) {
        entity.getServer().scheduleInTicks(t * 4, () => {
            for (let i = 0; i < 8; i++) {
                let height = Math.random() * 3
                let offsetX = (Math.random() - 0.5) * 1.2
                let offsetZ = (Math.random() - 0.5) * 1.2
                player.level.spawnParticles('minecraft:witch', true,
                    entityX + offsetX, entityY + 2 + height, entityZ + offsetZ,
                    0.1, -0.3, 0.1, 0.1, 1)
            }
        })
    }
}

