// priority: 9

//参考脆骨症夜鸢大佬的代码
//不清楚优化会不会更好，但是写起来方便一点
ItemEvents.rightClicked(event => {
    let player = event.player;
    if (!player || event.hand != 'MAIN_HAND') return;
    let item = player.getMainHandItem()

    if (!item.item instanceof $ModularItem) return;


    let effects = getAllEffects(item);
    if (!effects)return
    effects.forEach(effectName => {
        let originalEffectName = effectName.key
        let effectValue = simpleGetTetraEffectLevel(item, originalEffectName);
        let strategy = tetra_player_you_jian_strategies[originalEffectName] || tetra_player_you_jian_strategies.default;
        strategy(event, player, effectValue, item, originalEffectName);
    });
});


const tetra_player_you_jian_strategies = {
    // 觉醒极光
    'dream_aurorian_awakened': function (event, player, effectValue, item, originalEffectName) {
        let time = player.persistentData.getInt(originalEffectName) ?? 0
        let CD = Math.abs(player.age - time)
        if (CD < 20 * 60 * 4) {
            let remainingSeconds = Math.ceil((20 * 60 * 4 - CD) / 20)
            player.tell(`§d§d技能冷却中 (${remainingSeconds}秒)§r§d`)
            return
        }
        player.persistentData.putInt(originalEffectName, player.age)

        // 获取武器伤害值
        let weaponDamage = player.getAttributeTotalValue('minecraft:generic.attack_damage')
        // 播放特效和声音
        player.swing()
        player.level.playSound(null, player.x, player.y, player.z, 'minecraft:entity.ender_dragon.ambient', 'players', 1.0, 1.5)

        createAwakenedStartupEffects(player)
        // 执行10次攻击，每0.2秒(4tick)一次
        for (let i = 0; i < 12; i++) {
            Utils.server.scheduleInTicks(i * 4, () => {
                let entityList = getLivingWithinRadius(player.getLevel(), player.position(), 10)

                // 攻击范围内的敌人
                entityList.forEach(entity => {
                    if (entity.isLiving() && entity != player) {
                        simpleAttackEntity(true, player, entity, 'minecraft:out_of_world', weaponDamage)
                        // 攻击特效
                        dreamAurorianAttackParticles(entity)
                        drawSingleRandomSlashLineWithOffset(entity, 'minecraft:happy_villager', 0, player)
                    }
                })
                weaponDamage = weaponDamage * 1.1
                // 极光环绕特效
                dreamAurorianAuraParticles(player)
            })
        }

        // 11次攻击完成后（12*4=48tick + 16tick延迟）
        Utils.server.scheduleInTicks(48 + 16, () => {
            createJudgmentEye(player, weaponDamage * Math.pow(1.1, 12))
            Utils.server.scheduleInTicks(20 * 2, () => {
                let entityList = getLivingWithinRadius(player.getLevel(), player.position(), 10)
                entityList.forEach(entity => {
                    if (entity.isLiving() && entity != player) {
                        entity.potionEffects.add('minecraft:slowness', 20 * 3, 10)
                        simpleAttackEntity(true, player, entity, 'minecraft:out_of_world', player.getAttributeTotalValue('minecraft:generic.attack_damage') * 10)
                        // 攻击特效
                        dreamAurorianAttackParticles(entity)
                        drawTimeFissureSlash(entity, player, 3.0)
                    }
                })
            })
        })
    },
    //红石之心
    'redstone_heart': function (event, player, effectValue, item, originalEffectName) {
        let time = player.persistentData.getInt(originalEffectName) ?? 0
        let CD = Math.abs(player.age - time)
        if (CD < 20 * 30) return
        player.persistentData.putInt(originalEffectName, player.age)

        let Level = simpleGetTetraEffectLevel(item, 'redstone_heart')

        let effectvalue = player.getAttributeTotalValue('minecraft:generic.armor') + player.getAttributeTotalValue('minecraft:generic.armor_toughness')

        player.potionEffects.add('minecraft:absorption', 20 * 15, (effectvalue * Level) / 8)
    },
    // 融梦极光技能
    'dream_aurorian_steel': function (event, player, effectValue, item, originalEffectName) {
        if (simpleGetTetraEffectLevel(item, 'dream_aurorian_awakened') > 0) return

        let time = player.persistentData.getInt(originalEffectName) ?? 0
        let CD = Math.abs(player.age - time)
        if (CD < 20 * 60 * 3) // 冷却30秒
        {
            let remainingSeconds = Math.ceil((20 * 60 * 3 - CD) / 20)
            player.tell(`§b§d技能冷却中(${remainingSeconds}秒)§r§b`)
            return
        }
        player.persistentData.putInt(originalEffectName, player.age)

        // 获取武器伤害值
        let weaponDamage = player.getAttributeTotalValue('minecraft:generic.attack_damage')

        // 播放特效和声音
        player.swing()
        player.level.playSound(null, player.x, player.y, player.z, 'minecraft:entity.ender_dragon.ambient', 'players', 1.0, 1.5)

        // 执行10次攻击，每0.2秒(4tick)一次
        for (let i = 0; i < 8; i++) {
            Utils.server.scheduleInTicks(i * 4, () => {
                let entityList = getLivingWithinRadius(player.getLevel(), player.position(), 10)

                // 攻击范围内的敌人
                entityList.forEach(entity => {
                    if (entity.isLiving() && entity != player) {
                        simpleAttackEntity(true, player, entity, 'minecraft:out_of_world', weaponDamage)

                        dreamAurorianAttackParticles(entity)

                    }
                })
                // 极光环绕特效
                dreamAurorianAuraParticles(player)
            })
        }
    },
//旅行者之杖
'traveler_staff': function (event, player, effectValue, item,originalEffectName) {
    let time =  player.persistentData.getInt(originalEffectName)??0
    let CD = Math.abs(player.age - time)
    if (CD < 20 * 2)return
    player.persistentData.putInt(originalEffectName, player.age)

    let offitem = player.getOffhandItem()
    if (offitem == 'waystones:warp_dust'){
        let viewVector = player.getViewVector(1.0);
        let normalizedVector = normalizeVector(viewVector);

        player.setPosition(player.x + normalizedVector.x * 100, player.y, player.z + normalizedVector.z * 100)
        offitem.shrink(1)
    }else{
        let level = player.getXpLevel()
        if (level < 2) {
            player.tell('经验不足')
            return
        }
        player.giveExperiencePoints(-10)


        let viewVector = player.getViewVector(1.0);
        let normalizedVector = normalizeVector(viewVector);

        player.teleportTo(player.level.getDimension(), 
        player.x + normalizedVector.x * 16, 
        player.y + normalizedVector.y * 16, 
        player.z + normalizedVector.z * 16, 
        player.yaw, player.pitch)
    }
   
},
//遗魂头骨
'remnant_skull' : function (event, player, effectValue, item,originalEffectName){
    let time =  player.persistentData.getInt(originalEffectName)??0
    let CD = Math.abs(player.age - time)
    if (CD < 20 * 60 * 10)return
    player.persistentData.putInt(originalEffectName, player.age)

    let offitem = player.getOffhandItem()
    let maxHealth = player.getMaxHealth()
    let damageValue = player.getAttributeTotalValue('minecraft:generic.attack_damage' )
    if (offitem == 'minecraft:sniffer_egg'){
      //创建实体
      let spawn_entity = player.level.createEntity('cataclysm:modern_remnant')
      spawn_entity.setPosition(player.x, player.y + 1, player.z)
      spawn_entity.mergeNbt({Attributes: [{Base: maxHealth,Name: "minecraft:generic.max_health"},{Base: damageValue/2,Name: "minecraft:generic.attack_damage"}]})
      //生成实体
      spawn_entity.spawn()
      spawn_entity.tame(player)
      player.swing()
      offitem.shrink(1)
    }
},
'default': function (event, player, effectValue, item,originalEffectName) {
    return
}
}