// priority: 9
//每秒玩家刻事件
//参考脆骨症夜鸢大佬的代码
//不清楚优化会不会更好，但是写起来方便一点
PlayerEvents.tick(event => {
    let player = event.player;
    //每秒执行一次
    if (player.age % 20 !== 0 || !player) return;
    let item = player.getMainHandItem();
    if (!item.item instanceof $ModularItem) return;

    let effects = getAllEffects(item);
    if (!effects) return
    effects.forEach(effectName => {
        let originalEffectName = effectName.key
        let effectValue = simpleGetTetraEffectLevel(item, originalEffectName);
        let strategy = tetraPlayerTickStrategies[originalEffectName] || tetraPlayerTickStrategies.default;
        strategy(event, player, effectValue, item, originalEffectName);
    });
});

const tetraPlayerTickStrategies = {
    // 鹦鹉螺壳
    'nautilus_shell': function (event, player, effectValue, item, originalEffectName) {
        player.potionEffects.add('minecraft:water_breathing', 20 * 2, 2)
        player.potionEffects.add('minecraft:dolphins_grace', 20 * 2, 2)
    },
    // 贯虹
    'guan_hong': function (event, player, effectValue, item, originalEffectName) {
        // 检查主手是否持有Tetra弓
        if (item.getItem() instanceof $ModularBowItem) {
            // 检查玩家是否正在拉弓
            if (player.isUsingItem() && player.getUseItem() === item) {
                // 获取蓄力时长
                let bow = item.getItem();
                let useDuration = bow.getUseDuration(item);
                let remainingTicks = player.getUseItemRemainingTicks();
                let time = (useDuration - remainingTicks)/20
                //获取最大拉弓耗时
                let drawDuration = item.getItem().getDrawDuration(item)/20

                player.persistentData.putInt('guan_hong',Math.min(time,2*drawDuration))
            }
        }
    },
    // 下界合金块
    'netherite_block': function (event, player, effectValue, item, originalEffectName) {
        player.potionEffects.add('minecraft:fire_resistance', 20 * 1, 0)
    },
    //红石
    'red_stone': function (event, player, effectValue, item, originalEffectName) {
        player.potionEffects.add('minecraft:haste', 20 * 10, 0)
    },
    //融化
    'ice_break': function (event, player, effectValue, item, originalEffectName) {
        // 获取当前耐久度
        let currentDurability = item.getDamageValue();
        // 获取最大耐久度
        let maxDurability = item.getMaxDamage();

        // 如果还有耐久可以损失
        if (currentDurability < maxDurability) {
            // 增加1点损耗
            item.setDamageValue(currentDurability + 1);
        }
    },
    //光合作用
    'leaves_photosynthesis': function (event, player, effectValue, item, originalEffectName) {
        if (item.damageVale) {
            let level = getPlayerLightLevel(player)
            item.damageVale = item.damageVale - level
        }
    },
    //金锭
    'gold_ingot': function (event, player, effectValue, item, originalEffectName) {
        player.potionEffects.add('minecraft:haste', 20 * 10, 1)
    },
    //利维坦肉
    'leviathan_and_abyssal_egg': function (event, player, effectValue, item, originalEffectName) {
        player.potionEffects.add('minecraft:regeneration', 20 * 10, 1)
    },
    //时之沙
    'time_hourglass': function (event, player, effectValue, item, originalEffectName) {
        let random1 = Math.random()
        let random2 = Math.round(Math.random() * 2 * 100) / 100
        let damage = item.nbt.kubejs_damage || 0
        let shang_xian = item.nbt.shang_xian || 0
        if (random1 < 0.9 || shang_xian > 10) return
        item.nbt.putInt('kubejs_damage', damage + random2)
        item.nbt.putInt('shang_xian', shang_xian + 1)
        player.tell('主手武器攻击力已增加' + random2)
    },
    //脉冲风行者水晶
    'pulse_windrunner_crystal': function (event, player, effectValue, item, originalEffectName) {
        player.potionEffects.add('kubejs:fei_xing', 20 * 6, 2)
    },
    //风行者水晶
    'windrunner_crystal': function (event, player, effectValue, item, originalEffectName) {
        let dimension = player.level.getDimension()
        let meltdreamenergy = player.getAttribute('pasterdream:meltdreamenergy').getValue()
        if (dimension == 'pasterdream:wind_journey_world') {
            player.potionEffects.add('kubejs:fei_xing', 20 * 6, 0)
        } else if (meltdreamenergy >= 1) {
            player.potionEffects.add('kubejs:fei_xing', 20 * 6, 0)
            player.setAttributeBaseValue('pasterdream:meltdreamenergy', player.getAttribute('pasterdream:meltdreamenergy').getValue() - 1)
        }
    },
    //恶魂之泪
    'ghast_tear': function (event, player, effectValue, item, originalEffectName) {
        player.potionEffects.add('minecraft:regeneration', 20 * 60, 1)
    },
    //机械手柄
    'ji_xie_shou_bing': function (event, player, effectValue, item, originalEffectName) {
        let itemNbt = item.nbt
        //改进型—加速器检测
        if (itemNbt.getString("sword/reinforced_fuller_material") === "reinforced_fuller/jia_su_qi") {
            player.potionEffects.add('minecraft:haste', 20 * 10, 4)
        } else {
            player.potionEffects.add('minecraft:haste', 20 * 10, 1)
        }
    },
    //原初核心
    'primordial_core': function (event, player, effectValue, item, originalEffectName) {
        player.potionEffects.add('biomancy:despoil', 20 * 60, 1)
    },
    //巨食人鱼眼效果
    'sea_terror_eye': function (event, player, effectValue, item, originalEffectName) {
        player.potionEffects.add('minecraft:night_vision', 20 * 60, 0)
        player.potionEffects.add('minecraft:water_breathing', 20 * 60, 0)
        player.potionEffects.add('minecraft:dolphins_grace', 20 * 60, 0)
    },
    'default': function (event, player, effectValue, item, originalEffectName) {
        return
    }
}