// priority: 9
// 生物死亡事件
//参考脆骨症夜鸢大佬的代码
//不清楚优化会不会更好，但是写起来方便一点
function deathevent(event) {
    let player = event.source.player;
    if (!player) return;

    let item = player.getMainHandItem();
    if (!item.item instanceof $ModularItem) return;

    let effects = getAllEffects(item);
    effects.forEach(effectName => {
        let originalEffectName = effectName.key
        let effectValue = simpleGetTetraEffectLevel(item, originalEffectName);
        let strategy = tetraDeathStrategies[originalEffectName] || tetraDeathStrategies.default;
        strategy(event, player, effectValue, item, originalEffectName);
    });
};
const tetraDeathStrategies = {
    //击杀实体回血
    'forbidden_treatment': function (event, player, effectValue, item, originalEffectName) {
        let health = player.health
        player.setHealth(health + effectValue);
    },
    //击杀实体，增加冷却
    'cooling_add': function (event, player, effectValue, item, originalEffectName) {
        let offitem = player.getOffHandItem();
        offitem.addCooldown(2)
        player.getOffHandItem().addCooldown(2)
    },
    //击杀实体，清除主手，副手物品冷却
    'cooling_remove': function (event, player, effectValue, item, originalEffectName) {
        let offitem = player.getOffHandItem();
        player.getServer().scheduleInTicks(2, () => {
            player.addItemCooldown(item, 0)
            player.addItemCooldown(offitem, 0)
        })
    },
    //招魂球效果
    'orbofthe_summoner': function (event, player, effectValue, item, originalEffectName) {
        player.give(Item.of('born_in_chaos_v1:ethereal_spirit').withCount(1));
    },
    'default': function (event, player, effectValue, item, originalEffectName) {
        return
    }
}