//参考脆骨症夜鸢大佬的代码
//不清楚优化会不会更好，但是写起来方便一点
function tetraplayerhurt(event) {
    let player = event.entity;
    let item = player.getMainHandItem();
    if (!item.item instanceof $ModularItem) return;

    let effects = getAllEffects(item);
    effects.forEach(effectName => {
        let originalEffectName = effectName.key
        let effectValue = simpleGetTetraEffectLevel(item, originalEffectName);
        let strategy = tetraPlayerHurtStrategies[originalEffectName] || tetraPlayerHurtStrategies.default;
        strategy(event, player, effectValue, item, originalEffectName);
    });
}

const tetraPlayerHurtStrategies = {
    // 幻影
    'phantom_power': function (event, player, effectValue, item, originalEffectName) {
        let time = player.persistentData.getInt(originalEffectName) ?? 0
        let CD = Math.abs(player.age - time)
        let cooldownTime = 20 * 30 // 30秒冷却

        if (CD < cooldownTime) {
            // 冷却期间，15%概率重置冷却
            let resetChance = Math.random()
            if (resetChance <= 0.15) {
                // 重置冷却并闪避伤害
                player.persistentData.putInt(originalEffectName, player.age)
                event.amount = 0
                AvoidDamageParticleEffect(player)
            }
            // 否则正常受到伤害
            return
        }

        // 不在冷却中闪避伤害进入冷却
        player.persistentData.putInt(originalEffectName, player.age)
        event.amount = 0
        AvoidDamageParticleEffect(player)
    },
    // 鹦鹉螺壳
    'nautilus_shell': function (event, player, effectValue, item, originalEffectName) {
        //如果玩家在水里，有25%的减伤
        if (player.isInWater()) {
            player.potionEffects.add('minecraft:absorption', 20 * 5, 1)
            event.amount = event.amount * 0.75
        }
    },
    // 融梦
    'dream_aurorian_steel': function (event, player, effectValue, item, originalEffectName) {
        // 调用粒子环效果函数，传入事件对象以获取攻击方向
        dream_aurorian_hurt_particle_ring(event, player);
    },
    //龙鳞
    'dragon_scale': function (event, player, effectValue, item, originalEffectName) {
        event.amount = event.amount * 0.75
        let type = event.getSource().getType().toString();
        if (type == 'magic') {
            event.amount = 0
        }
    },
    //合金巨兽肉
    'cooked_netherite_monstrosity_meat': function (event, player, effectValue, item, originalEffectName) {
        if (player.isOnFire()) {
            event.amount *= 0.9
        }
    },
    //厚翅甲壳
    'black_beetle_carapace': function (event, player, effectValue, item, originalEffectName) {
        event.amount *= 0.85
    },
    //凝风铁锭
    'wind_iron_ingot': function (event, player, effectValue, item, originalEffectName) {
        let time = player.persistentData.getInt(originalEffectName) ?? 0
        let CD = Math.abs(player.age - time)
        if (CD < 40) return
        player.persistentData.putInt(originalEffectName, player.age)

        getLivingWithinRadius(player.getLevel(), new Vec3d(player.x, player.y, player.z), 4).forEach(entity => {
            //排除玩家
            if (entity.getStringUuid() != player.getStringUuid()) {
                entity.move('self', (new Vec3d(entity.x - player.x, entity.y - player.y, entity.z - player.z)).scale(2))
            }
        })
    },
    //闪电蠕虫甲壳
    'lightning_worm_chitin': function (event, player, effectValue, item, originalEffectName) {
        // 伤害类型
        let type = event.getSource().getType().toString()
        // 如果不是需要的伤害类型返回
        if (type !== 'lightningBolt') return;
        event.amount = 0
    },
    //电弧之牙
    'arc_fang': function (event, player, effectValue, item, originalEffectName) {
        // 伤害类型
        let type = event.getSource().getType().toString()
        // 如果不是需要的伤害类型返回
        if (type !== 'lightningBolt') return;
        event.amount = 0
    },
    // 骸骨之心镶嵌效果
    'bone_heart': function (event, player, effectValue, item, originalEffectName) {
        let time = player.persistentData.getInt(originalEffectName) ?? 0
        let CD = Math.abs(player.age - time)
        if (CD < 200) return
        player.persistentData.putInt(originalEffectName, player.age)
        // 免疫伤害
        event.amount = 0;
    },
    //窃命者头颅
    'lifestealer_skull': function (event, player, effectValue, item, originalEffectName) {
        let health = player.health
        let maxHealth = player.maxHealth
        if (health > maxHealth * 0.3) return
        player.potionEffects.add('minecraft:resistance', 20 * 10, 2)
    },
    // dark_atrium镶嵌效果
    'dark_atrium': function (event, player, effectValue, item, originalEffectName) {
        //获取玩家最大生命值
        let maxHealth = player.getMaxHealth()

        let time = player.persistentData.getInt(originalEffectName) ?? 0
        let CD = Math.abs(player.age - time)
        if (CD < 20 * 60 * 30) return
        player.persistentData.putInt(originalEffectName, player.age)

        //如果受到的伤害小于当前生命值，返回
        if (event.amount < player.getHealth()) return
        //反之受到的伤害设置为0，并恢复百分之30生命值
        event.amount = 0
        player.heal(maxHealth * 0.3)
        if (player.hasEffect('tetra:severed')) {
            // 获取已有的切割效果
            let effect = player.getEffect('tetra:severed')
            // 获取效果等级
            let amplifier = effect.getAmplifier()
            // 获取效果时长
            let duration = effect.getDuration()
            player.potionEffects.add('tetra:severed', duration + 20 * 100, amplifier + 5)
        }
        else {
            player.potionEffects.add('tetra:severed', 20 * 10, 0)
        }
    },
    'default': function (event, player, effectValue, item, originalEffectName) {
        return
    }
}