// priority: 9
// 持续粒子效果处理器
// 专门处理需要每tick执行的粒子效果

PlayerEvents.tick(event => {
    let player = event.player;
    if (!player) return;
    let item = player.getMainHandItem();
    if (!item.item instanceof $ModularItem) return;

    // 获取所有材料效果
    let effects = global.getAllEffects ? global.getAllEffects(item) : null;
    if (!effects) return;

    // 检查是否有需要持续粒子效果的效果
    effects.forEach(effectName => {
        let originalEffectName = global.reverseEffectMap ? global.reverseEffectMap[effectName] : effectName;
        let effectValue = global.getEffectLevel ? global.getEffectLevel(item, effectName) : 1;

        // 根据效果名称执行对应的持续粒子效果
        let particleStrategy = particleEffectStrategies[originalEffectName];
        if (particleStrategy) {
            particleStrategy(event, player, effectValue, item, originalEffectName);
        }
    });
});

const particleEffectStrategies = {
    // 融梦极光锭 - 梦境极光效果
    'dream_aurorian_steel': function (event, player, effectValue, item, originalEffectName) {
        let level = player.level;
        let x = Number(player.x);
        let y = Number(player.y + 0.1);
        let z = Number(player.z);
        let time = player.age * 0.1;

        // 脚下粒子痕迹效果 - electric_spark粒子
        if (player.age % 2 === 0) { // 2tick生成一次
            // 在玩家脚下位置生成end_rod粒子
            let footX = Number(x);
            let footY = Number(y);
            let footZ = Number(z);

            // 生成多个粒子挤在一起
            for (let i = 0; i < 3; i++) {
                // 在脚下位置稍微随机偏移
                let offsetX = footX + (Math.random() - 0.5) * 0.6;
                let offsetZ = footZ + (Math.random() - 0.5) * 0.6;
                let offsetY = footY + 0.1 + Math.random() * 0.3; // 稍微在地面上方

                level.spawnParticles("minecraft:electric_spark", true,
                    offsetX, offsetY, offsetZ,
                    0.0, 1, 0.0, 0.08, 0.0);// 粒子存在时间稍长一些
            }

            // 额外添加一些向上漂浮的粒子
            if (player.age % 6 === 0) { // 低频率漂浮粒子
                level.spawnParticles("minecraft:electric_spark", true,
                    footX, footY + 0.2, footZ,
                    0.0, 2, 0.0, 0.15, 0.02 // 轻微向上的速度
                );
            }
        }
    },
    // 下界合金块 - 火焰环效果
    'lava_ring': function (event, player, effectValue, item, originalEffectName) {
        let level = player.level;
        let x = Number(player.x);
        let y = Number(player.y + 0.1);
        let z = Number(player.z);
        let radius = 2.8; //半径
        
        let time = player.age * 100; // 旋转速度
        
        // 在环形路径上更密集地生成粒子，形成连续的环
        for (let i = 0; i < 24; i++) {
            let angle = time + (i * 0.262); // 0.262 ≈ π/12，每15度一个粒子
            let particleX = x + radius * Math.cos(angle);
            let particleZ = z + radius * Math.sin(angle);
            
            // 确保坐标是有效数字
            if (!isNaN(particleX) && !isNaN(particleZ)) {
                try {
                    // 使用更精确的粒子生成方法
                    level.spawnParticles("minecraft:flame", true, // 改为true强制显示
                        particleX, y, particleZ, 
                        0.0, // 不偏移
                        1,   // 每个位置生成1个粒子
                        0.0, // 不偏移
                        2,   // 缩短存在时间
                        0.0  // 完全无速度
                    );
                } catch (error) {
                    // 静默处理错误
                }
            }
        }
        
        // 额外在相同位置再生成一层，确保密度
        for (let i = 0; i < 24; i++) {
            // 偏移一半角度，填补空隙
            let angle = time + (i * 0.262) + 0.131;
            let particleX = x + radius * Math.cos(angle);
            let particleZ = z + radius * Math.sin(angle);
            
            if (!isNaN(particleX) && !isNaN(particleZ)) {
                try {
                    level.spawnParticles("minecraft:flame", true,
                        particleX, y, particleZ, 
                        0.0, 1, 0.0, 2, 0.0
                    );
                } catch (error) {
                    // 静默处理错误
                }
            }
        }
    },
    'default': function (event, player, effectValue, item, originalEffectName) {
        return
    }
}; 