// priority: 9

//参考脆骨症夜鸢大佬的代码
//不清楚优化会不会更好，但是写起来方便一点
NetworkEvents.dataReceived('mainhand_effect', event => {
    let player = event.player;
    if (!player) return;
    let item = player.getMainHandItem();
    if (!item.item instanceof $ModularItem) return;

    let effects = getAllEffects(item);
    effects.forEach(effectName => {
        let originalEffectName = effectName.key
        let effectValue = simpleGetTetraEffectLevel(item, originalEffectName);
        let strategy = tetraPlayerkeybindStrategies[originalEffectName] || tetraPlayerkeybindStrategies.default;
        strategy(event, player, effectValue, item, originalEffectName);
    });
});


const tetraPlayerkeybindStrategies = {
    'villager_metal_block': function (event, player, effectValue, item, originalEffectName) {
        let time = player.persistentData.getInt(originalEffectName) ?? 0
        let CD = Math.abs(player.age - time)
        if (CD < 20 * 60) return // 1分钟CD
        player.persistentData.putInt(originalEffectName, player.age)

        let Level = simpleGetTetraEffectLevel(item, 'villager_metal_block')
        let uuid = player.getUuid()

        let ironGolem = player.level.createEntity('minecraft:iron_golem')

        ironGolem.setPosition(player.x + 2, player.y, player.z)
        ironGolem.setOwner(player)
        ironGolem.spawn()

        ironGolem.persistentData.putString('owner', uuid)
        ironGolem.persistentData.putInt('player_created', 1)

        ironGolem.maxHealth = 100 + Level * 20
        ironGolem.health = ironGolem.maxHealth

        ironGolem.getServer().scheduleInTicks(20 * 30, () => {
            if (ironGolem.isAlive()) {
                player.level.spawnParticles('minecraft:happy_villager', true,
                    ironGolem.x, ironGolem.y + 1, ironGolem.z, 0.5, 1.0, 0.5, 0.1, 20)
                ironGolem.discard()
            }
        })
    },
    //闪电法术
    'lightning_spell': function (event, player, effectValue, item, originalEffectName) {
        let time = player.persistentData.getInt(originalEffectName) ?? 0
        let CD = Math.abs(player.age - time)
        if (CD < 20 * 10) return
        player.persistentData.putInt(originalEffectName, player.age)

        let damageValue = player.getAttributeTotalValue('minecraft:generic.attack_damage')
        let effect_level = simpleGetTetraEffectLevel(item, 'call_thunder');
        let entityList = getLivingWithinRadius(player.getLevel(), player.position(), 16)
        entityList.forEach(entity => {
            if (entity.isLiving() && entity != player) {
                // 延迟一刻执行，这样可以让训练假人正常显示伤害
                entity.getServer().scheduleInTicks(1, () => {
                    simpleAttackEntity(true, player, entity, 'minecraft:lightning_bolt', damageValue * effect_level);
                    let spawn_entity = entity.level.createEntity("minecraft:lightning_bolt");
                    spawn_entity.setPosition(entity.x, entity.y, entity.z);
                    spawn_entity.setVisualOnly(true)
                    spawn_entity.spawn();
                })
            }
        })
        },
    //火焰吐息
    'fire_breath': function (event, player, effectValue, item, originalEffectName) {
        let time = player.persistentData.getInt(originalEffectName) ?? 0
        let CD = Math.abs(player.age - time)
        if (CD < 20 * 10) return
        player.persistentData.putInt(originalEffectName, player.age)

        let level = player.level
        let viewVector = player.getViewVector(1.0);
        let normalizedVector = normalizeVector(viewVector)
        let spawn_entity = player.level.createEntity("legendary_monsters:fire_breath");
        spawn_entity.setPosition(player.x, player.y + 1, player.z);
        spawn_entity.setMotion(normalizedVector.x * 4, normalizedVector.y * 4, normalizedVector.z * 4);
        spawn_entity.setRotation(player.yaw, player.pitch)
        spawn_entity.spawn();
        spawn_entity.geten


        fire_breath(level, player, spawn_entity.getUuid())
        function fire_breath(level, player, uuid) {
            let spawn_entity = level.getEntity(uuid)
            if (!spawn_entity) return
            player.server.scheduleInTicks(1, () => {
                spawn_entity.teleportTo(level.dimension, player.x, player.y + 1, player.z, player.yaw, player.pitch)
                fire_breath(level, player, spawn_entity.uuid)
                let entity = player.rayTrace().entity
                if (entity) {
                    let a = player.getAttributeTotalValue('attributeslib:fire_damage') * effectValue / 100
                    simpleAttackEntity(false, null, entity, 'attributeslib:fire_damage', a)
                }
            })
        }
    },
    //蔚蓝海洋之心
    'blue_heart_of_the_sea': function (event, player, effectValue, item, originalEffectName) {
        event.server.runCommandSilent("/weather thunder")
    },
    //武弁头
    'aptrgangr_head': function (event, player, effectValue, item, originalEffectName) {
        let time = player.persistentData.getInt(originalEffectName) ?? 0
        let CD = Math.abs(player.age - time)
        if (CD < 20 * 10) return
        player.persistentData.putInt(originalEffectName, player.age)

        let damageValue = player.getAttributeTotalValue('minecraft:generic.attack_damage')
        let viewVector = player.getViewVector(1.0);
        let normalizedVector = normalizeVector(viewVector)
        let spawn_entity = player.level.createEntity("cataclysm:axe_blade");
        spawn_entity.setPosition(player.x, player.y + 1, player.z);
        spawn_entity.setMotion(normalizedVector.x * 4, normalizedVector.y * 4, normalizedVector.z * 4);
        spawn_entity.setRotation(player.yaw, player.pitch)
        spawn_entity.setOwner(player);
        spawn_entity.persistentData.putInt('attack_addition', damageValue * 1.2)
        spawn_entity.spawn();
    },
    //末影之眼
    'ender_eye': function (event, player, effectValue, item, originalEffectName) {
        let deathLocation = player.lastDeathLocation
        if (deathLocation.isPresent()) {
            let deathPos = deathLocation.get().pos()
            player.teleportTo(deathLocation.get().dimension(), deathPos.x, deathPos.y, deathPos.z, event.player.yaw, event.player.pitch)
        }
    },
    //幻境石水晶
    'myalite_crystal': function (event, player, effectValue, item, originalEffectName) {
        let time = player.persistentData.getInt(originalEffectName) ?? 0
        let CD = Math.abs(player.age - time)
        if (CD < 20 * 30) return
        player.persistentData.putInt(originalEffectName, player.age)

        getLivingWithinRadius(player.getLevel(), new Vec3d(player.x, player.y, player.z), 8).forEach(entity => {
            //排除玩家
            if (!entity.isPlayer()) {
                entity.potionEffects.add('kubejs:ru_meng', 20 * 3, 0)
            }
        })
    },
    //末影合金
    'enderite_block': function (event, player, effectValue, item, originalEffectName) {
        let time = player.persistentData.getInt(originalEffectName) ?? 0
        let CD = Math.abs(player.age - time)
        if (CD < 20 * 10) return
        player.persistentData.putInt(originalEffectName, player.age)

        let damageValue = player.getAttributeTotalValue('minecraft:generic.attack_damage')
        let viewVector = player.getViewVector(1.0);
        let normalizedVector = normalizeVector(viewVector);
        //开始拉屎！
        getLivingWithinRadius(player.getLevel(), new Vec3d(player.x, player.y, player.z), 16).forEach(entity => {
            //排除玩家
            if (!entity.isPlayer()) {
                //牵引过来
                entity.move('self', (new Vec3d(player.x - entity.x, player.y - entity.y, player.z - entity.z)).scale(1))
                entity.getServer().scheduleInTicks(5, () => {
                    //根据玩家朝向肘飞
                    entity.move('self', (new Vec3d(normalizedVector.x, 8, normalizedVector.z)).scale(1))
                    //差不多摔下来时造成伤害
                    entity.getServer().scheduleInTicks(15, () => {
                        simpleAttackEntity(true, player, entity, 'player_attack', damageValue * 2)
                    })
                })
            }
        })
    },
    //连锁
    'chain_destruction': function (event, player, effectValue, item, originalEffectName) {
        if (player.persistentData.getBoolean('chain_destruction_switch')) {
            player.persistentData.putBoolean('chain_destruction_switch', false)
            player.tell('连锁已开启')
            player.tell('小心你的房子')
        } else {
            player.persistentData.putBoolean('chain_destruction_switch', true)
            player.tell('连锁已关闭')
        }
    },
    //龙首
    'dragon_head': function (event, player, effectValue, item, originalEffectName) {
        let time = player.persistentData.getInt(originalEffectName) ?? 0
        let CD = Math.abs(player.age - time)
        if (CD < 20 * 5) return
        player.persistentData.putInt(originalEffectName, player.age)

        let level = player.level
        let viewVector = player.getViewVector(1.0);
        let normalizedVector = normalizeVector(viewVector)
        let spawn_entity = level.createEntity("minecraft:dragon_fireball")
        spawn_entity.setPosition(player.x, player.y + 1, player.z);
        spawn_entity.setMotion(normalizedVector.x * 2, normalizedVector.y * 2, normalizedVector.z * 2);
        spawn_entity.setOwner(player);
        spawn_entity.spawn();
        spawn_entity.getServer().scheduleInTicks(20 * 3, () => {
            if (spawn_entity) {
                spawn_entity.kill()
            }
        })
    },
    //霜冻符文
    'frozen_rune': function (event, player, effectValue, item, originalEffectName) {
        let time = player.persistentData.getInt(originalEffectName) ?? 0
        let CD = Math.abs(player.age - time)
        if (CD < 20 * 60) return
        player.persistentData.putInt(originalEffectName, player.age)

        // 获取周围实体
        let entityList = getLivingWithinRadius(player.getLevel(), player.position(), 5)
        // 遍历实体列表
        entityList.forEach(entity => {
            if (entity.isLiving() && entity != player) {
                entity.modifyAttribute('minecraft:generic.max_health', 'shi_wen', -0.2, 'multiply_total')
                entity.potionEffects.add('legendary_monsters:freeze', 20 * 5, 0)
            }
        })
    },
    //时之沙
    'time_hourglass': function (event, player, effectValue, item, originalEffectName) {
        let time = player.persistentData.getInt(originalEffectName) ?? 0
        let CD = Math.abs(player.age - time)
        if (CD < 20 * 60) return
        player.persistentData.putInt(originalEffectName, player.age)

        let health = player.health
        if (item.nbt.ni_zhuan) {
            let ni_zhuan = item.nbt.ni_zhuan
            player.setHealth(ni_zhuan)
            item.nbt.remove('ni_zhuan')
            player.sendData('time_hourglass')
        } else {
            item.nbt.putInt('ni_zhuan', health)
        }
    },
    //滕炎锭
    'ignitium_ingot': function (event, player, effectValue, item, originalEffectName) {
        let time = player.persistentData.getInt(originalEffectName) ?? 0
        let CD = Math.abs(player.age - time)
        if (CD < 20 * 60) return
        player.persistentData.putInt(originalEffectName, player.age)

        let level = player.level
        let entity_1 = level.createEntity("cataclysm:flame_strike")
        entity_1.setPosition(player.x, player.y, player.z)
        entity_1.mergeNbt({ Radius: 9 })
        entity_1.setOwner(player)
        entity_1.spawn()
    },
    //玄武蜗牛壳
    'snailshell': function (event, player, effectValue, item, originalEffectName) {
        let time = player.persistentData.getInt(originalEffectName) ?? 0
        let CD = Math.abs(player.age - time)
        if (CD < 1) return
        player.persistentData.putInt(originalEffectName, player.age)

        player.potionEffects.add('minecraft:resistance', 20 * 8, 2)
        player.potionEffects.add('minecraft:slowness', 20 * 8, 4)
    },
    //村民金属锭
    'villager_metal_ingot': function (event, player, effectValue, item, originalEffectName) {
        player.potionEffects.add('minecraft:hero_of_the_village', 20 * 60, 0)
    },
    //暴怒符咒
    'charmof_fury': function (event, player, effectValue, item, originalEffectName) {
        if (player.hasEffect('born_in_chaos_v1:medium_rampage')) return
        player.potionEffects.add('born_in_chaos_v1:medium_rampage', 20 * 60 * 5, 1)
        reduce_durability(item, 50)
    },
    //耐力符文
    'charmof_endurance': function (event, player, effectValue, item, originalEffectName) {
        if (player.hasEffect('minecraft:speed')) return
        player.potionEffects.add('minecraft:speed', 20 * 60 * 5, 4)
        reduce_durability(item, 50)
    },
    //隐身符咒
    'charmof_stealth': function (event, player, effectValue, item, originalEffectName) {
        if (player.hasEffect('minecraft:invisibility')) return
        player.potionEffects.add('minecraft:invisibility', 20 * 60 * 5, 2)
        reduce_durability(item, 50)
    },
    //力量符咒
    'charmof_power': function (event, player, effectValue, item, originalEffectName) {
        if (player.hasEffect('minecraft:strength')) return
        player.potionEffects.add('minecraft:strength', 20 * 60 * 5, 2)
        reduce_durability(item, 50)
    },
    //抗性符咒
    'charmof_resistance': function (event, player, effectValue, item, originalEffectName) {
        if (player.hasEffect('minecraft:resistance')) return
        player.potionEffects.add('minecraft:resistance', 20 * 60 * 5, 1)
        reduce_durability(item, 50)
    },
    'default': function (event, player, effectValue, item, originalEffectName) {
        return
    }
}