// priority: 500

let totalWeight = 0;
for (let i = 0; i < lootList_1.length; i++) {
    totalWeight += lootList_1[i].weight;
}

LootJS.modifiers(event => {
    event.addLootTypeModifier(LootType.CHEST)
       .apply(event => {
            // 生成一个 0 到总权重之间的随机数
            let randomValue = Math.random() * totalWeight;

            // 根据随机数选择物品
            let currentWeight = 0;
            for (let i = 0; i < lootList_1.length; i++) {
                currentWeight += lootList_1[i].weight;
                if (randomValue < currentWeight) {
                    event.addLoot(lootList_1[i].item);
                    break;
                }
            }
        });
    event.addLootTypeModifier(LootType.CHEST)
        .anyStructure(['minecraft:ancient_city'], false)
        .addLoot(LootEntry.of('quark:ancient_sapling').when((c) => c.randomChance(0.5)))
});

//海底白澜水晶
LootJS.modifiers(event => {
    event.addLootTypeModifier(LootType.CHEST)
       .apply(event => {
            let player = event.player;
            let random = Math.random();
            if (!player)return
            if (!player.inWater || random < 0.5) return;
            event.addLoot('art_of_forging:vobrite_crystal');
        });
});

let totalWeight_stage_2 = 0;
for (let i = 0; i < stage_2.length; i++) {
    totalWeight_stage_2 += stage_2[i].weight;
}

LootJS.modifiers(event => {
    event.addLootTypeModifier(LootType.CHEST)
       .apply(event => {
            let player = event.player;
            let random = Math.random();
            if (!player || random < 0.5) return;
            let dimension = player.level.getDimension();
            if (dimension !== "pasterdream:aaroncos_arena_world" && 
                dimension !== "pasterdream:dyedream_world" && 
                dimension !== "pasterdream:lamp_shadow_world" &&
                dimension !== "minecraft:the_nether"
            ) return;
            let randomValue = Math.random() * totalWeight_stage_2;

            // 根据随机数选择物品
            let currentWeight = 0;
            for (let i = 0; i < stage_2.length; i++) {
                currentWeight += stage_2[i].weight;
                if (randomValue < currentWeight) {
                    event.addLoot(stage_2[i].item);
                    break;
                }
            }
        });
});


let totalWeight_stage_3 = 0;
for (let i = 0; i < stage_3.length; i++) {
    totalWeight_stage_3 += stage_3[i].weight;
}

LootJS.modifiers(event => {
    event.addLootTypeModifier(LootType.CHEST)
        .apply(event => {
            let player = event.player;
            let random = Math.random();
            if (!player || random < 0.2) return;
            let dimension = player.level.getDimension();
            if (dimension !== "jerotesvillage:second_round_world" &&
                dimension !== "minecraft:the_end"
            ) return;
            let randomValue = Math.random() * totalWeight_stage_3;

            // 根据随机数选择物品
            let currentWeight = 0;
            for (let i = 0; i < stage_3.length; i++) {
                currentWeight += stage_3[i].weight;
                if (randomValue < currentWeight) {
                    event.addLoot(stage_3[i].item);
                    break;
                }
            }
        });
});


