TetraAdditionEvents.craft(event => {
    let { player, level, currentSchematic, currentSlot, targetStack, upgradedStack, materials, workbenchTile } = event
    let materialItem = materials[0].id
    if (level.clientSide) return
    //根据材料幻化
    materials_transmog(event)
    //根据schematic幻化
    schematic_transmog(event)
    
})
const transmog_slot = [
    'helmet',
    'chestplate',
    'belt',
    'feet'
]

const tetra_wear_transmog = [
    {
        material: 'minecraft:iron_ingot',
        helmet: 'minecraft:iron_helmet',
        chestplate: 'minecraft:iron_chestplate',
        leggings: 'minecraft:iron_leggings',
        boots: 'minecraft:iron_boots'
    },
    {
        material: 'minecraft:diamond',
        helmet: 'minecraft:diamond_helmet',
        chestplate: 'minecraft:diamond_chestplate',
        leggings: 'minecraft:diamond_leggings',
        boots: 'minecraft:diamond_boots'
    },
    {
        material: 'cataclysm:ignitium_ingot',
        helmet: 'cataclysm:ignitium_helmet',
        chestplate: 'cataclysm:ignitium_chestplate',
        leggings: 'cataclysm:ignitium_leggings',
        boots: 'cataclysm:ignitium_boots'
    },
    {
        material: 'create:precision_mechanism',
        helmet: 'protection_pixel:lanceras_helmet',
        chestplate: 'protection_pixel:magneticstormas_chestplate',
        leggings:'protection_pixel:buoyancyas_leggings',
        boots: 'protection_pixel:socks_boots'
    },
]
//根据材料幻化
function materials_transmog(event){
    let { player, level, currentSchematic, currentSlot, targetStack, upgradedStack, materials, workbenchTile } = event
    let materialItem = materials[0].id
    if (level.clientSide) return

    let boolean = false
    if (!targetStack.nbt.contains("transmog:transmogItem")) {
        boolean = true
    }
    if (hasModuleKey(currentSchematic) && transmog_slot.includes(currentSlot)) {
        boolean = true
    }
    if (boolean == false)return

    // 检测物品是否为头盔
    if (upgradedStack === "1 helmet") {
        let transmog_item = 'minecraft:netherite_helmet';
        for (let material of tetra_wear_transmog) {
            if (material.material === materialItem) {
                transmog_item = material.helmet;
                break; 
            }
        }
        $TransmogUtils.transmogAppearanceOntoItemStack(transmog_item, upgradedStack);
    } else if (upgradedStack === "1 chestplate") {
        let transmog_item = 'minecraft:netherite_chestplate';
        for (let material of tetra_wear_transmog) {
            if (material.material === materialItem) {
                transmog_item = material.chestplate;
                break;
            }
        }
        $TransmogUtils.transmogAppearanceOntoItemStack(transmog_item, upgradedStack);
    } else if (upgradedStack === "1 legging") {
        let transmog_item = 'minecraft:netherite_leggings';
        for (let material of tetra_wear_transmog) {
            if (material.material === materialItem) {
                transmog_item = material.leggings;
                break;
            }
        }
        $TransmogUtils.transmogAppearanceOntoItemStack(transmog_item, upgradedStack);
    } else if (upgradedStack === "1 feet") {
        let transmog_item = 'minecraft:netherite_boots';
        for (let material of tetra_wear_transmog) {
            if (material.material === materialItem) {
                transmog_item = material.boots;
                break;
            }
        }
        $TransmogUtils.transmogAppearanceOntoItemStack(transmog_item, upgradedStack);
    }
}
//tetra盔甲幻化改造
const tetra_wear_schematic_transmog = {
    //活体盔甲
    'armor/helmet/living_helmet': Item.of('biomancy:acolyte_armor_helmet', '{"biomancy:nutrients":200}'),
    'armor/chestplate/living_chestplate': Item.of('biomancy:acolyte_armor_chestplate', '{"biomancy:nutrients":250}'),
    'armor/legging/living_belt': Item.of('biomancy:acolyte_armor_leggings', '{"biomancy:nutrients":250}'),
    'armor/feet/living_feet': Item.of('biomancy:acolyte_armor_boots', '{"biomancy:nutrients":200}'),
    //炼狱盔甲
    'armor/helmet/purgatory_helmet': 'cataclysm:ignitium_helmet',
    'armor/chestplate/purgatory_chestplate': 'cataclysm:ignitium_chestplate',
    'armor/legging/purgatory_belt': 'cataclysm:ignitium_leggings',
    'armor/feet/purgatory_feet': 'cataclysm:ignitium_boots',
    //瘟疫盔甲
    'armor/helmet/pestilence_helmet': 'geckojs:pestilence_helmet',
    'armor/chestplate/pestilence_chestplate': 'geckojs:pestilence_chestplate',
    'armor/legging/pestilence_belt': 'geckojs:pestilence_leggings',
    'armor/feet/pestilence_feet': 'geckojs:pestilence_boots',
    //遗忘者之帽
    'armor/helmet/forgotten_hat': 'quark:forgotten_hat'
}
//根据schematic幻化
function schematic_transmog(event){
    let { player, level, currentSchematic, currentSlot, targetStack, upgradedStack, materials, workbenchTile } = event
    if (level.clientSide) return
    let schematic = currentSchematic.key
    //player.tell(schematic)
    let transmog = tetra_wear_schematic_transmog[schematic]
    if (transmog) {
        $TransmogUtils.transmogAppearanceOntoItemStack(transmog, upgradedStack)
    }
}
