//锻造等级增加
//学徒锻造师，入门锻造师，精英锻造师，传奇锻造师
TetraAdditionEvents.craft(event =>{
    let player = event.player
    let level = event.level
    //防止单人的时候client侧出问题
    if (level.clientSide) return

    //防止语言提示过于频繁
    let random = Math.random()
    if (random < 0.9) return

    //学徒
    if (player.persistentData.contains("forge_grade_apprentice")){
        let amount = player.persistentData.getInt("forge_grade_apprentice") + 1
        player.persistentData.putInt("forge_grade_apprentice", amount)
        player.tell("§f经验值进度" + amount + "/10§r")
        
        if (amount >= 10) {
            player.persistentData.remove("forge_grade_apprentice")
            player.persistentData.putInt("forge_grade_novice", 1)
            player.tell("§6恭喜！§a你已从§f学徒锻造师§a晋升为§a入门锻造师！§r")
            player.tell("§a当前等级加成：§e你锻造的兵器拥有高质量一词条§r")
            player.tell("§a当前等级加成：§e锻造盔甲时有条件的保留盔甲上的打磨§r")
            player.tell("§e在任务书界面，按ctrl+f搜索:锻造师等级，查看详情§r") 
        } else {
            player.tell("§f当前等级加成：无§r")
        }
    }
    //入门
    else if (player.persistentData.contains("forge_grade_novice")){
        let amount = player.persistentData.getInt("forge_grade_novice") + 1
        player.persistentData.putInt("forge_grade_novice", amount)
        player.tell("§a经验值进度" + amount + "/10§r")
        
        if (amount >= 10) {
            player.persistentData.remove("forge_grade_novice")
            player.persistentData.putInt("forge_grade_elite", 1)
            player.tell("§6恭喜！§9你已从§a入门锻造师§9晋升为§9精英锻造师！§r")
            player.tell("§9当前等级加成：§e你锻造的兵器拥有高质量二词条§r")
            player.tell("§e在任务书界面，按ctrl+f搜索:锻造师等级，查看详情§r") 
        } else {
            player.tell("§a当前等级加成：§e你锻造的兵器拥有高质量一词条§r")
            player.tell("§a当前等级加成：§e锻造盔甲时有条件的保留盔甲上的打磨§r")
            player.tell("§e在任务书界面，按ctrl+f搜索:锻造师等级，查看详情§r") 
        }
    }
    //精英
    else if (player.persistentData.contains("forge_grade_elite")){
        let amount = player.persistentData.getInt("forge_grade_elite") + 1
        player.persistentData.putInt("forge_grade_elite", amount)
        player.tell("§9经验值进度" + amount + "/10§r")
        
        if (amount >= 10) {
            player.persistentData.remove("forge_grade_elite")
            player.persistentData.putInt("forge_grade_legendary", 1)
            player.tell("§6恭喜！§d你已从§9精英锻造师§d晋升为§d传奇锻造师！§r")
            player.tell("§d当前等级加成：§e你锻造的兵器拥有高质量三词条§r")
            player.tell("§a当前等级加成：§e锻造盔甲时有条件的保留盔甲上的打磨§r")
            player.tell("§e在任务书界面，按ctrl+f搜索:锻造师等级，查看详情§r") 
        } else {
            player.tell("§9当前等级加成：§e你锻造的兵器拥有高质量二词条§r")
            player.tell("§a当前等级加成：§e锻造盔甲时有条件的保留盔甲上的打磨§r")
            player.tell("§e在任务书界面，按ctrl+f搜索:锻造师等级，查看详情§r") 
        }
    }
    //传奇
    else if (player.persistentData.contains("forge_grade_legendary")){
    }
    //初始化
    else{
        player.persistentData.putInt("forge_grade_apprentice", 1)
        player.tell("§f你已开始锻造师之旅，当前等级：§f学徒锻造师§r")
        player.tell("§f当前等级加成：无§r")
    }
})


//不同等级的锻造师获取加成
TetraAdditionEvents.craft(event =>{
    let player = event.player
    let level = event.level
    //防止单人的时候client侧出问题
    if (level.clientSide) return

    //学徒
    if (player.persistentData.contains("forge_grade_apprentice")){
        forge_grade_addition(event,0)
    }
    //入门
    if (player.persistentData.contains("forge_grade_novice")){
        forge_grade_addition(event,1)
    }
    //精英
    if (player.persistentData.contains("forge_grade_elite")){
        forge_grade_addition(event,2)
    }
    //传奇
    if (player.persistentData.contains("forge_grade_legendary")){
        forge_grade_addition(event,3)
    }
})
//后续再优化，有更好的解决方法了
function forge_grade_addition(event, grade) {
    let item = event.upgradedStack;
    switch (item) {
        case "1 modular_shield":
            let gripQuality = item.nbt.getInt("shield/grip:quality");
            if (gripQuality < grade) {
                $ItemModuleMajor.addImprovement(item, "shield/grip", "quality", grade);
            }
            let plateQuality = item.nbt.getInt("shield/plate:quality");
            if (plateQuality < grade) {
                $ItemModuleMajor.addImprovement(item, "shield/plate", "quality", grade);
            }
            break;

        case "1 modular_single":
            let singleHandleQuality = item.nbt.getInt("single/handle:quality");
            if (singleHandleQuality < grade) {
                $ItemModuleMajor.addImprovement(item, "single/handle", "quality", grade);
            }

            let singleHeadQuality = item.nbt.getInt("single/head:quality");
            if (singleHeadQuality < grade) {
                $ItemModuleMajor.addImprovement(item, "single/head", "quality", grade);
            }
            break;

        case "1 modular_crossbow":
            let crossbowStaveQuality = item.nbt.getInt("crossbow/stave:quality");
            if (crossbowStaveQuality < grade) {
                $ItemModuleMajor.addImprovement(item, "crossbow/stave", "quality", grade);
            }
            let crossbowStockQuality = item.nbt.getInt("crossbow/stock:quality");
            if (crossbowStockQuality < grade) {
                $ItemModuleMajor.addImprovement(item, "crossbow/stock", "quality", grade);
            }
            break;

        case "1 modular_bow":
            let bowStaveQuality = item.nbt.getInt("bow/stave:quality");
            if (bowStaveQuality < grade) {
                $ItemModuleMajor.addImprovement(item, "bow/stave", "quality", grade);
            }
            let bowStringQuality = item.nbt.getInt("bow/string:quality");
            if (bowStringQuality < grade) {
                $ItemModuleMajor.addImprovement(item, "bow/string", "quality", grade);
            }
            break;

        case "1 modular_sword":
            let swordBladeQuality = item.nbt.getInt("sword/blade:quality");
            if (swordBladeQuality < grade) {
                $ItemModuleMajor.addImprovement(item, "sword/blade", "quality", grade);
            }
            let swordHiltQuality = item.nbt.getInt("sword/hilt:quality");
            if (swordHiltQuality < grade) {
                $ItemModuleMajor.addImprovement(item, "sword/hilt", "quality", grade);
            }
            break;

        case "1 modular_double":
            let doubleLeftHeadQuality = item.nbt.getInt("double/head_left:quality");
            if (doubleLeftHeadQuality < grade) {
                $ItemModuleMajor.addImprovement(item, "double/head_left", "quality", grade);
            }
            let doubleRightHeadQuality = item.nbt.getInt("double/head_right:quality");
            if (doubleRightHeadQuality < grade) {
                $ItemModuleMajor.addImprovement(item, "double/head_right", "quality", grade);
            }
            let doubleHandleQuality = item.nbt.getInt("double/handle:quality");
            if (doubleHandleQuality < grade) {
                $ItemModuleMajor.addImprovement(item, "double/handle", "quality", grade);
            }
            break;
    }
}

const tetra_armor = [
    'tetra:helmet',   
    'tetra:chestplate',
    'tetra:legging',
    'tetra:feet'
]

//改造保留打磨
TetraAdditionEvents.craft(event => {
    let { player, level, currentSchematic, currentSlot, targetStack, upgradedStack, materials } = event
    //防止单人的时候client侧出问题
    if (level.clientSide) return

    //检测改造的shcematic是否包含modulekey，只有包含modulekey才会导致improvement消失
    //其实这一步不需要的，但是我好不容易翻出来的代码，总得用用不是（雾）
    //hasModuleKey放在下面介绍
    if (!hasModuleKey(currentSchematic)) return

    //再检测module是否更改，因为不同的module可以改造improvement，防止一些专属打磨出现在其他武器上，出现叠叠乐
    //detectModuleChanges放在下面介绍
    if (detectModuleChanges(targetStack, upgradedStack).removed == null) return

    //检测物品是否为盔甲
    if (!tetra_armor.includes(upgradedStack.getId())) return

    //检测玩家锻造师等级
    if (player.persistentData.contains("forge_grade_apprentice"))return

    //下面就是保留打磨的部分了

    // 改造前的module
    // 遍历 outcomes 检查 moduleKey
    let remodel_module = ''
    for (let outcome of currentSchematic.definition.outcomes) {
        if (outcome.moduleKey != null) {
            //outcome.moduleKey有一大串东西，只取一个就行
            remodel_module = outcome.moduleKey
            break
        }
    }

    if (remodel_module != '') {
        let all_improvement = [];

        // 获取目标装备的模块改进项及其等级
        let modules_target = targetStack.getItem().getMajorModules(targetStack)
        for (let module of modules_target) {
            //检测是否为改造前的module
            if (module && module.key == remodel_module) {
                //获取全部的improvement，以及对应的等级
                all_improvement = module.getImprovements(targetStack).map(improvement => {
                    return {
                        name: improvement.key,
                        level: module.getImprovementLevel(targetStack, improvement.key)
                    };
                });
                break;
            }
        }

        // 将改进项及其等级应用到升级装备
        let modules_upgraded = upgradedStack.getItem().getMajorModules(upgradedStack);
        for (let module of modules_upgraded) {
            if (module.key == remodel_module) {
                for (let improvement of all_improvement) {
                    //加回improvement
                    module.addImprovement(upgradedStack, improvement.name, improvement.level);
                }
                break;
            }
        }
    }
})