const armorPlates = [
    "protection_pixel:ironarmorplate",
    "protection_pixel:brassarmorplate",
    "protection_pixel:alloyarmorplate"
];
const item_module = {
    '1 feet':'feet',
    '1 legging':'belt',
    '1 chestplate':'chestplate',
    '1 helmet':'helemt'
}
const power_module = [
    'armor/feet/power_feet',
    'armor/legging/power_belt',
    'armor/chestplate/power_chestplate',
    'armor/helmet/power_helmet'
]
TetraAdditionEvents.craft(event => {
    let { player, level, currentSchematic, currentSlot, targetStack, upgradedStack, materials } = event;
   // 防止单人的时候client侧出问题
    if (level.clientSide) return;

    let item = materials[0];
    let id = item.id;

    // 检查id是否匹配列表中的任一项目
    if (armorPlates.some(plate => id.includes(plate))) {
        let damageValue = item.damageValue
        //存入损坏值以及使用的材料
        upgradedStack.nbt.putInt('armorplates_damage_value',Math.min(damageValue,100))
        upgradedStack.nbt.putString('armorplates_material',id)
    }
});
//受伤时，armorplates_damage_value的nbt增加
function tetra_wear_armorplate_event(event){
    let player = event.entity
    let tetra_armor = [
        player.getHeadArmorItem(),
        player.getChestArmorItem(),
        player.getLegsArmorItem(),
        player.getFeetArmorItem()
    ]
    tetra_armor.forEach(armor => {
        let random = Math.random()
        if (armor.nbt.armorplates_damage_value != null && random < 0.3){
            //插槽的损伤值加一,最大100
            armor.nbt.armorplates_damage_value = Math.min(armor.nbt.armorplates_damage_value + 1,100)
            // 如果到了100，表示损坏
            if (armor.nbt.armorplates_damage_value == 100){
                player.tell('插槽已损毁')
                //获取插槽所在的位置
                let solt = item_module[armor]
                //获取之前存入使用的插槽
                let armorplates_material = armor.nbt.armorplates_material.split(":")[1]
                //移除插槽的improvement
                remove_improvement(armor, 'power_armor/armorplate/' + armorplates_material,true)
                //移除记录损坏值nbt
                armor.nbt.remove('armorplates_damage_value')
                //移除记录的使用材料
                armor.nbt.remove('armorplates_material')
                //损毁后给予玩家插槽
                player.give(Item.of(armor.nbt.armorplates_material, '{Damage:100}'))
                //加入代表损坏的improvement
                //$ItemModuleMajor.addImprovement(armor, solt, 'power_armor/damaged_armorplate/' + armorplates_material, 0)
            }
        }
    })
}
//取出插板效果实现
TetraAdditionEvents.craft(event => {
    let { player, level, currentSchematic, currentSlot, targetStack, upgradedStack, materials, workbenchTile } = event
    //防止单人的时候client侧出问题
    if (level.clientSide) return
    //获取改进的名字
    let schematic = currentSchematic.getKey()
    if (schematic == "armor/shared/power_armor/remove_armorplate") {
        //获取之前存入使用的插槽
        let armorplates_material = upgradedStack.nbt.armorplates_material.split(":")[1]
        //移除插槽的improvement
        remove_improvement(upgradedStack, 'power_armor/armorplate/' + armorplates_material, true)
        //获取记录的损坏值
        let damage = upgradedStack.nbt.armorplates_damage_value
        let item = Item.of(upgradedStack.nbt.armorplates_material)
        item.damageValue = item.damageValue + damage
        //给予玩家插槽
        player.give(item)
        //移除记录损坏值nbt
        upgradedStack.nbt.remove('armorplates_damage_value')
        //移除记录的使用材料
        upgradedStack.nbt.remove('armorplates_material')
    }
})
//更改主要部件时,取出插槽
TetraAdditionEvents.craft(event => {
    let { player, level, currentSchematic, currentSlot, targetStack, upgradedStack, materials } = event;
    // 防止单人的时候client侧出问题
    if (level.clientSide) return;

    let remove_module = detectModuleChanges(targetStack, upgradedStack).removed
    let isPowerModuleRemoved = remove_module.some(module => power_module.includes(module));
    if (isPowerModuleRemoved && upgradedStack.nbt.armorplates_damage_value) {
        //给予玩家插槽
        player.give(item)
        //移除记录损坏值nbt
        upgradedStack.nbt.remove('armorplates_damage_value')
        //移除记录的使用材料
        upgradedStack.nbt.remove('armorplates_material')
    }
})
