// priority: 8
ItemEvents.rightClicked(event => {
    let player = event.player
    let item = event.item
    
    // 获取所有tetra饰品
    let tetraItems = getTetraCurios(player);
    if (!tetraItems || tetraItems.length === 0) return;
    
    // 用于累加相同效果的总等级
    let totalEffectLevels = {};

    // 遍历所有饰品，累加相同效果的等级
    for (let curioItem of tetraItems) {
        let effects = getAllEffects(curioItem);
        if (!effects) return

        effects.forEach(effectName => {
            let originalEffectName = effectName.key
            let effectLevel = simpleGetTetraEffectLevel(curioItem, originalEffectName);

            // 累加效果等级
            if (!totalEffectLevels[originalEffectName]) {
                totalEffectLevels[originalEffectName] = effectLevel
            } else {
                totalEffectLevels[originalEffectName] += effectLevel
            }
        })
    }

    // 第二步：遍历所有累加后的效果，执行对应策略
    for (let originalEffectName in totalEffectLevels) {
        let totalLevel = totalEffectLevels[originalEffectName];

        // 查找对应的策略并执行（传入总等级）
        let strategy = curios_tetra_you_jian_Strategies[originalEffectName] || curios_tetra_you_jian_Strategies.default;
        strategy(event, player, totalLevel, originalEffectName,item);
    }
})

const curios_tetra_you_jian_Strategies = {
//大气符文
'air_rune' : function (event, player, effectLevel, originalEffectName,item){
    if (item != 'legendary_monsters:air_rune')return
    let uuid = player.getUuid()
    let maxhealth = player.getMaxHealth()
    let damageValue = player.getAttributeTotalValue('minecraft:generic.attack_damage' )

    //创建实体
    let spawn_entity = player.level.createEntity('legendary_monsters:cloud_golem')
    //实体位置
    spawn_entity.setPosition(player.x, player.y + 1, player.z)
    //生成实体
    spawn_entity.spawn()

    spawn_entity.persistentData.putInt('yi_shang', 10 - maxhealth/4)
    spawn_entity.persistentData.putString('owner', uuid)
    spawn_entity.persistentData.putInt(attack_addition, damageValue/4)

    player.swing()
    item.shrink(1)

},
//沙暴水晶
'crystal_of_sandstorm' : function (event, player, effectLevel, originalEffectName,item){
    if (item != 'legendary_monsters:crystal_of_sandstorm')return

    let uuid = player.getUuid()
    let maxhealth = player.getMaxHealth()
    let damageValue = player.getAttributeTotalValue('minecraft:generic.attack_damage' )

    //创建实体
    let spawn_entity = player.level.createEntity('legendary_monsters:dune_sentinel')
    //实体位置
    spawn_entity.setPosition(player.x, player.y + 1, player.z)
    //生成实体
    spawn_entity.spawn()

    spawn_entity.persistentData.putInt('yi_shang', 10 - maxhealth/4)
    spawn_entity.persistentData.putString('owner', uuid)
    spawn_entity.persistentData.putInt(attack_addition, damageValue/4)

    player.swing()
    item.shrink(1)

},
//自然水晶
'nature_crystal' : function (event, player, effectLevel, originalEffectName,item){
    if (item != 'legendary_monsters:nature_crystal')return

    let uuid = player.getUuid()
    let maxhealth = player.getMaxHealth()
    let damageValue = player.getAttributeTotalValue('minecraft:generic.attack_damage' )

    //创建实体
    let spawn_entity = player.level.createEntity('legendary_monsters:overgrown_colossus')
    //实体位置
    spawn_entity.setPosition(player.x, player.y + 1, player.z)
    //生成实体
    spawn_entity.spawn()

    spawn_entity.persistentData.putInt('yi_shang', 10 - maxhealth/4)
    spawn_entity.persistentData.putString('owner', uuid)
    spawn_entity.persistentData.putInt(attack_addition, damageValue/4)

    player.swing()
    item.shrink(1)

},
//始冰碎片
'primal_ice_shard' : function (event, player, effectLevel, originalEffectName,item){
    if (item != 'legendary_monsters:primal_ice_shard')return

    let uuid = player.getUuid()
    let maxhealth = player.getMaxHealth()
    let damageValue = player.getAttributeTotalValue('minecraft:generic.attack_damage' )

    //创建实体
    let spawn_entity = player.level.createEntity('legendary_monsters:frostbitten_golem')
    //实体位置
    spawn_entity.setPosition(player.x, player.y + 1, player.z)
    //生成实体
    spawn_entity.spawn()

    spawn_entity.persistentData.putInt('yi_shang', 10 - maxhealth/4)
    spawn_entity.persistentData.putString('owner', uuid)
    spawn_entity.persistentData.putInt(attack_addition, damageValue/4)

    player.swing()
    item.shrink(1)

},
//堕落之魂
'corrupted_soul': function (event,player,effectLevel,originalEffectName,item) {
    let time =  player.persistentData.getInt(originalEffectName)??0
    let CD = Math.abs(player.age - time)
    if (CD < 20 * 60 * 10)return
    player.persistentData.putInt(originalEffectName, player.age)

    let damageValue = player.getAttributeTotalValue('minecraft:generic.attack_damage' )
    if (item != 'minecraft:iron_ingot')return
    //创建实体
    let spawn_entity = player.level.createEntity('legendary_monsters:guard')
    spawn_entity.setPosition(player.x, player.y + 1, player.z)
    spawn_entity.persistentData.putInt(attack_addition, damageValue)
    //生成实体
    spawn_entity.spawn()
    spawn_entity.tame(player)
    player.swing()
    item.shrink(1)



},
    'default': function (event,player,effectLevel,originalEffectName,item) {
        return;
    }
};