// priority: 8
PlayerEvents.tick(event => {
    let player = event.entity;
    // 每秒执行一次
    if (player.age % 21 != 0 || !player) return

    // 获取所有tetra饰品
    let tetraItems = getTetraCurios(player);
    if (!tetraItems || tetraItems.length === 0) return;
    
    // 用于累加相同效果的总等级
    let totalEffectLevels = {};

    // 遍历所有饰品，累加相同效果的等级
    for (let curioItem of tetraItems) {
        let effects = getAllEffects(curioItem);
        if (!effects) return

        effects.forEach(effectName => {
            let originalEffectName = effectName.key
            let effectLevel = simpleGetTetraEffectLevel(curioItem, originalEffectName);

            // 累加效果等级
            if (!totalEffectLevels[originalEffectName]) {
                totalEffectLevels[originalEffectName] = effectLevel
            } else {
                totalEffectLevels[originalEffectName] += effectLevel
            }
        })
    }

    // 第二步：遍历所有累加后的效果，执行对应策略
    for (let originalEffectName in totalEffectLevels) {
        let totalLevel = totalEffectLevels[originalEffectName];

        // 查找对应的策略并执行（传入总等级）
        let strategy = curiostetraTimeStrategies[originalEffectName] || curiostetraTimeStrategies.default;
        strategy(event, player, totalLevel, originalEffectName);
    }
          })

const curiostetraTimeStrategies = {
    //治疗灌注
    'regeneration': function (event, player, effectLevel, originalEffectName) {
        player.potionEffects.add('minecraft:regeneration', 20 * 6, effectLevel-1);
        },
    //灾厄旗帜投影绿宝石碎片
    'ominous_banner_projection_emerald_fragment': function (event,player,effectLevel,originalEffectName) {
        player.potionEffects.add('minecraft:hero_of_the_village', 20 * 6, 4);
    },
    //繁星使者花朵
    'prosperous_envoy_flower': function (event,player,effectLevel,originalEffectName) {
        let level = player.level;
        // 遍历高度范围，从玩家高度 - 1 到玩家高度 + 1
        for (let y = player.y - 1; y <= player.y + 1; y++) {
            // 遍历玩家周围五格方块的 x 坐标
            for (let x = player.x - 5; x <= player.x + 5; x++) {
                // 遍历玩家周围五格方块的 z 坐标
                for (let z = player.z - 5; z <= player.z + 5; z++) {
                    if (level.getBlock(x, y, z).hasTag('minecraft:crops')) {
                        let blockState = level.getBlockState(new BlockPos(x, y, z));
                        let block = level.getBlockState(new BlockPos(x, y, z)).getBlock();
                        block.performBonemeal(level, level.random, new BlockPos(x, y, z), blockState);
                    }
                }
            }
        }
    },
    //缩小血清
    'shrinking_serum': function (event,player,effectLevel,originalEffectName) {
        let check_name = 'bio_lab'
        if (!effect_check(player, check_name)) {
            let time = player.persistentData.getInt(originalEffectName) ?? 0;
            if (player.age - time < 20 * 60) return;
        }
        let count = player.persistentData.getInt(YingYangCount);
        if (count < 1) return;
        player.potionEffects.add('kubejs:suo_xiao', 20 * 6, 0);
        updateYingYangCount(player, count - 1);
        player.persistentData.putInt(originalEffectName, player.age)
    },
    //巨化血清
    'enlargement_serum': function (event,player,effectLevel,originalEffectName) {
        let check_name = 'bio_lab'
        if (!effect_check(player, check_name)) {
            let time = player.persistentData.getInt(originalEffectName) ?? 0;
            if (player.age - time < 20 * 60) return;
        }
        let count = player.persistentData.getInt(YingYangCount);
        if (count < 1) return;
        player.potionEffects.add('kubejs:ju_hua', 20 * 6, 0);
        updateYingYangCount(player, count - 1);
        player.persistentData.putInt(originalEffectName, player.age)
    },
    //恶兽犄角
    'monstrous_horn': function (event,player,effectLevel,originalEffectName) {
        let health = player.health;
        let maxhealth = player.maxHealth;
        if (health >= maxhealth) {
            player.potionEffects.add('cataclysm:monstrous', 20 * 10, 0);
        } else {
            player.potionEffects.add('cataclysm:monstrous', 20 * 10, 1);
        }
    },

    //治愈添加物
    'healing_additive': function (event,player,effectLevel,originalEffectName) {
        let check_name = 'bio_lab'
        if (!effect_check(player, check_name)) {
            let time = player.persistentData.getInt(originalEffectName) ?? 0;
            if (player.age - time < 20 * 60) return;
        }
        //获取营养值
        let count = player.persistentData.getInt(YingYangCount);
        if (count < 2) return;
        //减少营养值
        updateYingYangCount(player, count - 1);
        player.potionEffects.add('minecraft:regeneration', 20 * 10, 0);
        player.persistentData.putInt(originalEffectName, player.age)
    },
    //深渊之卵
    'abyssal_egg': function (event,player,effectLevel,originalEffectName) {
        if (player.isInWaterOrRain()) {
            player.potionEffects.add('kubejs:fei_xing', 20 * 7, 0);
        }
    },
    //咒翼
    'zhou_yi': function (event,player,effectLevel,originalEffectName) {
        player.potionEffects.add('kubejs:zhou_yi', 20 * 60, 0);
    },
    //紫沙鬼婆头发
    'purple_sand_hag_hair': function (event,player,effectLevel,originalEffectName) {
        player.potionEffects.add('minecraft:night_vision', 20 * 60, 0);
    },
    //明路
    'bright_land_beast_fluff': function (event,player,effectLevel,originalEffectName) {
        player.potionEffects.add('jerotesvillage:bright_land_heart', 20 * 60, 0);
    },
    'default': function (event,player,effectLevel,originalEffectName) {
        return;
    }
};