// priority: 8
function curiostetraplayerhurt(event) {
    let player = event.entity;

    // 获取所有tetra饰品
    let tetraItems = getTetraCurios(player);
    if (!tetraItems || tetraItems.length === 0) return;

    // 用于累加相同效果的总等级
    let totalEffectLevels = {};

    // 遍历所有饰品，累加相同效果的等级
    for (let curioItem of tetraItems) {
        let effects = getAllEffects(curioItem);
        if (!effects) return

        effects.forEach(effectName => {
            let originalEffectName = effectName.key
            let effectLevel = simpleGetTetraEffectLevel(curioItem, originalEffectName);

            // 累加效果等级
            if (!totalEffectLevels[originalEffectName]) {
                totalEffectLevels[originalEffectName] = effectLevel
            } else {
                totalEffectLevels[originalEffectName] += effectLevel
            }
        })
    }

    // 第二步：遍历所有累加后的效果，执行对应策略
    for (let originalEffectName in totalEffectLevels) {
        let totalLevel = totalEffectLevels[originalEffectName];

        // 查找对应的策略并执行（传入总等级）
        let strategy = curiostetraplayerhurtStrategies[originalEffectName] || curiostetraplayerhurtStrategies.default;
        strategy(event, player, totalLevel, originalEffectName);
    }
}

const curiostetraplayerhurtStrategies = {
    //神圣
    'invincible_frames': function (event, player, effectLevel, originalEffectName) {
        player.invulnerableTime = player.invulnerableTime + effectLevel

    },
    //凋零合金块
    'witherite_block': function (event, player, effectLevel, originalEffectName) {
        // 伤害类型
        let type = event.getSource().getType().toString();
        if (type == 'explosion.player') {
            event.amount = 0
        }

    },
    //伤痛反应剂
    'absorption_boost': function (event, player, effectLevel, originalEffectName) {
        if (!effect_check(player, 'bio_lab')) {
            let time = player.persistentData.getInt(originalEffectName) ?? 0;
            if (player.age - time < 20 * 60 * 30) return;
        }
        //获取营养值
        let count = player.persistentData.getInt(YingYangCount)
        if (count < 2) return
        //减少营养值
        updateYingYangCount(player, count - 1)
        player.absorptionAmount = Math.min(player.absorptionAmount + 1, 5)
        player.persistentData.putInt(originalEffectName, player.age)
    },
    // 蚀龙兽断角
    'corrosiver_broken_horn': function (event, player, effectLevel, originalEffectName) {
        event.amount = event.amount * 0.92;
    },
    // 灾厄旗帜投影绿宝石碎片
    'ominous_banner_projection_emerald_fragment': function (event, player, effectLevel, originalEffectName) {
        event.amount = event.amount * 0.95;
    },
    // 紫沙鬼婆头发
    'purple_sand_hag_hair': function (event, player, effectLevel, originalEffectName) {
        event.amount = event.amount * 0.92;
    },
    // 宝石恶鳞鳞片
    'gemstone_malignasaur_scale': function (event, player, effectLevel, originalEffectName) {
        event.amount = event.amount * 0.92;
    },
    // 沉降领主袍服碎片
    'sediment_lord_robe_pieces': function (event, player, effectLevel, originalEffectName) {
        event.amount = event.amount * 0.95;
    },
    // 繁兴使者花朵
    'prosperous_envoy_flower': function (event, player, effectLevel, originalEffectName) {
        event.amount = event.amount * 0.95;
    },
    // 明路巨兽绒毛
    'bright_land_beast_fluff': function (event, player, effectLevel, originalEffectName) {
        event.amount = event.amount * 0.92;
    },
    // 蛇龙执战者勋章
    'serpon_combat_executer_medal': function (event, player, effectLevel, originalEffectName) {
        event.amount = event.amount * 0.90
        let random = Math.random()
        if (random <= 0.25) {
            event.amount = 0
        }
    },
    'default': function (event, player, effectLevel, originalEffectName) {
        return
    }
}