// priority: 8
//熔岩行者/水上行走
NativeEvents.onEvent($StandOnFluidEvent, event => {
    let player = event.getEntity()
    if (!player || !player.isPlayer()) return
    let boolean = false
    if (!player.isCrouching()) {
        if (getPlayerCuriosEffectData(player, 'lava_walker').level > 0 && event.getFluidState().fluidType == 'minecraft:lava') {
            boolean = true
        }
        if (getPlayerCuriosEffectData(player, 'water_walker').level > 0 && event.getFluidState().fluidType == 'minecraft:water') {
            boolean = true
        }
    }
    event.setCanceled(boolean)
})

//磁力之戒
PlayerEvents.tick(event => {
    let player = event.entity;
    // 每0.25秒执行一次
    if (player.age % 5 != 0 || !player) return
    let effect = getPlayerCuriosEffectData(player, 'magnetic')
    if (effect.level == 0) return
    let entityList = getLivingWithinRadius(player.getLevel(), player.position(), effect.level)
    //实体遍历
    entityList.forEach(entity => {
        if (!entity.isPlayer()) {
            let dx = player.x - entity.x
            let dy = player.y - entity.y
            let dz = player.z - entity.z
            entity.move('self', (new Vec3d(dx, dy, dz)).scale(1))
        }
    })
})
//生物毒素瓶
PlayerEvents.tick(event => {
    let player = event.entity;
    // 每五秒执行一次
    if (player.age % 100 != 0 || !player) return
    let effect = getPlayerCuriosEffectData(player, 'biotoxin_bottles')
    let entityList = getLivingWithinRadius(player.getLevel(), player.position(), effect.level)
    let random = Math.random()
    //实体遍历
    entityList.forEach(entity => {
        //是否为敌对
        if (entity.isMonster()) {

            //debuff持续效果增加实现
            entity.potionEffects.active.forEach(ctx => {
                let name = ctx.getEffect().getDescriptionId()
                if (effect_blacklist.includes(name)) return
                if (ctx.getEffect().getCategory() == 'HARMFUL') {
                    entity.potionEffects.add(ctx.effect, Math.min(ctx.getDuration() + 20 * effect.efficiency, 20 * 240), ctx.getAmplifier())
                }
            })

            //化骨散效果实现
            if (getPlayerCuriosEffectData(player, 'hua_gu_san').level > 0) {
                entity.modifyAttribute('minecraft:generic.armor', 'hua_gu_san', -0.2, 'multiply_base')
            }

            //黑死病效果实现
            if (getPlayerCuriosEffectData(player, 'black_death').level > 0) {
                let pestilence_amount = player.getAttributeTotalValue('kubejs:pestilence')
                simpleAttackEntity(true, player, entity, 'pestilence', pestilence_amount)
            }

            //石灰粉效果实现
            if (getPlayerCuriosEffectData(player, 'lime_powder').level > 0) {
                entity.potionEffects.add('minecraft:blindness', 20 * 30, 0)
            }

            //阴阳合欢散效果实现
            if (getPlayerCuriosEffectData(player, 'he_huan_san').level > 0 && entity.type != 'biomancy:primordial_hungry_flesh_blob') {
                if (random < 0.3) {
                    //减少生命
                    entity.setHealth(entity.getHealth() * 0.95)


                    //生下原初饥饿肉块
                    let spawn_entity = entity.level.createEntity("biomancy:primordial_hungry_flesh_blob")
                    spawn_entity.setPosition(entity.x, entity.y, entity.z)
                    spawn_entity.spawn();
                    spawn_entity.setTarget(entity)
                    spawn_entity.getServer().scheduleInTicks(20 * 20, () => {
                        if (spawn_entity) {
                            spawn_entity.kill()
                        }
                    })


                }
            }

            //五步蛇毒效果实现
            if (getPlayerCuriosEffectData(player, 'wu_bu_she').level > 0) {
                // 获取或初始化位置记录
                if (!entity.persistentData.contains('last_position')) {
                    entity.persistentData.put('last_position', {
                        x: entity.x,
                        y: entity.y,
                        z: entity.z
                    })
                } else {
                    // 计算移动距离
                    let lastPos = entity.persistentData.get('last_position')
                    let dx = entity.x - lastPos.x
                    let dy = entity.y - lastPos.y
                    let dz = entity.z - lastPos.z
                    let distance = Math.sqrt(dx * dx + dy * dy + dz * dz)

                    // 如果移动超过5格，触发后续效果
                    if (distance > 5) {
                        // 延长所有负面效果持续时间
                        entity.potionEffects.active.forEach(ctx => {
                            if (ctx.getEffect().getCategory() == 'HARMFUL') {
                                let name = ctx.getEffect().getDescriptionId()
                                if (effect_blacklist.includes(name)) return
                                entity.potionEffects.add(ctx.effect, Math.min(ctx.getDuration() + 20 * 10, 20 * 240), ctx.getAmplifier())
                            }
                        })
                        // 更新位置记录
                        entity.persistentData.put('last_position', {
                            x: entity.x,
                            y: entity.y,
                            z: entity.z
                        })
                    }
                }
            }


        }
    })
})