// priority: 8
NetworkEvents.dataReceived('curios_effect', event => {
    let player = event.player;
    if (!player) return;

    // 获取所有tetra饰品
    let tetraItems = getTetraCurios(player);
    if (!tetraItems || tetraItems.length === 0) return;

    // 用于累加相同效果的总等级
    let totalEffectLevels = {};

    // 遍历所有饰品，累加相同效果的等级
    for (let curioItem of tetraItems) {
        let effects = getAllEffects(curioItem);
        if (!effects) return

        effects.forEach(effectName => {
            let originalEffectName = effectName.key
            let effectLevel = simpleGetTetraEffectLevel(curioItem, originalEffectName);

            // 累加效果等级
            if (!totalEffectLevels[originalEffectName]) {
                totalEffectLevels[originalEffectName] = effectLevel
            } else {
                totalEffectLevels[originalEffectName] += effectLevel
            }
        })
    }

    // 第二步：遍历所有累加后的效果，执行对应策略
    for (let originalEffectName in totalEffectLevels) {
        let totalLevel = totalEffectLevels[originalEffectName];

        // 查找对应的策略并执行（传入总等级）
        let strategy = curios_tetra_keybind_Strategies[originalEffectName] || curios_tetra_keybind_Strategies.default;
        strategy(event, player, totalLevel, originalEffectName);
    }
})

const curios_tetra_keybind_Strategies = {
    // 台阶高度
    'tai_jie_gao_du': function (event, player, effectLevel, originalEffectName) {
        let isEnabled = player.persistentData.getBoolean(originalEffectName) ?? false

        if (isEnabled) {
            // 关闭状态
            player.persistentData.putBoolean(originalEffectName, false);
            player.modifyAttribute('forge:step_height_addition', originalEffectName + 'curios', 0, 'addition');
            player.tell('台阶高度已关闭');
        } else {
            // 开启状态
            player.persistentData.putBoolean(originalEffectName, true);
            player.modifyAttribute('forge:step_height_addition', originalEffectName + 'curios', effectLevel / 5, 'addition');
            player.tell('台阶高度已开启');
        }
    },
    //原初温床联动效果
    'primordial_cradle': function (event, player, effectLevel, originalEffectName) {
        let count = player.persistentData.getInt(YingYangCount)

        let time = player.persistentData.getInt(originalEffectName) ?? 0
        let CD = Math.abs(player.age - time)
        if (CD < count / 10) return
        player.persistentData.putInt(originalEffectName, player.age)

        if (arrmor_total_effect_level(player, 'living') == 4) {
            player.potionEffects.add('kubejs:living', 2 * count, count/100 - 1)
            player.getServer().scheduleInTicks(2 * count, () => {
                updateYingYangCount(player, 0)
            })
        }
    },
    //配种兴奋剂
    'breeding_stimulant': function (event, player, effectLevel, originalEffectName) {
        if (!effect_check(player, 'bio_lab')) {
            let time = player.persistentData.getInt(originalEffectName) ?? 0;
            if (player.age - time < 20 * 60) return;
        }

        //获取营养值
        let count = player.persistentData.getInt(YingYangCount)
        if (count < 2) return
        // 获取周围实体
        let entityList = getLivingWithinRadius(player.getLevel(), player.position(), 3)
        // 遍历实体列表
        entityList.forEach(entity => {
            if (entity.isLiving()) {
                entity.potionEffects.add('biomancy:libido', 20 * 60, 0)
            }
        })
        //减少营养值
        updateYingYangCount(player, count - 2)

        //彩蛋
        let random = Math.random()
        if (random < 0.05 && count > 52) {
            //创建实体
            let spawn_entity = player.level.createEntity('biomancy:primordial_hungry_flesh_blob')
            spawn_entity.setPosition(player.x, player.y, player.z)
            //生成实体
            spawn_entity.spawn()
            player.tell('伟大的母亲注视了你，你诞生了一个子嗣')
            updateYingYangCount(player, count - 50)
        }

        player.persistentData.putInt(originalEffectName, player.age)
    },
    // 滕炎锭
    'ignitium_ingot': function (event, player, effectLevel, originalEffectName) {
        // return
        let level = player.level;

        let time = player.persistentData.getInt(originalEffectName) ?? 0
        let CD = Math.abs(player.age - time)
        if (CD < 20 * 60) return
        player.persistentData.putInt(originalEffectName, player.age)

        let viewVector = player.getViewVector(1.0);
        let normalizedVector = normalizeVector(viewVector);

        for (let i = 1; i <= 5; i++) {
            let entity_1 = level.createEntity("cataclysm:flame_strike");
            entity_1.setPosition(
                player.x + 3 * i * normalizedVector.x,
                player.y,
                player.z + 3 * i * normalizedVector.z
            );
            entity_1.setOwner(player);
            entity_1.mergeNbt({ Duration: 1 });
            entity_1.spawn();
        }
    },
    //狂暴血清
    'frenzy_serum': function (event, player, effectLevel, originalEffectName) {
        let count = player.persistentData.getInt(YingYangCount)
        if (!effect_check(player, 'bio_lab')) {
            let time = player.persistentData.getInt(originalEffectName) ?? 0
            if (player.age - time < 20 * 60) return;
        } 
        if (player.hasEffect('biomancy:withdrawal') || player.hasEffect('biomancy:frenzy') || count < 50) return
        let random = Math.random()
        if (random < 0.3) { player.potionEffects.add('biomancy:frenzy', 20 * 60, 0) }
        if (random < 0.6 && random > 0.3) { player.potionEffects.add('biomancy:frenzy', 20 * 60, 1) }
        if (random > 0.6) { player.potionEffects.add('biomancy:frenzy', 20 * 30, 2) }
        //减少营养值
        updateYingYangCount(player, count - 50)
    },
    'default': function (event, player, effectLevel, originalEffectName) {
        return
    }
}