// priority: 8
//参考脆骨症的代码


function CuriosTetraPlayerAttack(event) {
    let player = event.source.player;
    if (!player) return;

    // 获取所有tetra饰品
    let tetraItems = getTetraCurios(player);
    if (!tetraItems || tetraItems.length === 0) return;

    // 用于累加相同效果的总等级
    let totalEffectLevels = {};

    // 遍历所有饰品，累加相同效果的等级
    for (let curioItem of tetraItems) {
        let effects = getAllEffects(curioItem);
        if (!effects) return

        effects.forEach(effectName => {
            let originalEffectName = effectName.key
            let effectLevel = simpleGetTetraEffectLevel(curioItem, originalEffectName);

            // 累加效果等级
            if (!totalEffectLevels[originalEffectName]) {
                totalEffectLevels[originalEffectName] = effectLevel
            } else {
                totalEffectLevels[originalEffectName] += effectLevel
            }
        })
    }

    // 第二步：遍历所有累加后的效果，执行对应策略
    for (let originalEffectName in totalEffectLevels) {
        let totalLevel = totalEffectLevels[originalEffectName];

        // 查找对应的策略并执行（传入总等级）
        let strategy = CuriosTetraPlayerAttackStrategies[originalEffectName] || CuriosTetraPlayerAttackStrategies.default;
        strategy(event, player, totalLevel, originalEffectName);
    }
}

const CuriosTetraPlayerAttackStrategies = {
    //深渊之卵
    'abyssal_egg': function (event, player, effectLevel, originalEffectName) {
        //如果玩家在飞行
        if (player.abilities.flying) {
            event.amount = event.amount * 0.1
        }
    },
    //不稳定化合物
    'unstable_compound': function (event, player, effectLevel, originalEffectName) {
        let check_name = 'bio_lab'
        if (!effect_check(player, check_name)) {
            let time = player.persistentData.getInt(originalEffectName) ?? 0;
            if (player.age - time < 20 * 60) return;
        }

        // 获取并检查营养值
        let count = player.persistentData.getInt(YingYangCount) ?? 0;
        if (count < 2) return;

        // 执行爆炸效果
        updateYingYangCount(player, count - 2);
        let explosion = event.entity.block.createExplosion();
        explosion.strength(3);
        explosion.explode();

        player.persistentData.putInt(originalEffectName, player.age);
    },
    //净化血清
    'cleansing_serum': function (event, player, effectLevel, originalEffectName) {
        if (!effect_check(player, 'bio_lab')) {
            let time = player.persistentData.getInt(originalEffectName) ?? 0;
            if (player.age - time < 20 * 60) return;
        }

        let entity = event.entity
        //获取营养值
        let count = player.persistentData.getInt(YingYangCount)
        if (count < 2) return

        let effectsToRemove = [];
        entity.potionEffects.active.forEach(ctx => {
            effectsToRemove.push(ctx.effect);
        });

        // 如果有buff被移除，则减少营养值
        if (effectsToRemove.length > 0) {
            //减少营养值
            updateYingYangCount(player, count - 2)
            // 遍历 effectsToRemove 数组，移除效果
            effectsToRemove.forEach(effect => {
                entity.removeEffect(effect);
            })
        }
        player.persistentData.putInt(originalEffectName, player.age)
    },
    //凋零合金块
    'witherite_block': function (event, player, effectLevel, originalEffectName) {
        let time = player.persistentData.getInt(originalEffectName) ?? 0
        let CD = Math.abs(player.age - time)
        if (CD < 10) return
        player.persistentData.putInt(originalEffectName, player.age)

        let entity = event.entity;
        if (entity.hasEffect('minecraft:wither')) {
            let effect = entity.getEffect('minecraft:wither');
            let amplifier = effect.getAmplifier();
            let duration = effect.getDuration();
            entity.potionEffects.add('minecraft:wither', duration, amplifier + 1);
        } else {
            entity.potionEffects.add('minecraft:wither', 20 * 30, 0);
        }
    },
    //风暴瓶
    'sandstorm_in_a_bottle': function (event, player, effectLevel, originalEffectName) {
        let time = player.persistentData.getInt(originalEffectName) ?? 0
        let CD = Math.abs(player.age - time)
        if (CD < 10) return
        player.persistentData.putInt(originalEffectName, player.age)

        let type = event.getSource().getType().toString();
        if (type == 'mob') {
            event.entity.invulnerableTime = 0
        } else {
            player.getServer().scheduleInTicks(10, () => {
                let level = player.level
                let viewVector = player.getViewVector(1.0);
                let normalizedVector = normalizeVector(viewVector);
                let spawn_entity = level.createEntity("cataclysm:sandstorm_projectile");
                spawn_entity.setPosition(player.x, player.y + 1, player.z);
                spawn_entity.setMotion(normalizedVector.x, normalizedVector.y, normalizedVector.z);
                spawn_entity.setOwner(player);
                spawn_entity.mergeNbt({ damage: 6 });
                spawn_entity.spawn();
            })
        }
    },
    'default': function (event, player, effectLevel, originalEffectName) {
        return
    }
}