// priority: 8
ItemEvents.foodEaten(event => {
    let player = event.player;
    if (!player) return;
    
    // 获取所有tetra饰品
    let tetraItems = getTetraCurios(player);
    if (!tetraItems || tetraItems.length === 0) return;
    
    // 用于累加相同效果的总等级
    let totalEffectLevels = {};

    // 遍历所有饰品，累加相同效果的等级
    for (let curioItem of tetraItems) {
        let effects = getAllEffects(curioItem);
        if (!effects) return

        effects.forEach(effectName => {
            let originalEffectName = effectName.key
            let effectLevel = simpleGetTetraEffectLevel(curioItem, originalEffectName);

            // 累加效果等级
            if (!totalEffectLevels[originalEffectName]) {
                totalEffectLevels[originalEffectName] = effectLevel
            } else {
                totalEffectLevels[originalEffectName] += effectLevel
            }
        })
    }

    // 第二步：遍历所有累加后的效果，执行对应策略
    for (let originalEffectName in totalEffectLevels) {
        let totalLevel = totalEffectLevels[originalEffectName];

        // 查找对应的策略并执行（传入总等级）
        let strategy = curios_tetra_food_eat_Strategies[originalEffectName] || curios_tetra_food_eat_Strategies.default;
        strategy(event, player, totalLevel, originalEffectName);
    }
});

const  curios_tetra_food_eat_Strategies = {
//消化器
'digester' : function (event,player,effectLevel,originalEffectName){
    let count = player.persistentData.getInt(YingYangCount)
    let nutrition = event.item.item.foodProperties.nutrition * 10
    let staturation =event.item.item.foodProperties.saturationModifier / 10
    updateYingYangCount(player, count + (nutrition + staturation) / 3)
},
'default': function (event,player,effectLevel,originalEffectName) {
    return
} 
}