// priority: 8
LootJS.modifiers(event => {
    event.addLootTypeModifier(LootType.ENTITY)
        .apply(event => {
            let player = event.player;
            if (!player) return;

            // 获取所有tetra饰品
            let tetraItems = getTetraCurios(player);
            if (!tetraItems || tetraItems.length === 0) return;

            // 用于累加相同效果的总等级
            let totalEffectLevels = {};

            // 遍历所有饰品，累加相同效果的等级
            for (let curioItem of tetraItems) {
                let effects = getAllEffects(curioItem);
                if (!effects) return

                effects.forEach(effectName => {
                    let originalEffectName = effectName.key
                    let effectLevel = simpleGetTetraEffectLevel(curioItem, originalEffectName);

                    // 累加效果等级
                    if (!totalEffectLevels[originalEffectName]) {
                        totalEffectLevels[originalEffectName] = effectLevel
                    } else {
                        totalEffectLevels[originalEffectName] += effectLevel
                    }
                })
            }

            // 第二步：遍历所有累加后的效果，执行对应策略
            for (let originalEffectName in totalEffectLevels) {
                let totalLevel = totalEffectLevels[originalEffectName];

                // 查找对应的策略并执行（传入总等级）
                let strategy = curios_entity_loot_Strategies[originalEffectName] || curios_entity_loot_Strategies.default;
                strategy(event, player, totalLevel, originalEffectName);
            }
        })
})
const  curios_entity_loot_Strategies = {
//抢夺加成
'qiang_duo' : function (event,player,effectLevel,originalEffectName){
    let random = Math.random()
    if (random < effectLevel * 0.2){
        event.loot.forEach(loot => {
            loot.setCount(loot.getCount() + 1)
        })
    }
},
'default': function (event,player,effectLevel,originalEffectName) {
    return
} 
}