// priority: 8
//关闭背包事件
PlayerEvents.inventoryClosed(event => {
    let player = event.player;
    if (!player) return;
    curios_attribute(event)
});
//玩家登录事件
PlayerEvents.loggedIn(event => {
    let player = event.player;
    if (!player) return;
    curios_attribute(event)
})
//玩家重生事件
PlayerEvents.respawned(event => {
    let player = event.player;
    if (!player) return;
    curios_attribute(event)
})
function curios_attribute(event) {
    let player = event.player;
    if (!player) return;

    // 获取所有tetra饰品
    let tetraItems = getTetraCurios(player)
    if (!tetraItems || tetraItems.length === 0) return;

    // 用于累加相同效果的总等级
    let totalEffectLevels = {};

    // 遍历所有饰品，累加相同效果的等级
    for (let curioItem of tetraItems) {
        let effects = getAllEffects(curioItem);
        if (!effects) return
        effects.forEach(effectName => {
            let originalEffectName = effectName.key

            // 获取当前饰品上该效果的等级
            let effectLevel = simpleGetTetraEffectLevel(curioItem, originalEffectName)

            // 累加效果等级
            if (!totalEffectLevels[originalEffectName]) {
                totalEffectLevels[originalEffectName] = effectLevel
            } else {
                totalEffectLevels[originalEffectName] += effectLevel
            }
        })
    }

    //遍历所有累加后的效果，执行对应策略
    for (let originalEffectName in totalEffectLevels) {
        let totalLevel = totalEffectLevels[originalEffectName];

        // 查找对应的策略并执行
        let strategy = curios_tetra_attribute_Strategies[originalEffectName] || curios_tetra_attribute_Strategies.default;
        strategy(event, player, totalLevel, originalEffectName);
    }
}
//如果想移除装备时，移除增幅，记得填remove_attribute_and_persistentData
const curios_tetra_attribute_Strategies = {
    // 台阶高度
    'tai_jie_gao_du': function (event, player, effectLevel, originalEffectName) {
        let isEnabled = player.persistentData.getBoolean(originalEffectName) ?? false;

        if (isEnabled) {
            player.modifyAttribute('forge:step_height_addition', originalEffectName + 'curios', effectLevel / 5, 'addition');
        } else {
            player.modifyAttribute('forge:step_height_addition', originalEffectName + 'curios', 0, 'addition');
        }
    },
    
    // 击退抗性
    'attack_knockback_addition': function (event, player, effectLevel, originalEffectName) {
        player.modifyAttribute('minecraft:generic.knockback_resistance', originalEffectName + 'curios', effectLevel/100, 'addition')
    },
    // 游泳速度
    'pestilence_attribute': function (event, player, effectLevel, originalEffectName) {
        player.modifyAttribute('kubejs:pestilence', originalEffectName + 'curios', effectLevel, 'addition')
    },
    // 游泳速度
    'swim_attribute': function (event, player, effectLevel, originalEffectName) {
        player.modifyAttribute('forge:swim_speed', originalEffectName + 'curios', effectLevel / 100, 'addition')
    },
    // 攻速增加
    'attack_speed_addition': function (event, player, effectLevel, originalEffectName) {
        player.modifyAttribute('minecraft:generic.attack_speed', originalEffectName + 'curios', effectLevel / 100, 'multiply_base')
    },
    // 攻速减少
    'attack_speed_decrease': function (event, player, effectLevel, originalEffectName) {
        player.modifyAttribute('minecraft:generic.attack_speed', originalEffectName + 'curios', -effectLevel / 100, 'multiply_base')
    },
    // 生命增幅
    'attribute_maxhealth': function (event, player, effectLevel, originalEffectName) {
        player.modifyAttribute('minecraft:generic.max_health', originalEffectName + 'curios', effectLevel, 'addition')
    },
    // 加速
    'jia_su': function (event, player, effectLevel, originalEffectName) {
        player.modifyAttribute('minecraft:generic.movement_speed', originalEffectName + 'curios', effectLevel / 100, 'multiply_base')
    },
    // 沉重
    'chen_zhong': function (event, player, effectLevel, originalEffectName) {
        player.modifyAttribute('minecraft:generic.movement_speed', originalEffectName + 'curios', -effectLevel / 100, 'multiply_base')
    },
    // 防护减少
    'fang_hu_decrease': function (event, player, effectLevel, originalEffectName) {
        player.modifyAttribute('minecraft:generic.armor', originalEffectName + 'curios', -effectLevel / 100, 'multiply_base')
    },
    // 防护
    'fang_hu': function (event, player, effectLevel, originalEffectName) {
        player.modifyAttribute('minecraft:generic.armor', originalEffectName + 'curios', effectLevel, 'addition')
    },
    // 韧性
    'ren_xing': function (event, player, effectLevel, originalEffectName) {
        player.modifyAttribute('minecraft:generic.armor_toughness', originalEffectName + 'curios', effectLevel, 'addition')
    },
    // 幸运
    'xing_yun': function (event, player, effectLevel, originalEffectName) {
        player.modifyAttribute('minecraft:generic.luck', originalEffectName + 'curios', effectLevel, 'addition')
        player.modifyAttribute('pasterdream:luck', originalEffectName + 'curios', effectLevel, 'addition')
    },
    // 攻击加成
    'gong_ji_jia_cheng': function (event, player, effectLevel, originalEffectName) {
        player.modifyAttribute('minecraft:generic.attack_damage', originalEffectName + 'curios', effectLevel / 100, 'multiply_base')
    },
    // 经验
    'jing_yan': function (event, player, effectLevel, originalEffectName) {
        player.modifyAttribute('attributeslib:experience_gained', originalEffectName + 'curios', effectLevel / 5, 'addition')
    },
    // 距离
    'ju_li': function (event, player, effectLevel, originalEffectName) {
        player.modifyAttribute('forge:block_reach', originalEffectName + 'curios', effectLevel / 2, 'addition')
    },
    'default': function (event, player, effectLevel, originalEffectName) {
        return
    }
}
