// priority: 8
PlayerEvents.tick(event => {
    let player = event.entity;
    // 每秒执行一次
    if (player.age % 22 != 0 || !player) return

    // 获取物品的所有效果
    let effects = ModularItemHelper.getArmorEffectsLevel(player)
    effects.forEach((effect, effectValue) => {
        let originalEffectName = effect.key
        if (!originalEffectName) return
        // 查找对应的策略并执行
        let strategy = armor_time_strategies[originalEffectName] || armor_time_strategies.default;
        strategy(event, player, effectValue, originalEffectName);
    })
});

const armor_time_strategies = {
    //锻造升级——幻翼
    'upgrade_templates/phantom_membrane': function (event, player, effectValue, item, originalEffectName) {
        if (effectValue >= 4) {
            player.potionEffects.add('kubejs:zhou_yi', 20 * 6, 0)
        }
    },
    //锻造升级——暗金属
    'upgrade_templates/dark_ingot': function (event, player, effectValue, item, originalEffectName) {
        let health = player.getHealth()
        let maxHealth = player.getMaxHealth()
        if (health > maxHealth / 2)return

        let time = player.persistentData.getInt(originalEffectName) ?? 0
        let CD = Math.abs(player.age - time)
        if (CD < 20 * 60 * 2) return
        player.persistentData.putInt(originalEffectName, player.age)

        switch(effectValue){
            case 1 :
                player.potionEffects.add('born_in_chaos_v1:light_rampage', 20 * 60, 0);
                break;
            case 2:
                player.potionEffects.add('born_in_chaos_v1:strong_rampage', 20 * 60, 0);
                break;
            case 3:
                player.potionEffects.add('born_in_chaos_v1:furious_rampage', 20 * 60, 0);
                break;
            case 4:
                player.potionEffects.add('born_in_chaos_v1:rampant_rampage', 20 * 60, 0);
                break;
        }
    },
    //锻造升级——合金
    'upgrade_templates/netherite_ingot': function (event, player, effectValue, item, originalEffectName) {
        if (effectValue >= 2){
            player.potionEffects.add('minecraft:fire_resistance', 20 * 6, 0)
        }
        if (effectValue >= 4){
            player.potionEffects.add('minecraft:resistance', 20 * 6, 0)
        }
    },
    //脉冲风行者水晶
    'pulse_windrunner_crystal': function (event, player, effectValue, item, originalEffectName) {
        player.potionEffects.add('kubejs:fei_xing', 20 * 6, 2)
    },
    //风行者水晶
    'windrunner_crystal': function (event, player, effectValue, item, originalEffectName) {
        let dimension = player.level.getDimension()
        let meltdreamenergy = player.getAttribute('pasterdream:meltdreamenergy').getValue()
        if (dimension == 'pasterdream:wind_journey_world') {
            player.potionEffects.add('kubejs:fei_xing', 20 * 6, 0)
        } else if (meltdreamenergy >= 1) {
            player.potionEffects.add('kubejs:fei_xing', 20 * 6, 0)
            player.setAttributeBaseValue('pasterdream:meltdreamenergy', player.getAttribute('pasterdream:meltdreamenergy').getValue() - 1)
        }
    },
    //隔热层
    'insulation': function (event, player, effectValue, item, originalEffectName) {
        if (effectValue >= 4) {
            player.potionEffects.add('minecraft:fire_resistance', 20 * 10, 0)
        }
    },
    //血浆透析器
    'blooddialysisdevice': function (event, player, effectValue, originalEffectName) {
        let count = 0
        player.potionEffects.active.forEach(ctx => {
            if (ctx.effect.getCategory() == 'HARMFUL') {
                count++
            }
        });
        player.heal(count / 2 * effectValue)
    },
    //战术供氧器
    'tacticaloxygensupplydevice': function (event, player, effectValue, originalEffectName) {
        if (player.inWater) {
            let oxygen = player.persistentData.getInt('oxygen') ?? 0
            let oldAirSupply = player.getAirSupply()
            if (oxygen > 0 && oldAirSupply < 300) {
                player.setAirSupply(Math.min(oldAirSupply + 30, 300))
                player.persistentData.putInt('oxygen', Math.max(0, oxygen - 1))
            }
        } else {
            let oxygen = player.persistentData.getInt('oxygen') ?? 0
            player.persistentData.putInt('oxygen', Math.min(20 * 600, oxygen + 10))
        }
    },
    //第三只眼
    'third_eye': function (event, player, effectValue, originalEffectName) {
        player.potionEffects.add('minecraft:night_vision', 20 * 60, 0);
    },
    //粘液球
    'play': function (event, player, effectValue, originalEffectName) {
        player.potionEffects.add('minecraft:jump_boost', 20 * 60, effectValue - 1);
    },
    'default': function (event, player, effectValue, originalEffectName) {
        return;
    }
};