// 目标切换事件
NativeEvents.onEvent($LivingChangeTargetEvent, event => {
    if (!event.getEntity().getLevel().isClientSide()) {
        let player = event.getNewTarget()
        if (player && player.isPlayer()) {
            let effects = ModularItemHelper.getArmorEffectsLevel(player)
            effects.forEach((effect, effectValue) => {
                let originalEffectName = effect.key
                if (!originalEffectName) return
                // 查找对应的策略并执行
                let strategy = armor_target_change_strategies[originalEffectName] || armor_target_change_strategies.default;
                strategy(event, player, effectValue, originalEffectName);
            })
        }
    }
})
const armor_target_change_strategies = {
    // 遗忘者
    'forgotten': function (event, player, effectValue, item, originalEffectName) {
        let time = player.persistentData.getInt(originalEffectName) ?? 0
        let CD = Math.abs(player.age - time)
        if (CD < 20 * 60 * 2) return
        
        event.setNewTarget(null)
    },
    'default': function (event, player, effectValue, originalEffectName) {
        return;
    }
};