// priority: 8
function tetra_wear_event_1(event){
    let player = event.entity
    // 获取物品的所有效果
    let effects = ModularItemHelper.getArmorEffectsLevel(player)
    effects.forEach((effect, effectValue) => {
        let originalEffectName = effect.key
        if (!originalEffectName) return
        // 查找对应的策略并执行
        let strategy = armor_hurt_strategies[originalEffectName] || armor_hurt_strategies.default;
        strategy(event, player, effectValue, originalEffectName);
    })
}

const armor_hurt_strategies = {
    // 锻造模板——咒魂
    'upgrade_templates/cursium_ingot': function (event, player, effectValue, originalEffectName) {
        //获取玩家最大生命值
        let maxHealth = player.getMaxHealth()
        //如果受到的伤害小于当前生命值，返回
        if (event.amount < player.getHealth()) return
        
        let time = player.persistentData.getInt(originalEffectName) ?? 0
        let CD = Math.abs(player.age - time)
        if (CD < 20 * 60 * 2) return
        player.persistentData.putInt(originalEffectName, player.age)

        if (effectValue >= 2){
            //反之受到的伤害设置为0，并恢复百分之50生命值
            event.amount = 0
            player.heal(maxHealth * 0.5)
        }
    },
    // 骸骨之心镶嵌效果
    'bone_heart': function (event, player, effectValue, originalEffectName) {
        let time = player.persistentData.getInt(originalEffectName) ?? 0
        let CD = Math.abs(player.age - time)
        if (CD < 200) return
        player.persistentData.putInt(originalEffectName, player.age)
        // 免疫伤害
        event.amount = 0;
    },
    //凝风铁锭
    'wind_iron_ingot': function (event, player, effectValue, originalEffectName) {
        let time = player.persistentData.getInt(originalEffectName) ?? 0
        let CD = Math.abs(player.age - time)
        if (CD < 40) return
        player.persistentData.putInt(originalEffectName, player.age)

        getLivingWithinRadius(player.getLevel(), new Vec3d(player.x, player.y, player.z), 4).forEach(entity => {
            //排除玩家
            if (entity.getStringUuid() != player.getStringUuid()) {
                entity.move('self', (new Vec3d(entity.x - player.x, entity.y - player.y, entity.z - player.z)).scale(2))
            }
        })
    },
    //闪避
    'tetra_dodge': function (event, player, effectValue, originalEffectName) {
        let random = Math.random();
        if (random < effectValue / 100) {
            event.amount = 0
        }
    },
    //摔落减免
    'fall_reduction': function (event, player, effectValue, originalEffectName) {
        let type = event.getSource().getType().toString();
        if (type = 'fall') {
            event.amount = event.amount * (1 - effectValue / 100)
        }
    },
    //重甲的受伤减少
    'resistance': function (event, player, effectValue, originalEffectName) {
        event.amount = event.amount * (1 - effectValue/100)
    },
    'default': function (event, player, effectValue, originalEffectName) {
        return;
    }
};