// priority: 8
function tetra_wear_event_attack(event){
    let player = event.source.actual
    if (!player || !player.isPlayer()) return
    // 获取物品的所有效果
    let effects = ModularItemHelper.getArmorEffectsLevel(player)
    effects.forEach((effect, effectValue) => {
        let originalEffectName = effect.key
        if (!originalEffectName) return
        // 查找对应的策略并执行
        let strategy = armor_damage_strategies[originalEffectName] || armor_damage_strategies.default;
        strategy(event, player, effectValue, originalEffectName);
    })
}

const armor_damage_strategies = {
    // 遗忘者
    'forgotten': function (event, player, effectValue, item, originalEffectName) {
        let time = player.persistentData.getInt(originalEffectName) ?? 0
        let CD = Math.abs(player.age - time)
        if (CD < 20 * 60 * 2) return
        player.persistentData.putInt(originalEffectName, player.age)
        
        event.amount = event.amount * (1 + effectValue / 100)
        
    },
    'default': function (event, player, effectValue, originalEffectName) {
        return;
    }
};