// priority: 8
//关闭背包事件
PlayerEvents.inventoryClosed(event => {
    let player = event.player;
    if (!player) return;
    armor_attribute(event)
});
//玩家登录事件
PlayerEvents.loggedIn(event => {
    let player = event.player;
    if (!player) return;
    armor_attribute(event)
})
//玩家重生事件
PlayerEvents.respawned(event => {
    let player = event.player;
    if (!player) return;
    armor_attribute(event)
})
function armor_attribute(event) {
    let player = event.player;

    // 获取物品的所有效果
    let effects = ModularItemHelper.getArmorEffectsLevel(player)
    effects.forEach((effect, effectValue) => {
        let originalEffectName = effect.key
        if (!originalEffectName) return
        // 查找对应的策略并执行
        let strategy = armor_tetra_attribute_Strategies[originalEffectName] || armor_tetra_attribute_Strategies.default;
        strategy(event, player, effectValue, originalEffectName);
    })
}
//如果想移除装备时，移除增幅，记得填remove_attribute_and_persistentData
const armor_tetra_attribute_Strategies = {
    // 击退抗性
    'attack_knockback_addition': function (event, player, effectValue, originalEffectName) {
        player.modifyAttribute('minecraft:generic.knockback_resistance', originalEffectName + 'armor', effectValue / 100, 'addition')
    },
    // 游泳速度
    'pestilence_attribute': function (event, player, effectValue, originalEffectName) {
        player.modifyAttribute('kubejs:pestilence', originalEffectName + 'armor', effectValue, 'addition')
    },
    // 游泳速度
    'swim_attribute': function (event, player, effectValue, originalEffectName) {
        player.modifyAttribute('forge:swim_speed', originalEffectName + 'armor', effectValue / 100, 'addition')
    },
    // 鞘翅飞行
    'elytra': function (event, player, effectValue, originalEffectName) {
        player.modifyAttribute('caelus:fall_flying', originalEffectName + 'armor', 1, 'addition')
    },
    // 攻速增加
    'attack_speed_addition': function (event, player, effectValue, originalEffectName) {
        player.modifyAttribute('minecraft:generic.attack_speed', originalEffectName + 'armor', effectValue / 100, 'multiply_base')
    },
    // 攻速减少
    'attack_speed_decrease': function (event, player, effectValue, originalEffectName) {
        player.modifyAttribute('minecraft:generic.attack_speed', originalEffectName + 'armor', -effectValue / 100, 'multiply_base')
    },
    // 生命增幅
    'attribute_maxhealth': function (event, player, effectValue, originalEffectName) {
        player.modifyAttribute('minecraft:generic.max_health', originalEffectName + 'armor', effectValue, 'addition')
    },
    // 加速
    'jia_su': function (event, player, effectValue, originalEffectName) {
        player.modifyAttribute('minecraft:generic.movement_speed', originalEffectName + 'armor', effectValue / 100, 'multiply_base')
    },
    // 台阶高度
    'tai_jie_gao_du': function (event, player, effectValue, originalEffectName) {
        player.modifyAttribute('forge:step_height_addition', originalEffectName + 'armor', effectValue / 5, 'addition')
    },
    // 沉重
    'chen_zhong': function (event, player, effectValue, originalEffectName) {
        player.modifyAttribute('minecraft:generic.movement_speed', originalEffectName + 'armor', -effectValue / 100, 'multiply_base')
    },
    // 防护减少
    'fang_hu_decrease': function (event, player, effectValue, originalEffectName) {
        player.modifyAttribute('minecraft:generic.armor', originalEffectName + 'armor', -effectValue / 100, 'multiply_base')
    },
    // 防护
    'fang_hu': function (event, player, effectValue, originalEffectName) {
        player.modifyAttribute('minecraft:generic.armor', originalEffectName + 'armor', effectValue, 'addition')
    },
    // 韧性
    'ren_xing': function (event, player, effectValue, originalEffectName) {
        player.modifyAttribute('minecraft:generic.armor_toughness', originalEffectName + 'armor', effectValue, 'addition')
    },
    // 幸运
    'xing_yun': function (event, player, effectValue, originalEffectName) {
        player.modifyAttribute('minecraft:generic.luck', originalEffectName + 'armor', effectValue, 'addition')
        player.modifyAttribute('pasterdream:luck', originalEffectName + 'armor', effectValue, 'addition')
    },
    // 攻击加成
    'gong_ji_jia_cheng': function (event, player, effectValue, originalEffectName) {
        player.modifyAttribute('minecraft:generic.attack_damage', originalEffectName + 'armor', effectValue / 100, 'multiply_base')
    },
    // 经验
    'jing_yan': function (event, player, effectValue, originalEffectName) {
        player.modifyAttribute('attributeslib:experience_gained', originalEffectName + 'armor', effectValue / 5, 'addition')
    },
    // 距离
    'ju_li': function (event, player, effectValue, originalEffectName) {
        player.modifyAttribute('forge:block_reach', originalEffectName + 'armor', effectValue / 2, 'addition')
    },
    'default': function (event, player, effectValue, originalEffectName) {
        return
    }
}