const adapt_hurt = {
    'mob': '§3近战',
    'arrow': '§3箭矢',
    'magic': '§3魔法',
    'other': '§3其他'
}

//活体盔甲适应
function tetra_wear_adapt(event) {
    let player = event.entity
    //检测活体盔甲四件套
    if (arrmor_total_effect_level(player, 'living') >= 4) {
        let type = event.getSource().getType().toString()
        let damageType = adapt_hurt[type] || adapt_hurt['other']
        let storageKey = adapt_hurt[type] ? 'dadpt' + type : 'dadptother'

        if (player.persistentData.contains(storageKey)) {
            let amount = player.persistentData.getInt(storageKey)
            player.persistentData.putInt(storageKey, Math.min(amount + 2,15))
            if (amount < 15) {
                player.tell('活体盔甲结构进行了调整，受到的' + damageType + '伤害类型降低百分之' + Math.min(amount + 2, 15))
            }
        } else {
            // 初始化适应值
            player.persistentData.putInt(storageKey, 1)
            player.tell('活体盔甲开始适应' + damageType + '伤害类型，当前适应进度：1%,最多适应百分之15')
        }
    }
}
//适应受伤效果实现
//并非effect控制
function adapt_hurt_effect(event) {
    let player = event.entity
    let type = event.getSource().getType().toString()

    // 检测活体盔甲四件套
    if (arrmor_total_effect_level(player, 'living') >= 4) {
        let storageKey = adapt_hurt[type] ? 'dadpt' + type : 'dadptother'

        if (player.persistentData.contains(storageKey)) {
            let reductionPercent = Math.min(player.persistentData.getInt(storageKey), 15)
            let reductionFactor = 1 - (reductionPercent / 100)
            event.amount = event.amount * reductionFactor
        }
    }
}
//适应
PlayerEvents.tick(event => {
    let player = event.player
    if (player.age % 20 !== 0 || !player) return;
    let itemList = [
        player.getHeadArmorItem(),
        player.getChestArmorItem(),
        player.getLegsArmorItem(),
        player.getFeetArmorItem()
    ]
    if (arrmor_total_effect_level(player, 'living') < 4) return
    let nightlevel = getPlayerLightLevel(player)
    let random = Math.random() * 60


    // 每分钟减少1点适应值
    if (player.age % 1200 === 0) {
        let adaptTypes = ['mob', 'arrow', 'magic', 'other'];
        adaptTypes.forEach(type => {
            const key = type === 'other' ? 'dadptother' : `dadpt${type}`;
            if (player.persistentData.contains(key)) {
                let amount = player.persistentData.getInt(key);
                if (amount > 0) {
                    player.persistentData.putInt(key, amount - 1)
                    player.tell(`活体盔甲对${adapt_hurt[type]}伤害的适应度降低了1点`);
                    if (amount === 1) {
                        player.tell(`活体盔甲对${adapt_hurt[type]}伤害的适应已完全消失`);
                    }
                }
            }
        });
    }
    //适应黑暗
    if (nightlevel < 4 && random < 1 && !player.getHeadArmorItem().nbt.contains('helmet:armor/helmet/third_eye')){
        player.tell('恶意的血肉开始蔓生，你感到自己更加适应环境了…')
        player.tell('为了适应黑暗，活体头盔演化出了第三只眼')
        $ItemModuleMajor.addImprovement(player.getHeadArmorItem(), "helmet", "armor/helmet/third_eye", 0);
        $ModularItem.updateIdentifier(player.getHeadArmorItem());
    }
    //游泳速度加成
    if (player.isInWater() && random < 1 && !has_improvement(player.getFeetArmorItem(),'armor/feet/adapt_swim')){
        player.tell('恶意的血肉开始蔓生，你感到自己更加适应环境了…')
        player.tell('你感到水中的自己更加灵动了')
        $ItemModuleMajor.addImprovement(player.getFeetArmorItem(), "feet", "armor/feet/adapt_swim", 0);
        $ModularItem.updateIdentifier(player.getFeetArmorItem());
    }
    //移动速度加成
    if (player.isMoving() && random < 0.1 && !has_improvement(player.getFeetArmorItem(), 'armor/feet/adapt_move')) {
        player.tell('恶意的血肉开始蔓生，你感到自己更加适应环境了…')
        player.tell('你感到自己更加灵动了')
        $ItemModuleMajor.addImprovement(player.getFeetArmorItem(), "feet", "armor/feet/adapt_move", 0);
        $ModularItem.updateIdentifier(player.getFeetArmorItem());
    }
    //反伤，活体盔甲自己攻击

    //抗火效果
})