// priority: 8
PlayerEvents.tick(event => {
    let player = event.player
    // 每秒执行一次
    if (player.age % 25 != 0 || !player) return

    let effects = get_all_effect(player);

    Object.entries(effects).forEach(([originalEffectName, effectLevel]) => {
        let strategy = all_effect_tick_strategies[originalEffectName] || all_effect_tick_strategies.default;
        strategy(event, player, effectLevel, originalEffectName);
    });
})
const all_effect_tick_strategies = {
    //应力
    'occupation_stress': function (event, player, effectLevel, originalEffectName) {
        let effects = get_all_effect(player);
        let effect_level = 0
        Object.entries(effects).forEach(([originalEffectName, effectLevel]) => {
            if (originalEffectName == 'stress') {
                effect_level += effectLevel
            }
        });
        if (effectLevel >= effect_level) {
            player.tell('应力过载')
            player.potionEffects.add('minecraft:slowness', 40, 5);
            player.potionEffects.add('minecraft:mining_fatigue', 40, 5);
        }
    },
    //鞘翅飞行
    'elytra': function (event, player, effectLevel, originalEffectName) {
        player.potionEffects.add('kubejs:zhou_yi', 20 * 6, 0)
    },
    //飞行
    'fei_xing': function (event, player, effectLevel, originalEffectName) {
        player.potionEffects.add('kubejs:fei_xing', 20 * 6, 0)
    },
    'default': function (event, player, effectLevel, originalEffectName) {
        return;
    }
};