// priority: 8
function tetra_effect_immunity(event) {
    let player = event.entity
    if (!player.isPlayer()) return;
    //获取buff
    let effectInstance = event.getEffectInstance()
    let buff = effectInstance.getEffect().getDescriptionId()

    let effects = get_all_effect(player);

    Object.entries(effects).forEach(([originalEffectName, effectLevel]) => {
        let strategy = all_effect_effect_immunity_strategies[originalEffectName] || all_effect_effect_immunity_strategies.default;
        strategy(event, player, effectLevel, originalEffectName,buff);
    });
}
const all_effect_effect_immunity_strategies = {
    //失明免疫
    'blindness_immunity': function (event, player, effectLevel, originalEffectName, buff) {
        if (buff == 'effect.minecraft.blindness') {
            event.setResult(Event$Result.DENY)
        }
    },
    //漂浮免疫
    'levitation_immunity': function (event, player, effectLevel, originalEffectName, buff) {
        if (buff == 'effect.minecraft.levitation') {
            event.setResult(Event$Result.DENY)
        }
    },
    //黑暗免疫
    'darkness_immunity': function (event, player, effectLevel, originalEffectName, buff) {
        if (buff == 'effect.minecraft.darkness'){
            event.setResult(Event$Result.DENY)
        }
    },
    'default': function (event, player, effectLevel, originalEffectName,buff) {
        return;
    }
};