// priority: 8
// 生物死亡事件
NativeEvents.onEvent($LivingDeathEvent, event => {
    let player = event.source?.player;
    if (!player) return;

    let effects = get_all_effect(player);

    Object.entries(effects).forEach(([originalEffectName, effectValue]) => {
        let strategy = all_effect_death_strategies[originalEffectName] || all_effect_death_strategies.default;
        strategy(event, player, effectValue, originalEffectName);
    });
})
const all_effect_death_strategies = {
    //炼金
    'alchemy': function (event, player, effectValue,  originalEffectName) {
        let random = Math.random();
        if (random < effectValue/100) {
            player.give(Item.of('minecraft:gold_block').withCount(1));
        }
    },
    'default': function (event, player, effectValue, originalEffectName) {
        return;
    }
};